/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation;

import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.MeterRepresentation;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

public class CounterRepresentation
extends MeterRepresentation
implements Counter {
    private double count;
    private double update;
    private List<Measurement> measurements;

    private CounterRepresentation(JsonObject object, String ... tags) {
        super(object, Meter.Type.COUNTER, tags);
        JsonArray ja = object.getJsonArray("measurements");
        JsonObject jo = ja.getJsonObject(0);
        if (ja.size() > 1 || Statistic.valueOf((String)jo.getString("statistic")) != Statistic.COUNT) {
            throw new IllegalArgumentException("This object does not map a valid Counter!");
        }
        this.count = jo.getJsonNumber("value").doubleValue();
        this.update = 0.0;
        this.measurements = new ArrayList<Measurement>();
        this.measurements.add(new Measurement(() -> this.count(), Statistic.COUNT));
    }

    private CounterRepresentation(String name) {
        super(name, Meter.Type.COUNTER);
        this.count = 0.0;
        this.update = 0.0;
        this.measurements = new ArrayList<Measurement>();
        this.measurements.add(new Measurement(() -> this.count, Statistic.COUNT));
    }

    public static Counter parseCounter(JsonObject object, String ... tags) {
        return new CounterRepresentation(object, tags);
    }

    public static Counter createNewCounter(String name) {
        return new CounterRepresentation(name);
    }

    public void increment(double amount) {
        if (amount < 0.0) {
            throw new IllegalArgumentException("Counters may never be reset to a lesser value!");
        }
        this.count += amount;
        this.update += amount;
    }

    public double count() {
        return this.count;
    }

    @Override
    public Iterable<Measurement> measure() {
        return this.measurements;
    }

    @Override
    public JsonObject getUpdater() {
        JsonObjectBuilder job = Json.createObjectBuilder();
        job.add("name", this.getId().getName());
        job.add("increment", this.update);
        return job.build();
    }
}

