/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.metricsProvider;

import de.iip_ecosphere.platform.connectors.types.ChannelTranslatingProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.ConnectorInputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ConnectorOutputTypeTranslator;
import de.iip_ecosphere.platform.services.environment.metricsProvider.LogRunnable;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import io.micrometer.core.instrument.Clock;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;

public class MonitoredTranslatingProtocolAdapter<O, I, CO, CI>
extends ChannelTranslatingProtocolAdapter<O, I, CO, CI> {
    public static final String ADAPT_INPUT_TIME = "adaptInputTime";
    public static final String ADAPT_OUTPUT_TIME = "adaptOutputTime";
    private MetricsProvider metrics;
    private Clock clock;
    private LogRunnable logger;

    public MonitoredTranslatingProtocolAdapter(ConnectorOutputTypeTranslator<O, CO> outputTranslator, ConnectorInputTypeTranslator<CI, I> inputTranslator, MetricsProvider metrics, File log) {
        this("", outputTranslator, "", inputTranslator, metrics, log);
    }

    public MonitoredTranslatingProtocolAdapter(String outputChannel, ConnectorOutputTypeTranslator<O, CO> outputTranslator, String inputChannel, ConnectorInputTypeTranslator<CI, I> inputTranslator, MetricsProvider metrics, File log) {
        super(outputChannel, outputTranslator, inputChannel, inputTranslator);
        this.metrics = metrics;
        this.clock = metrics.getClock();
        if (null != log) {
            try {
                this.logger = new LogRunnable(log);
                new Thread(this.logger).start();
            }
            catch (IOException e) {
                this.logger = null;
                LoggerFactory.getLogger(MonitoredTranslatingProtocolAdapter.class).error("Cannot create log file " + this.logger + ": " + e.getMessage());
            }
        }
    }

    private void log(String activity, long duration) {
        if (null != this.logger) {
            this.logger.log(activity, duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I adaptInput(CI data) throws IOException {
        long s = this.clock.monotonicTime();
        try {
            Object object = super.adaptInput(data);
            return (I)object;
        }
        finally {
            long duration = this.clock.monotonicTime() - s;
            this.metrics.recordWithTimer(ADAPT_INPUT_TIME, duration, TimeUnit.NANOSECONDS);
            this.log(ADAPT_INPUT_TIME, duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CO adaptOutput(O data) throws IOException {
        long s = this.clock.monotonicTime();
        try {
            Object object = super.adaptOutput(data);
            return (CO)object;
        }
        finally {
            long duration = this.clock.monotonicTime() - s;
            this.metrics.recordWithTimer(ADAPT_OUTPUT_TIME, duration, TimeUnit.NANOSECONDS);
            this.log(ADAPT_OUTPUT_TIME, duration);
        }
    }
}

