/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.metricsProvider;

import com.google.common.util.concurrent.AtomicDouble;
import com.sun.management.OperatingSystemMXBean;
import de.iip_ecosphere.platform.services.environment.UpdatingMonitoringService;
import de.iip_ecosphere.platform.services.environment.metricsProvider.CapacityBaseUnit;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.search.MeterNotFoundException;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class MetricsProvider {
    public static final List<Tag> EMPTY_TAGS = Collections.unmodifiableList(new ArrayList());
    public static final String GAUGE_LIST = "gaugelist";
    public static final String COUNTER_LIST = "counterlist";
    public static final String TIMER_LIST = "timerlist";
    public static final String TAGGED_METER_LIST = "taggedmeterlist";
    public static final String SIMPLE_METER_LIST = "simplemeterlist";
    public static final String SYS_MEM_TOTAL = "system.memory.total";
    public static final String SYS_MEM_FREE = "system.memory.free";
    public static final String SYS_MEM_USED = "system.memory.used";
    public static final String SYS_MEM_USAGE = "system.memory.usage";
    public static final String SYS_DISK_TOTAL = "system.disk.total";
    public static final String SYS_DISK_FREE = "system.disk.free";
    public static final String SYS_DISK_USABLE = "system.disk.usable";
    public static final String SYS_DISK_USED = "system.disk.used";
    protected static final String ID_NOT_FOUND_ERRMSG = ": no item found with this identifier!";
    protected static final String NON_POSITIVE_ERRMSG = ": is not a positive number!";
    protected static final String NULL_ARG = " has a null value. This argument cannot be null!";
    private final MeterRegistry registry;
    private final OperatingSystemMXBean osmxb;
    private boolean init;
    private Clock clock;
    private List<UpdatingMonitoringService> updaters;
    private CapacityBaseUnit memoryBaseUnit = CapacityBaseUnit.BYTES;
    private CapacityBaseUnit diskBaseUnit = CapacityBaseUnit.KILOBYTES;
    private final Map<String, AtomicDouble> gauges;
    private final Map<String, Counter> counters;
    private final Map<String, Timer> timers;
    private double sysMemTotal;
    private double sysMemFree;
    private double sysMemUsed;
    private double sysMemUsage;
    private double sysDiskTotal;
    private double sysDiskFree;
    private double sysDiskUsable;
    private double sysDiskUsed;

    public MetricsProvider(MeterRegistry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("Registry is null!");
        }
        this.registry = registry;
        this.clock = registry.config().clock();
        this.osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        this.gauges = new HashMap<String, AtomicDouble>();
        this.counters = new HashMap<String, Counter>();
        this.timers = new HashMap<String, Timer>();
        this.init = true;
    }

    public MeterRegistry getRegistry() {
        return this.registry;
    }

    public Clock getClock() {
        return this.clock;
    }

    public void registerNonNativeSystemMetrics() {
        this.registerMemoryMetrics();
        this.registerDiskMetrics();
        Gauge.builder((String)SYS_MEM_USAGE, () -> this.sysMemUsage).description("Current percentage of physical memory in use").register(this.registry);
    }

    public void registerMemoryMetrics() {
        Gauge.builder((String)SYS_MEM_TOTAL, () -> this.sysMemTotal).description("Total Physical memory of the system").baseUnit(this.memoryBaseUnit.stringValue()).register(this.registry);
        Gauge.builder((String)SYS_MEM_FREE, () -> this.sysMemFree).description("Free Physical memory of the system").baseUnit(this.memoryBaseUnit.stringValue()).register(this.registry);
        Gauge.builder((String)SYS_MEM_USED, () -> this.sysMemUsed).description("Physical memory currently in use").baseUnit(this.memoryBaseUnit.stringValue()).register(this.registry);
    }

    public void registerDiskMetrics() {
        Gauge.builder((String)SYS_DISK_TOTAL, () -> this.sysDiskTotal).description("Total disk capacity of the system").baseUnit(this.diskBaseUnit.stringValue()).register(this.registry);
        Gauge.builder((String)SYS_DISK_FREE, () -> this.sysDiskFree).description("Total free disk capacity of the system").baseUnit(this.diskBaseUnit.stringValue()).register(this.registry);
        Gauge.builder((String)SYS_DISK_USABLE, () -> this.sysDiskUsable).description("Total usable disk capacity of the system").baseUnit(this.diskBaseUnit.stringValue()).register(this.registry);
        Gauge.builder((String)SYS_DISK_USED, () -> this.sysDiskUsed).description("Current total disk capacity currently in use or unavailable").baseUnit(this.diskBaseUnit.stringValue()).register(this.registry);
    }

    public void removeMemoryMetrics() {
        this.registry.remove(this.registry.get(SYS_MEM_TOTAL).meter());
        this.registry.remove(this.registry.get(SYS_MEM_FREE).meter());
        this.registry.remove(this.registry.get(SYS_MEM_USED).meter());
    }

    public void removeDiskMetrics() {
        this.registry.remove(this.registry.get(SYS_DISK_TOTAL).meter());
        this.registry.remove(this.registry.get(SYS_DISK_FREE).meter());
        this.registry.remove(this.registry.get(SYS_DISK_USABLE).meter());
        this.registry.remove(this.registry.get(SYS_DISK_USED).meter());
    }

    public int getNumberOfCustomGauges() {
        return this.gauges.size();
    }

    public int getNumberOfCustomCounters() {
        return this.counters.size();
    }

    public int getNumberOfCustomTimers() {
        return this.timers.size();
    }

    public void addGaugeValue(String gaugeId, double value) {
        if (gaugeId == null) {
            throw new IllegalArgumentException("gaugeId has a null value. This argument cannot be null!");
        }
        if (this.gauges.containsKey(gaugeId)) {
            this.gauges.get(gaugeId).set(value);
        } else {
            AtomicDouble gauge = (AtomicDouble)this.registry.gauge(gaugeId, (Number)new AtomicDouble(value));
            this.gauges.put(gaugeId, gauge);
        }
    }

    public void removeGauge(String gaugeId) {
        if (!this.gauges.containsKey(gaugeId)) {
            throw new IllegalArgumentException(gaugeId + ID_NOT_FOUND_ERRMSG);
        }
        this.gauges.remove(gaugeId);
        this.registry.remove(this.registry.get(gaugeId).meter());
    }

    public double getGaugeValue(String gaugeId) {
        if (this.gauges.containsKey(gaugeId)) {
            return this.gauges.get(gaugeId).doubleValue();
        }
        return 0.0;
    }

    public double getRegisteredGaugeValue(String gaugeId) {
        try {
            return this.registry.get(gaugeId).gauge().value();
        }
        catch (MeterNotFoundException e) {
            return this.getGaugeValue(gaugeId);
        }
    }

    private void addCounter(String counterId) {
        Counter counter = this.registry.counter(counterId, new String[0]);
        this.counters.put(counterId, counter);
    }

    public void increaseCounterBy(String counterId, double value) {
        if (counterId == null) {
            throw new IllegalArgumentException("counterId has a null value. This argument cannot be null!");
        }
        if (value < 0.0) {
            throw new IllegalArgumentException(value + NON_POSITIVE_ERRMSG);
        }
        if (!this.counters.containsKey(counterId)) {
            this.addCounter(counterId);
        }
        this.counters.get(counterId).increment(value);
    }

    public void increaseCounter(String counterId) {
        this.increaseCounterBy(counterId, 1.0);
    }

    public void removeCounter(String counterId) {
        if (!this.counters.containsKey(counterId)) {
            throw new IllegalArgumentException(counterId + ID_NOT_FOUND_ERRMSG);
        }
        this.counters.remove(counterId);
        this.registry.remove(this.registry.get(counterId).meter());
    }

    public double getCounterValue(String counterId) {
        if (this.counters.containsKey(counterId)) {
            return this.counters.get(counterId).count();
        }
        return 0.0;
    }

    public double getRegisteredCounterValue(String counterId) {
        try {
            return this.registry.get(counterId).counter().count();
        }
        catch (MeterNotFoundException e) {
            return this.getCounterValue(counterId);
        }
    }

    protected void addTimer(String timerId) {
        if (timerId == null) {
            throw new IllegalArgumentException("timerId has a null value. This argument cannot be null!");
        }
        Timer timer = this.registry.timer(timerId, new String[0]);
        this.timers.put(timerId, timer);
    }

    public void removeTimer(String timerId) {
        if (!this.timers.containsKey(timerId)) {
            throw new IllegalArgumentException(timerId + ID_NOT_FOUND_ERRMSG);
        }
        this.timers.remove(timerId);
        this.registry.remove(this.registry.get(timerId).meter());
    }

    public void recordWithTimer(String timerId, Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable has a null value. This argument cannot be null!");
        }
        if (!this.timers.containsKey(timerId)) {
            this.addTimer(timerId);
        }
        this.timers.get(timerId).record(runnable);
    }

    public <T> T recordWithTimer(String timerId, Supplier<T> supplier) {
        if (supplier == null) {
            throw new IllegalArgumentException("supplier has a null value. This argument cannot be null!");
        }
        if (!this.timers.containsKey(timerId)) {
            this.addTimer(timerId);
        }
        return (T)this.timers.get(timerId).record(supplier);
    }

    public void recordWithTimer(String timerId, long time, TimeUnit unit) {
        if (time < 0L) {
            throw new IllegalArgumentException("cannot record negative time!");
        }
        if (unit == null) {
            throw new IllegalArgumentException("unit has a null value. This argument cannot be null!");
        }
        if (!this.timers.containsKey(timerId)) {
            this.addTimer(timerId);
        }
        this.timers.get(timerId).record(time, unit);
    }

    public double getTotalTimeFromTimer(String timerId) {
        if (this.timers.containsKey(timerId)) {
            Timer t = this.timers.get(timerId);
            return t.totalTime(t.baseTimeUnit());
        }
        return 0.0;
    }

    public double getMaxTimeFromTimer(String timerId) {
        if (this.timers.containsKey(timerId)) {
            Timer t = this.timers.get(timerId);
            return t.max(t.baseTimeUnit());
        }
        return 0.0;
    }

    public long getTimerCount(String timerId) {
        if (this.timers.containsKey(timerId)) {
            return this.timers.get(timerId).count();
        }
        return 0L;
    }

    public long getRegisteredTimerCount(String timerId) {
        try {
            return this.registry.get(timerId).timer().count();
        }
        catch (MeterNotFoundException e) {
            return this.getTimerCount(timerId);
        }
    }

    public void addService(UpdatingMonitoringService service) {
        if (null != service) {
            if (null == this.updaters) {
                this.updaters = new ArrayList<UpdatingMonitoringService>();
            }
            if (!this.updaters.contains(service)) {
                this.updaters.add(service);
            }
        }
    }

    public void calculateMetrics() {
        this.calculateNonNativeSystemMetrics();
        if (null != this.updaters) {
            for (int i = this.updaters.size() - 1; i >= 0; --i) {
                this.updaters.get(i).calculateMetrics();
            }
        }
    }

    public void calculateNonNativeSystemMetrics() {
        if (this.init) {
            this.registerNonNativeSystemMetrics();
            this.init = false;
        }
        this.sysMemTotal = (double)this.osmxb.getTotalPhysicalMemorySize() / this.memoryBaseUnit.byteValue();
        this.sysMemFree = (double)this.osmxb.getFreePhysicalMemorySize() / this.memoryBaseUnit.byteValue();
        this.sysMemUsed = this.sysMemTotal - this.sysMemFree;
        this.sysMemUsage = this.sysMemUsed / this.sysMemTotal;
        File[] dirs = File.listRoots();
        this.sysDiskTotal = 0.0;
        this.sysDiskFree = 0.0;
        this.sysDiskUsable = 0.0;
        for (File dir : dirs) {
            this.sysDiskTotal += (double)dir.getTotalSpace();
            this.sysDiskFree += (double)dir.getFreeSpace();
            this.sysDiskUsable += (double)dir.getUsableSpace();
        }
        this.sysDiskTotal /= this.diskBaseUnit.byteValue();
        this.sysDiskFree /= this.diskBaseUnit.byteValue();
        this.sysDiskUsable /= this.diskBaseUnit.byteValue();
        this.sysDiskUsed = this.sysDiskTotal - this.sysDiskFree;
    }

    public void setMemoryBaseUnit(CapacityBaseUnit memoryBaseUnit) {
        if (memoryBaseUnit == null) {
            throw new IllegalArgumentException("memoryBaseUnit has a null value. This argument cannot be null!");
        }
        this.memoryBaseUnit = memoryBaseUnit;
    }

    public CapacityBaseUnit getMemoryBaseUnit() {
        return this.memoryBaseUnit;
    }

    public void setDiskBaseUnit(CapacityBaseUnit diskBaseUnit) {
        if (diskBaseUnit == null) {
            throw new IllegalArgumentException((Object)((Object)diskBaseUnit) + NULL_ARG);
        }
        this.diskBaseUnit = diskBaseUnit;
    }

    public CapacityBaseUnit getDiskBaseUnit() {
        return this.diskBaseUnit;
    }

    public String getMeter(String name, Iterable<Tag> tags) {
        try {
            Meter meter = this.registry.get(name).tags(tags).meter();
            return this.jsonParser(meter);
        }
        catch (MeterNotFoundException mnfe) {
            throw new IllegalArgumentException(mnfe.getMessage());
        }
    }

    public String toJson(String identifier, boolean update) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (null != identifier) {
            sb.append("\"id\":\"" + identifier + "\",");
        }
        sb.append("\"meters\":{");
        boolean first = true;
        for (Meter meter : this.registry.getMeters()) {
            if (!first) {
                sb.append(",");
            }
            sb.append("\"" + meter.getId().getName() + "\":");
            sb.append(this.jsonParser(meter));
            first = false;
        }
        sb.append("},");
        this.appendNameValue(sb, GAUGE_LIST, this.getCustomGaugeList(), true);
        this.appendNameValue(sb, COUNTER_LIST, this.getCustomCounterList(), true);
        this.appendNameValue(sb, TIMER_LIST, this.getCustomTimerList(), true);
        this.appendNameValue(sb, TAGGED_METER_LIST, this.getTaggedMeterList(), true);
        this.appendNameValue(sb, SIMPLE_METER_LIST, this.getSimpleMeterList(), false);
        sb.append("}");
        return sb.toString();
    }

    private void appendNameValue(StringBuilder sb, String name, String value, boolean separator) {
        sb.append("\"" + name + "\":" + value);
        if (separator) {
            sb.append(",");
        }
    }

    public String getGauge(String name) {
        if (!this.gauges.containsKey(name)) {
            throw new IllegalArgumentException(name + ID_NOT_FOUND_ERRMSG);
        }
        return this.jsonParser((Meter)this.registry.get(name).gauge());
    }

    public String getCounter(String name) {
        if (!this.counters.containsKey(name)) {
            throw new IllegalArgumentException(name + ID_NOT_FOUND_ERRMSG);
        }
        return this.jsonParser((Meter)this.registry.get(name).counter());
    }

    public String getTimer(String name) {
        if (!this.timers.containsKey(name)) {
            throw new IllegalArgumentException(name + ID_NOT_FOUND_ERRMSG);
        }
        return this.jsonParser((Meter)this.registry.get(name).timer());
    }

    private String jsonParser(Meter meter) {
        String description = meter.getId().getDescription();
        if (description != null) {
            description = description.replaceAll("\"", "''");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\"name\":\"").append(meter.getId().getName()).append("\",");
        sb.append("\"description\":\"").append(description).append("\",");
        sb.append("\"baseUnit\":\"").append(meter.getId().getBaseUnit()).append("\",");
        sb.append("\"measurements\":[");
        for (Measurement m : meter.measure()) {
            sb.append("{");
            sb.append("\"statistic\":\"").append(m.getStatistic().toString()).append("\",");
            sb.append("\"value\":").append(String.format(Locale.ROOT, "%f", m.getValue()));
            sb.append("},");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("],\"availableTags\":[]}");
        return sb.toString();
    }

    public String getCustomGaugeList() {
        return this.mapJsonParser(this.gauges);
    }

    public String getCustomCounterList() {
        return this.mapJsonParser(this.counters);
    }

    public String getCustomTimerList() {
        return this.mapJsonParser(this.timers);
    }

    public String getTaggedMeterList() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("\"jvm.buffer.count\",");
        sb.append("\"jvm.buffer.memory.used\",");
        sb.append("\"jvm.buffer.total.capacity\",");
        sb.append("\"jvm.gc.pause\",");
        sb.append("\"jvm.memory.committed\",");
        sb.append("\"jvm.memory.max\",");
        sb.append("\"jvm.memory.used\",");
        sb.append("\"jvm.threads.states\",");
        sb.append(" \"logback.events\"");
        sb.append("]");
        return sb.toString();
    }

    public String getSimpleMeterList() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("\"jvm.classes.loaded\",");
        sb.append("\"jvm.classes.unloaded\",");
        sb.append("\"jvm.gc.live.data.size\",");
        sb.append("\"jvm.gc.max.data.size\",");
        sb.append("\"jvm.gc.memory.allocated\",");
        sb.append("\"jvm.gc.memory.promoted\",");
        sb.append("\"jvm.threads.daemon\",");
        sb.append("\"jvm.threads.live\",");
        sb.append("\"jvm.threads.peak\",");
        sb.append("\"process.cpu.usage\",");
        sb.append("\"process.start.time\",");
        sb.append("\"process.uptime\",");
        sb.append("\"system.cpu.count\",");
        sb.append("\"system.cpu.usage\",");
        sb.append("\"system.disk.free\",");
        sb.append("\"system.disk.total\",");
        sb.append("\"system.disk.usable\",");
        sb.append("\"system.disk.used\",");
        sb.append("\"system.memory.free\",");
        sb.append("\"system.memory.total\",");
        sb.append("\"system.memory.usage\",");
        sb.append("\"system.memory.used\"");
        sb.append("]");
        return sb.toString();
    }

    private String mapJsonParser(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            sb.append("\"").append(entry.getKey()).append("\",");
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }
}

