/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class YamlProcess {
    private String executable;
    private String executablePath;
    private String homePath;
    private String locationKey;
    private List<String> cmdArg = new ArrayList<String>();

    public String getExecutable() {
        return this.executable;
    }

    public String getLocationKey() {
        return this.locationKey;
    }

    public File getExecutablePath() {
        return YamlProcess.toSubstFilePath(this.executablePath);
    }

    public File getHomePath() {
        return YamlProcess.toSubstFilePath(this.homePath);
    }

    protected static String toSubstFileName(String path) {
        String result;
        if (null == path || path.length() == 0) {
            result = null;
        } else {
            result = path.replace("${tmp}", FileUtils.getTempDirectoryPath());
            result = result.replace("${user}", FileUtils.getUserDirectoryPath());
        }
        return result;
    }

    protected static File toSubstFilePath(String path) {
        String tmp = YamlProcess.toSubstFileName(path);
        return null == tmp ? null : new File(tmp);
    }

    public List<String> getCmdArg() {
        return this.cmdArg;
    }

    public List<String> getSubstCmdArg() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.cmdArg) {
            result.add(YamlProcess.toSubstFileName(s));
        }
        return result;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public void setLocationKey(String locationKey) {
        this.locationKey = locationKey;
    }

    public void setExecutablePath(String executablePath) {
        this.executablePath = executablePath;
    }

    public void setExecutablePath(File executablePath) {
        this.executablePath = null == executablePath ? null : executablePath.toString();
    }

    public void setHomePath(String homePath) {
        this.homePath = homePath;
    }

    public void setHomePath(File home) {
        this.homePath = null == home ? null : home.toString();
    }

    public void setCmdArg(List<String> cmdArg) {
        this.cmdArg = cmdArg;
    }
}

