/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.AbstractYamlArtifact;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.iip_aas.config.AbstractSetup;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public class YamlArtifact
extends AbstractYamlArtifact {
    private List<YamlService> services;

    public List<YamlService> getServices() {
        return this.services;
    }

    public void setServices(List<YamlService> services) {
        this.services = services;
    }

    public YamlService getService(String id) {
        YamlService result = null;
        for (int s = 0; null == result && s < this.services.size(); ++s) {
            YamlService tmp = this.services.get(s);
            if (!tmp.getId().equals(id)) continue;
            result = tmp;
        }
        return result;
    }

    public YamlService getServiceSafe(String id) {
        YamlService result = this.getService(id);
        if (null == result) {
            result = new YamlService();
        }
        return result;
    }

    public static YamlArtifact readFromYaml(InputStream in) throws IOException {
        YamlArtifact result = (YamlArtifact)AbstractSetup.readFromYaml(YamlArtifact.class, (InputStream)in);
        if (null == result.services) {
            result.services = new ArrayList<YamlService>();
        }
        return result;
    }

    public static YamlArtifact readFromYamlSafe(InputStream in) {
        YamlArtifact result;
        try {
            result = YamlArtifact.readFromYaml(in);
            if (null != in) {
                in.close();
            }
        }
        catch (IOException e) {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            result = new YamlArtifact();
            LoggerFactory.getLogger(YamlArtifact.class).warn("Cannot read deployment.yml: " + e.getMessage());
        }
        return result;
    }
}

