/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.EnvironmentSetup;
import de.iip_ecosphere.platform.services.environment.ResourceLoader;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceMapper;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.iip_aas.config.CmdLine;
import de.iip_ecosphere.platform.transport.Transport;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Starter {
    public static final String PARAM_IIP_PROTOCOL = "iip.protocol";
    public static final String PARAM_IIP_PORT = "iip.port";
    public static final String PARAM_IIP_TEST_SERVICE_AUTOSTART = "iip.test.service.autostart";
    private static ProtocolServerBuilder builder;
    private static Server server;
    private static Map<String, Integer> servicePorts;
    private static boolean serviceAutostart;
    private static EnvironmentSetup setup;

    public static String getServiceCommandNetworkMgrKey(String serviceId) {
        return "admin_" + serviceId;
    }

    public static String getServiceProcessNetworkMgrKey(String serviceId) {
        return Starter.getServiceCommandNetworkMgrKey(serviceId) + "_process";
    }

    public static String composeArgument(String argName, Object value) {
        return "--" + argName + "=" + value.toString();
    }

    public static String getServicePortName(String serviceId) {
        return "iip.port." + Starter.normalizeServiceId(serviceId);
    }

    public static int getServicePort(String serviceId) {
        Integer port = servicePorts.get(Starter.normalizeServiceId(serviceId));
        return null == port ? -1 : port;
    }

    public static String normalizeServiceId(String serviceId) {
        return serviceId.replaceAll(" ", "");
    }

    public static void parse(String ... args) {
        AasFactory factory = AasFactory.getInstance();
        int port = CmdLine.getIntArg((String[])args, (String)PARAM_IIP_PORT, (int)-1);
        if (port < 0) {
            port = NetUtils.getEphemeralPort();
        }
        serviceAutostart = CmdLine.getBooleanArg((String[])args, (String)PARAM_IIP_TEST_SERVICE_AUTOSTART, (boolean)false);
        String protocol = CmdLine.getArg((String[])args, (String)PARAM_IIP_PROTOCOL, (String)"");
        boolean found = false;
        for (String p : factory.getProtocols()) {
            if (!p.equals(protocol)) continue;
            found = false;
        }
        if (!found) {
            protocol = "";
        }
        for (String a : args) {
            int valPos;
            if (!a.startsWith("--iip.port.") || (valPos = a.indexOf("=")) <= 0) continue;
            String prefix = a.substring(0, valPos);
            int idPos = prefix.lastIndexOf(".");
            try {
                String serviceId = prefix.substring(idPos + 1);
                int p = Integer.parseInt(a.substring(valPos + 1));
                servicePorts.put(serviceId, p);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Starter.getLogger().info("Configuring service command server for protocol '" + protocol + "' (empty means default) and port " + port);
        builder = factory.createProtocolServerBuilder(protocol, port);
    }

    public static void start() {
        if (null != builder) {
            Starter.getLogger().info("Starting service command server");
            server = (Server)builder.build();
            server.start();
        } else {
            Starter.getLogger().error("Cannot start service command server as no builder is set.");
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(Starter.class);
    }

    public static ProtocolServerBuilder getProtocolBuilder() {
        return builder;
    }

    public static ServiceMapper getServiceMapper() {
        return new ServiceMapper(builder);
    }

    public static void mapService(ServiceMapper mapper, Service service, boolean enableAutostart) {
        if (null != service) {
            if (null != mapper && null != Starter.getProtocolBuilder()) {
                mapper.mapService(service);
            }
            if (serviceAutostart && enableAutostart) {
                try {
                    Starter.getLogger().info("Service autostart: '{}' '{}'", (Object)service.getId(), (Object)service.getClass().getName());
                    service.setState(ServiceState.STARTING);
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                        try {
                            System.out.println("Service autostop: " + service.getId());
                            service.setState(ServiceState.STOPPING);
                        }
                        catch (ExecutionException e) {
                            Starter.getLogger().error("Service autostop '{}': {}", (Object)service.getId(), (Object)e.getMessage());
                        }
                    }));
                }
                catch (ExecutionException e) {
                    Starter.getLogger().error("Service autostart '{}': {}", (Object)service.getId(), (Object)e.getMessage());
                }
            }
        }
    }

    public static void mapService(Service service, boolean enableAutostart) {
        Starter.mapService(Starter.getServiceMapper(), service, enableAutostart);
    }

    public static void mapService(Service service) {
        Starter.mapService(service, true);
    }

    public static void shutdown() {
        if (null != server) {
            server.stop(false);
        }
    }

    public static EnvironmentSetup getSetup() {
        if (null == setup) {
            try {
                setup = (EnvironmentSetup)((Object)EnvironmentSetup.readFromYaml(EnvironmentSetup.class, (InputStream)ResourceLoader.getResourceAsStream(Starter.class, "application.yml")));
                Transport.setTransportSetup(() -> setup.getTransport());
            }
            catch (IOException e) {
                setup = new EnvironmentSetup();
                LoggerFactory.getLogger(Starter.class).warn("Cannot read application.yml. Aas/Transport setup invalid");
            }
        }
        return setup;
    }

    public static void main(String[] args) {
        Starter.parse(args);
        Starter.getSetup();
        Starter.start();
    }

    static {
        servicePorts = new HashMap<String, Integer>();
        serviceAutostart = false;
    }
}

