/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.ServiceMapper;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.iip_aas.AasUtils;
import de.iip_ecosphere.platform.support.iip_aas.Version;
import de.iip_ecosphere.platform.support.iip_aas.json.JsonResultWrapper;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ServiceStub
implements Service {
    private Map<String, Supplier<Object>> getters = new HashMap<String, Supplier<Object>>();
    private Map<String, Consumer<Object>> setters = new HashMap<String, Consumer<Object>>();
    private Map<String, Function<Object[], Object>> operations = new HashMap<String, Function<Object[], Object>>();

    public ServiceStub(InvocablesCreator iCreator, String serviceId) {
        for (String n : ServiceMapper.PROP_READONLY) {
            this.registerProperty(n, iCreator.createGetter(ServiceMapper.getQName(serviceId, n)), InvocablesCreator.READ_ONLY);
        }
        for (String n : ServiceMapper.PROP_WRITEONLY) {
            this.registerProperty(n, InvocablesCreator.WRITE_ONLY, iCreator.createSetter(ServiceMapper.getQName(serviceId, n)));
        }
        for (String n : ServiceMapper.PROP_READWRITE) {
            this.registerProperty(n, iCreator.createGetter(ServiceMapper.getQName(serviceId, n)), iCreator.createSetter(ServiceMapper.getQName(serviceId, n)));
        }
        for (String n : ServiceMapper.OPERATIONS) {
            this.registerOperation(n, iCreator.createInvocable(ServiceMapper.getQName(serviceId, n)));
        }
    }

    private void registerProperty(String name, Supplier<Object> getter, Consumer<Object> setter) {
        this.getters.put(name, getter);
        this.setters.put(name, setter);
    }

    private void registerOperation(String name, Function<Object[], Object> operation) {
        this.operations.put(name, operation);
    }

    public Supplier<Object> getGetter(String name) {
        return this.getters.get(name);
    }

    public Consumer<Object> getSetter(String name) {
        return this.setters.get(name);
    }

    public Function<Object[], Object> getOperation(String name) {
        return this.operations.get(name);
    }

    private <T> T convertGetterResult(String getId, T dflt, Function<Object, T> conversion) {
        Object response = this.getters.get(getId).get();
        T result = null == response ? dflt : conversion.apply(response);
        return result;
    }

    private String convertGetterResultToString(String getId) {
        return this.convertGetterResult(getId, "", r -> r.toString());
    }

    public static <T extends Enum<T>> T convertToEnumSafe(Object val, T dflt, Class<T> cls) {
        T result;
        try {
            result = Enum.valueOf(cls, val.toString());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            result = dflt;
        }
        return result;
    }

    private <T extends Enum<T>> T convertGetterResultToEnum(String getId, T dflt, Class<T> cls) {
        return (T)this.convertGetterResult(getId, dflt, r -> ServiceStub.convertToEnumSafe(r, dflt, cls));
    }

    @Override
    public String getId() {
        return this.convertGetterResultToString("id");
    }

    @Override
    public String getName() {
        return this.convertGetterResultToString("name");
    }

    @Override
    public Version getVersion() {
        return this.convertGetterResult("version", null, r -> new Version(r.toString()));
    }

    @Override
    public String getDescription() {
        return this.convertGetterResultToString("description");
    }

    @Override
    public ServiceState getState() {
        return this.convertGetterResultToEnum("state", null, ServiceState.class);
    }

    @Override
    public boolean isDeployable() {
        return this.convertGetterResult("deployable", false, r -> Boolean.valueOf(r.toString()));
    }

    @Override
    public ServiceKind getKind() {
        return this.convertGetterResultToEnum("kind", null, ServiceKind.class);
    }

    @Override
    public void setState(ServiceState state) throws ExecutionException {
        Object[] param = new Object[]{state.name()};
        JsonResultWrapper.fromJson(this.operations.get("setState"), (Object[])param);
    }

    @Override
    public void migrate(String resourceId) throws ExecutionException {
        JsonResultWrapper.fromJson(this.operations.get("migrate"));
    }

    @Override
    public void update(URI location) throws ExecutionException {
        Object[] param = new Object[]{location.toString()};
        JsonResultWrapper.fromJson(this.operations.get("update"), (Object[])param);
    }

    @Override
    public void switchTo(String targetId) throws ExecutionException {
        Object[] param = new Object[]{targetId};
        JsonResultWrapper.fromJson(this.operations.get("switchTo"), (Object[])param);
    }

    @Override
    public void activate() throws ExecutionException {
        JsonResultWrapper.fromJson(this.operations.get("activate"));
    }

    @Override
    public void passivate() throws ExecutionException {
        JsonResultWrapper.fromJson(this.operations.get("passivate"));
    }

    @Override
    public void reconfigure(Map<String, String> values) throws ExecutionException {
        Object[] param = new Object[]{AasUtils.writeMap(values)};
        JsonResultWrapper.fromJson(this.operations.get("reconfigure"), (Object[])param);
    }
}

