/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.AbstractPythonProcessService;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonSyncProcessService
extends AbstractPythonProcessService {
    private int timeout = 1;
    private TimeUnit timeoutUnit = TimeUnit.SECONDS;
    private Map<String, String> reconfValues;

    public PythonSyncProcessService(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
    }

    public PythonSyncProcessService(YamlService yaml) {
        super(yaml);
    }

    @Override
    public void migrate(String resourceId) throws ExecutionException {
    }

    @Override
    public void update(URI location) throws ExecutionException {
    }

    @Override
    public void switchTo(String targetId) throws ExecutionException {
    }

    @Override
    public void activate() throws ExecutionException {
        super.setState(ServiceState.ACTIVATING);
        this.stop();
        super.setState(ServiceState.ACTIVATING);
    }

    @Override
    public void passivate() throws ExecutionException {
        super.setState(ServiceState.PASSIVATING);
        this.start();
        super.setState(ServiceState.PASSIVATED);
    }

    @Override
    public void reconfigure(Map<String, String> values) throws ExecutionException {
        if (null == this.reconfValues) {
            this.reconfValues = new HashMap<String, String>();
        }
        this.reconfValues.putAll(values);
    }

    protected static Logger getLogger() {
        return LoggerFactory.getLogger(PythonSyncProcessService.class);
    }

    @Override
    public <I, O> O process(String inType, I data) throws ExecutionException {
        O result = null;
        AbstractPythonProcessService.InTypeInfo<?> info = this.getInTypeInfo(inType);
        if (null != info) {
            TypeTranslator<?, String> inT = info.getInTranslator();
            if (null != inT) {
                try {
                    AtomicReference tmp = new AtomicReference();
                    Process proc = this.createAndCustomizeProcess(PythonSyncProcessService.compose(inType, (String)inT.to(data)), this.reconfValues);
                    Thread thread = this.createScanInputThread(proc, (t, d) -> {
                        AbstractPythonProcessService.OutTypeInfo<?> oInfo = this.getOutTypeInfo(t);
                        if (null != oInfo) {
                            TypeTranslator<String, ?> outT = oInfo.getOutTranslator();
                            if (null != outT) {
                                tmp.set(outT.to((Object)d));
                            } else {
                                throw new IOException("No output type translator registered");
                            }
                        }
                        return true;
                    });
                    thread.start();
                    if (this.timeout < 0) {
                        proc.waitFor();
                    } else {
                        proc.waitFor(this.timeout, this.timeoutUnit);
                    }
                    thread.join();
                    result = (O)tmp.get();
                }
                catch (IOException | InterruptedException e) {
                    throw new ExecutionException("Exception while data processing: " + e.getMessage(), e);
                }
            } else {
                throw new ExecutionException("No input type translator registered", null);
            }
        }
        return result;
    }
}

