/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.AbstractPythonProcessService;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonAsyncProcessService
extends AbstractPythonProcessService {
    private Process proc;
    private PrintWriter serviceIn;
    private boolean enableFileDeletion;

    public PythonAsyncProcessService(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
    }

    public PythonAsyncProcessService(YamlService yaml) {
        super(yaml);
    }

    public void enableFileDeletion(boolean enableFileDeletion) {
        this.enableFileDeletion = enableFileDeletion;
    }

    @Override
    protected void start() throws ExecutionException {
        this.proc = this.createAndCustomizeProcess(null, null);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.proc.getOutputStream()));
        this.serviceIn = new PrintWriter(writer);
        this.createScanInputThread(this.proc, (t, d) -> {
            AbstractPythonProcessService.OutTypeInfo<?> info = this.getOutTypeInfo(t);
            if (null != info) {
                this.handleResult(info.getType(), d, t);
            } else {
                LoggerFactory.getLogger(this.getClass()).error("No output type translator registered for: " + t);
            }
            return false;
        }).start();
    }

    @Override
    protected void stop() {
        if (null != this.serviceIn) {
            this.serviceIn.flush();
            this.serviceIn = null;
        }
        if (null != this.proc) {
            this.proc.destroyForcibly();
            while (this.proc.isAlive()) {
                TimeUtils.sleep((int)200);
            }
            this.proc = null;
        }
        if (null != this.getHome() && this.enableFileDeletion) {
            try {
                FileUtils.forceDelete((File)this.getHome());
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Cannot delete Python process home {}: {}", (Object)this.getHome(), (Object)e.getMessage());
            }
        }
    }

    @Override
    public void migrate(String resourceId) throws ExecutionException {
        this.sendToService(PythonAsyncProcessService.compose("*migrate", resourceId));
    }

    @Override
    public void update(URI location) throws ExecutionException {
        this.sendToService(PythonAsyncProcessService.compose("*update", location.toString()));
    }

    @Override
    public void switchTo(String targetId) throws ExecutionException {
        this.sendToService(PythonAsyncProcessService.compose("*switch", targetId));
    }

    @Override
    public void reconfigure(Map<String, String> values) throws ExecutionException {
        this.sendToService(PythonAsyncProcessService.compose("*recfg", this.toJson(values)));
    }

    @Override
    public void activate() throws ExecutionException {
        if (this.getState() == ServiceState.PASSIVATED) {
            this.sendToService(PythonAsyncProcessService.compose("*activate", ""));
        }
        super.activate();
    }

    @Override
    public void passivate() throws ExecutionException {
        if (this.getState() == ServiceState.RUNNING) {
            this.sendToService(PythonAsyncProcessService.compose("*passivate", ""));
        }
        super.passivate();
    }

    protected static Logger getLogger() {
        return LoggerFactory.getLogger(PythonAsyncProcessService.class);
    }

    private void sendToService(String text) throws ExecutionException {
        if (null == this.serviceIn) {
            throw new ExecutionException("Service/process not started,", null);
        }
        this.serviceIn.println(text);
        this.serviceIn.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <I, O> O process(String inType, I data) throws ExecutionException {
        AbstractPythonProcessService.InTypeInfo<?> info = this.getInTypeInfo(inType);
        if (null == info) throw new ExecutionException("No input type translator registered", null);
        TypeTranslator<?, String> inT = info.getInTranslator();
        if (null == inT) throw new ExecutionException("No input type translator registered", null);
        try {
            this.sendToService(PythonAsyncProcessService.compose(inType, (String)inT.to(data)));
            return null;
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot transfer data to service: " + e.getMessage(), e);
        }
    }
}

