/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.ValueConfigurer;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.slf4j.LoggerFactory;

public class ParameterConfigurer<T>
implements ValueConfigurer<T> {
    private String name;
    private TypeTranslator<String, T> translator;
    private ValueConfigurer<T> cfg;
    private Supplier<T> getter;
    private Class<T> cls;

    public ParameterConfigurer(String name, Class<T> cls, TypeTranslator<String, T> translator, ValueConfigurer<T> cfg) {
        this(name, cls, translator, cfg, null);
    }

    protected ParameterConfigurer(String name, Class<T> cls, TypeTranslator<String, T> translator, ValueConfigurer<T> cfg, Supplier<T> getter) {
        this.name = name;
        this.cls = cls;
        this.translator = translator;
        this.cfg = cfg;
        this.getter = getter;
    }

    @Override
    public void configure(T value) throws ExecutionException {
        this.cfg.configure(value);
    }

    public TypeTranslator<String, T> getTranslator() {
        return this.translator;
    }

    public Supplier<T> getGetter() {
        return this.getter;
    }

    public String getName() {
        return this.name;
    }

    public void addValue(Map<String, String> values, Object value) {
        if (this.cls.isInstance(value)) {
            try {
                values.put(this.name, (String)this.translator.from(this.cls.cast(value)));
            }
            catch (IOException e) {
                LoggerFactory.getLogger(ParameterConfigurer.class).warn("Cannot add value for " + this.name + ": " + e.getMessage());
            }
        } else {
            LoggerFactory.getLogger(ParameterConfigurer.class).warn("Cannot add value for " + this.name + " as value is not instance of " + this.cls.getName());
        }
    }
}

