/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.support.iip_aas.config.AbstractSetup;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.SystemUtils;

public class InstalledDependenciesSetup
extends AbstractSetup {
    public static final String DEFAULT_NAME = "installedDependencies";
    public static final String DEFAULT_FNAME = "installedDependencies.yml";
    public static final String KEY_PREFIX_JAVA = "JAVA";
    public static final String KEY_JAVA_8 = "JAVA8";
    public static final String KEY_JAVA_11 = "JAVA11";
    private static InstalledDependenciesSetup instance;
    private Map<String, File> locations = new HashMap<String, File>();

    public InstalledDependenciesSetup() {
        this.setupDefaults();
    }

    private void setupDefaults() {
        String exeSuffix = "";
        if (SystemUtils.IS_OS_WINDOWS) {
            exeSuffix = ".exe";
        }
        this.addDefaultEntry(InstalledDependenciesSetup.getJavaKey(), new File(SystemUtils.getJavaHome(), "bin/java" + exeSuffix));
    }

    private void addDefaultEntry(String key, File value) {
        if (!this.locations.containsKey(key)) {
            this.locations.put(key, value);
        }
    }

    public static String getJavaKey() {
        String ver = SystemUtils.JAVA_SPECIFICATION_VERSION;
        if (ver.startsWith("1.")) {
            ver = ver.substring(2);
        }
        return KEY_PREFIX_JAVA + ver;
    }

    public Map<String, File> getLocations() {
        return this.locations;
    }

    public File getLocation(String key) {
        return null == key ? null : this.locations.get(key);
    }

    public void setLocations(Map<String, File> locations) {
        this.locations = locations;
        this.setupDefaults();
    }

    public static InstalledDependenciesSetup readFromYaml(String fileName) {
        try {
            return (InstalledDependenciesSetup)((Object)InstalledDependenciesSetup.readFromYaml(InstalledDependenciesSetup.class, (String)fileName));
        }
        catch (IOException e) {
            return new InstalledDependenciesSetup();
        }
    }

    public static InstalledDependenciesSetup readFromYaml() {
        return InstalledDependenciesSetup.readFromYaml(DEFAULT_FNAME);
    }

    public static InstalledDependenciesSetup getInstance() {
        if (null == instance) {
            instance = InstalledDependenciesSetup.readFromYaml();
        }
        return instance;
    }

    public static File location(String key) throws ExecutionException {
        File location = InstalledDependenciesSetup.getInstance().getLocation(key);
        if (null == location) {
            throw new ExecutionException("No installed dependency for key '" + key + "'", null);
        }
        return location;
    }
}

