/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.slf4j.LoggerFactory;

public class ConnectorServiceWrapper<O, I, CO, CI>
extends AbstractService {
    private Connector<O, I, CO, CI> connector;
    private Supplier<ConnectorParameter> connParamSupplier;

    public ConnectorServiceWrapper(YamlService yaml, Connector<O, I, CO, CI> connector) {
        super(yaml);
        this.connector = connector;
    }

    public ConnectorServiceWrapper(YamlService yaml, Connector<O, I, CO, CI> connector, Supplier<ConnectorParameter> connParamSupplier) {
        super(yaml);
        this.connector = connector;
        this.connParamSupplier = connParamSupplier;
    }

    public Connector<O, I, CO, CI> getConnector() {
        return this.connector;
    }

    public void send(CI data) {
        try {
            this.connector.write(data);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Data loss, cannot send data: " + e.getMessage());
        }
    }

    public void setReceptionCallback(ReceptionCallback<CO> callback) {
        try {
            this.connector.setReceptionCallback(callback);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Data loss, cannot set reception callback: " + e.getMessage());
        }
    }

    @Override
    public void setState(ServiceState state) throws ExecutionException {
        super.setState(state);
        try {
            if (ServiceState.STARTING == state) {
                ConnectorParameter param = this.connParamSupplier.get();
                this.connector.connect(param);
                this.connector.enableNotifications(param.getNotificationInterval() == 0);
                super.setState(ServiceState.RUNNING);
            } else if (ServiceState.STOPPING == state) {
                this.connector.disconnect();
                super.setState(ServiceState.STOPPED);
            } else if (ServiceState.UNDEPLOYING == state) {
                this.connector.dispose();
            }
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public void migrate(String resourceId) throws ExecutionException {
    }

    @Override
    public void update(URI location) throws ExecutionException {
    }

    @Override
    public void switchTo(String targetId) throws ExecutionException {
    }

    @Override
    public void reconfigure(Map<String, String> values) throws ExecutionException {
    }

    public void enablePolling(boolean enablePolling) {
        this.connector.enablePolling(enablePolling);
    }

    public void enableNotifications(boolean enableNotifications) {
        this.connector.enableNotifications(enableNotifications);
    }
}

