/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurerProvider;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.ValueConfigurer;
import de.iip_ecosphere.platform.services.environment.YamlArtifact;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.iip_aas.Version;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.slf4j.LoggerFactory;

public abstract class AbstractService
implements Service {
    private static ClassLoader loader = AbstractService.class.getClassLoader();
    private String id;
    private String name;
    private Version version;
    private String description;
    private boolean isDeployable;
    private ServiceKind kind;
    private ServiceState state;

    protected AbstractService(ServiceKind kind) {
        this("", kind);
    }

    protected AbstractService(String id, ServiceKind kind) {
        this(id, "", new Version(new int[]{0, 0, 0}), "", true, kind);
    }

    protected AbstractService(String id, String name, Version version, String description, boolean isDeployable, ServiceKind kind) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.description = description;
        this.isDeployable = isDeployable;
        this.kind = kind;
        this.state = ServiceState.AVAILABLE;
    }

    protected AbstractService(YamlService yaml) {
        this(yaml.getId(), yaml.getName(), yaml.getVersion(), yaml.getDescription(), yaml.isDeployable(), yaml.getKind());
        this.initializeFrom(yaml);
    }

    protected AbstractService(String serviceId, InputStream ymlFile) {
        this(YamlArtifact.readFromYamlSafe(ymlFile).getServiceSafe(serviceId));
    }

    protected void initializeFrom(YamlService yaml) {
    }

    public static void setLibJars(URL[] jars) {
        if (null != jars) {
            loader = new URLClassLoader(jars, loader);
        }
    }

    public static <S extends Service> S createInstance(String className, Class<S> cls) {
        return AbstractService.createInstance(loader, className, cls, null, null);
    }

    public static <S extends Service> S createInstance(String className, Class<S> cls, String serviceId, String deploymentDescFile) {
        return AbstractService.createInstance(loader, className, cls, serviceId, deploymentDescFile);
    }

    private static InputStream getResourceAsStream(ClassLoader loader, String resource) {
        InputStream desc = loader.getResourceAsStream(resource);
        if (null == desc) {
            File f;
            String tmp = resource;
            while (tmp.startsWith("/")) {
                tmp = tmp.substring(1);
            }
            desc = loader.getResourceAsStream(tmp);
            if (null == desc && (f = new File(tmp)).exists()) {
                try {
                    desc = new FileInputStream(f);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return desc;
    }

    public static <S extends Service> S createInstance(ClassLoader loader, String className, Class<S> cls, String serviceId, String deploymentDescFile) {
        Service result = null;
        try {
            Constructor<?> cons3;
            Class<?> serviceClass = loader.loadClass(className);
            Object instance = null;
            if (null != serviceId && null != deploymentDescFile) {
                try {
                    cons3 = serviceClass.getConstructor(String.class, InputStream.class);
                    InputStream desc = AbstractService.getResourceAsStream(loader, deploymentDescFile);
                    instance = cons3.newInstance(serviceId, desc);
                    if (null != desc) {
                        desc.close();
                    }
                }
                catch (NoSuchMethodException cons2) {
                }
                catch (InvocationTargetException e) {
                    LoggerFactory.getLogger(AbstractService.class).error("While instantiating " + className + ": " + e.getMessage() + ", falling back to default constructor");
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(AbstractService.class).error("While instantiating " + className + " here loading descriptor " + deploymentDescFile + ": " + e.getMessage() + ", falling back to default constructor");
                }
            }
            if (null == instance && null != serviceId) {
                try {
                    cons3 = serviceClass.getConstructor(String.class);
                    instance = cons3.newInstance(serviceId);
                }
                catch (NoSuchMethodException cons3) {
                }
                catch (InvocationTargetException e) {
                    LoggerFactory.getLogger(AbstractService.class).error("While instantiating " + className + ": " + e.getMessage() + ", falling back to default constructor");
                }
            }
            if (null == instance) {
                instance = serviceClass.newInstance();
            }
            result = (Service)cls.cast(instance);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            String loaders = "";
            for (ClassLoader l = loader; null != l; l = l.getParent()) {
                if (loaders.length() > 0) {
                    loaders = loaders + " -> ";
                }
                loaders = loaders + l.getClass().getSimpleName();
            }
            LoggerFactory.getLogger(AbstractService.class).warn("Cannot instantiate service of type '" + className + " via " + loaders + "': " + e.getClass().getSimpleName() + " " + e.getMessage() + ". Service '" + serviceId + "' will not be functional!");
        }
        return (S)result;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ServiceState getState() {
        return this.state;
    }

    @Override
    public void setState(ServiceState state) throws ExecutionException {
        this.state = state;
    }

    @Override
    public boolean isDeployable() {
        return this.isDeployable;
    }

    @Override
    public ServiceKind getKind() {
        return this.kind;
    }

    @Override
    public void activate() throws ExecutionException {
        if (this.getState() == ServiceState.PASSIVATED) {
            this.setState(ServiceState.RUNNING);
        }
    }

    @Override
    public void passivate() throws ExecutionException {
        if (this.getState() == ServiceState.RUNNING) {
            this.setState(ServiceState.PASSIVATED);
        }
    }

    public static <T> void addConfigurer(Map<String, ParameterConfigurer<?>> configurers, String name, Class<T> cls, TypeTranslator<String, T> trans, ValueConfigurer<T> cfg) {
        AbstractService.addConfigurer(configurers, name, cls, trans, cfg, null);
    }

    public static <T> void addConfigurer(Map<String, ParameterConfigurer<?>> configurers, String name, Class<T> cls, TypeTranslator<String, T> trans, ValueConfigurer<T> cfg, Supplier<T> getter) {
        configurers.put(name, new ParameterConfigurer<T>(name, cls, trans, cfg, getter));
    }

    public static void reconfigure(Map<String, String> values, ParameterConfigurerProvider provider, boolean rollback, ServiceState state) throws ExecutionException {
        if (null != provider) {
            HashMap<String, String> rollbackMap = rollback ? new HashMap<String, String>() : null;
            try {
                for (Map.Entry<String, String> ent : values.entrySet()) {
                    ParameterConfigurer<?> cfg = provider.getParameterConfigurer(ent.getKey());
                    if (null == cfg) continue;
                    AbstractService.reconf(cfg, ent.getKey(), ent.getValue(), rollbackMap);
                }
            }
            catch (ExecutionException e) {
                if (null != rollbackMap) {
                    for (Map.Entry ent : rollbackMap.entrySet()) {
                        try {
                            ParameterConfigurer<?> cfg = provider.getParameterConfigurer((String)ent.getKey());
                            if (null == cfg) continue;
                            AbstractService.reconf(cfg, (String)ent.getKey(), (String)ent.getValue(), rollbackMap);
                        }
                        catch (ExecutionException executionException) {}
                    }
                }
                throw e;
            }
        }
    }

    protected static <T> void reconf(ParameterConfigurer<T> configurer, String name, String value, Map<String, String> rollbackMap) throws ExecutionException {
        try {
            Supplier<T> getter;
            TypeTranslator<String, T> trans = configurer.getTranslator();
            if (null != rollbackMap && null != (getter = configurer.getGetter())) {
                T v = getter.get();
                rollbackMap.put(name, v == null ? null : (String)trans.from(v));
            }
            configurer.configure(null == value ? null : trans.to((Object)value));
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public void reconfigure(Map<String, String> values) throws ExecutionException {
        AbstractService.reconfigure(values, this, this.rollbackReconfigurationOnFailure(), this.getState());
    }

    protected boolean rollbackReconfigurationOnFailure() {
        return true;
    }
}

