/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.AbstractProcessService;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.LoggerFactory;

public abstract class AbstractRestProcessService<I, O>
extends AbstractProcessService<I, String, String, O> {
    private HttpURLConnection connection;
    private ExecutorService executor = Executors.newFixedThreadPool(5);
    private CloseableHttpClient client;

    protected AbstractRestProcessService(TypeTranslator<I, String> inTrans, TypeTranslator<String, O> outTrans, ReceptionCallback<O> callback, YamlService yaml) {
        super(inTrans, outTrans, callback, yaml);
    }

    protected abstract String getApiPath();

    protected HttpURLConnection getConnection() {
        return this.connection;
    }

    protected abstract String getBearerToken();

    protected HttpURLConnection getNewConnectionInstance() throws IOException {
        URL url = new URL(this.getApiPath());
        this.connection = (HttpURLConnection)url.openConnection();
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod("POST");
        this.connection.setRequestProperty("Content-Type", "application/json");
        String bearer = this.getBearerToken();
        if (null != bearer) {
            this.connection.setRequestProperty("Authorization", bearer);
        }
        this.connection.connect();
        return this.connection;
    }

    protected void setupConnectionManager() {
        PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager();
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolingConnectionManager).build();
    }

    protected void getNewConnectionInstanceQuiet(boolean changeState) {
        block4: {
            try {
                this.getNewConnectionInstance();
            }
            catch (IOException con) {
                LoggerFactory.getLogger(AbstractRestProcessService.class).warn(con.getMessage() + " " + this.getApiPath());
                if (!changeState) break block4;
                try {
                    this.setState(ServiceState.FAILED);
                }
                catch (ExecutionException e) {
                    LoggerFactory.getLogger(AbstractRestProcessService.class).error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void process(final I data) throws IOException {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    HttpPost post = new HttpPost(AbstractRestProcessService.this.getApiPath());
                    String bearer = AbstractRestProcessService.this.getBearerToken();
                    String input = AbstractRestProcessService.this.adjustRestQuery((String)AbstractRestProcessService.this.getInputTranslator().to(data));
                    StringEntity entity = new StringEntity(input);
                    post.setEntity((HttpEntity)entity);
                    post.setHeader("Accept", "application/json");
                    post.setHeader("Content-type", "application/json");
                    post.setHeader("Authorization", bearer);
                    if (AbstractRestProcessService.this.client != null) {
                        CloseableHttpResponse response = AbstractRestProcessService.this.client.execute((HttpUriRequest)post);
                        String result = AbstractRestProcessService.this.adjustRestResponse(EntityUtils.toString((HttpEntity)response.getEntity()));
                        try {
                            AbstractRestProcessService.this.notifyCallbacks(AbstractRestProcessService.this.getOutputTranslator().to((Object)result));
                        }
                        catch (IOException e) {
                            LoggerFactory.getLogger(this.getClass()).error("Receiving result: {}", (Object)e.getMessage());
                        }
                    } else {
                        LoggerFactory.getLogger(this.getClass()).info("Connection not yet open. Cannot process data.");
                    }
                }
                catch (IOException e1) {
                    LoggerFactory.getLogger(this.getClass()).error("Receiving result: {}", (Object)e1.getMessage());
                }
            }
        });
    }

    protected abstract String adjustRestQuery(String var1);

    protected abstract String adjustRestResponse(String var1);

    public void redirectRest(final HttpURLConnection connection, final ReceptionCallback<O> callback) {
        if (null != callback) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    block6: {
                        try {
                            BufferedInputStream bis = new BufferedInputStream(connection.getInputStream());
                            ByteArrayOutputStream buf = new ByteArrayOutputStream();
                            int read = bis.read();
                            while (read != -1) {
                                buf.write((byte)read);
                                read = bis.read();
                            }
                            String result = AbstractRestProcessService.this.adjustRestResponse(buf.toString());
                            try {
                                callback.received(AbstractRestProcessService.this.getOutputTranslator().to((Object)result));
                                connection.disconnect();
                            }
                            catch (IOException e) {
                                if (ServiceState.RUNNING == AbstractRestProcessService.this.getState()) {
                                    LoggerFactory.getLogger(this.getClass()).error("Receiving result: {}", (Object)e.getMessage());
                                }
                                connection.disconnect();
                            }
                        }
                        catch (IOException e1) {
                            if (ServiceState.RUNNING != AbstractRestProcessService.this.getState()) break block6;
                            LoggerFactory.getLogger(this.getClass()).error("Receiving result: {}", (Object)e1.getMessage());
                        }
                    }
                }
            });
        }
    }

    @Override
    protected void handleInputStream(InputStream in) {
    }

    @Override
    protected ServiceState stop() {
        if (null != this.connection) {
            this.connection.disconnect();
            this.connection = null;
        }
        return super.stop();
    }
}

