/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.services.environment.AbstractProcessService;
import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.DataIngestor;
import de.iip_ecosphere.platform.services.environment.GenericMultiTypeService;
import de.iip_ecosphere.platform.services.environment.InstalledDependenciesSetup;
import de.iip_ecosphere.platform.services.environment.PythonUtils;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlProcess;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPythonProcessService
extends AbstractService
implements GenericMultiTypeService {
    public static final char TYPE_SEPARATOR_CHAR = '|';
    private File home;
    private List<String> pythonArgs;
    private String locationKey;
    private Map<String, OutTypeInfo<?>> outTypeInfos = new HashMap();
    private Map<String, InTypeInfo<?>> inTypeInfos = new HashMap();

    public AbstractPythonProcessService(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
    }

    public AbstractPythonProcessService(YamlService yaml) {
        super(yaml);
    }

    @Override
    protected void initializeFrom(YamlService yaml) {
        YamlProcess pSpec = yaml.getProcess();
        this.pythonArgs = new ArrayList<String>();
        if (pSpec != null) {
            this.locationKey = pSpec.getLocationKey();
            this.home = pSpec.getHomePath();
            this.pythonArgs.add(AbstractPythonProcessService.getPythonModule(pSpec.getExecutable(), yaml, this.home));
            List<String> cmdArg = pSpec.getSubstCmdArg();
            if (null != cmdArg) {
                this.pythonArgs.addAll(cmdArg);
            }
        } else {
            this.pythonArgs.add(AbstractPythonProcessService.getPythonModule(null, yaml, null));
        }
        if (null == this.home) {
            AbstractPythonProcessService.getLogger().warn("No home path given for service " + yaml.getId() + ". Falling back to temporary folder");
            this.home = FileUtils.createTmpFolder((String)FileUtils.sanitizeFileName((String)yaml.getId(), (boolean)true));
        }
    }

    protected File getHome() {
        return this.home;
    }

    private static String getPythonModule(String module, YamlService yaml, File homePath) {
        String result = module;
        if ((null == result || result.length() == 0) && homePath != null) {
            result = "ServiceEnvironment.py";
            File f = new File(homePath, "iip/ServiceEnvironment.py");
            if (f.exists()) {
                result = "iip/ServiceEnvironment.py";
            }
        }
        return result;
    }

    @Override
    public void activate() throws ExecutionException {
        super.setState(ServiceState.ACTIVATING);
        this.stop();
        super.setState(ServiceState.ACTIVATING);
    }

    @Override
    public void passivate() throws ExecutionException {
        super.setState(ServiceState.PASSIVATING);
        this.start();
        super.setState(ServiceState.PASSIVATED);
    }

    @Override
    public void setState(ServiceState state) throws ExecutionException {
        switch (state) {
            case STARTING: {
                this.start();
                break;
            }
            case STOPPING: {
                this.stop();
                break;
            }
        }
        super.setState(state);
    }

    protected boolean startExecutableByName() {
        return true;
    }

    protected void start() throws ExecutionException {
    }

    protected String scanInputStream(Process proc, InputHandler handler) {
        String result = null;
        Scanner sc = new Scanner(proc.getInputStream());
        while (sc.hasNextLine()) {
            String line = sc.nextLine();
            int pos = line.indexOf(124);
            if (pos > 0 && pos < line.length()) {
                String typeName = line.substring(0, pos);
                String data = line.substring(pos + 1);
                try {
                    if (!handler.handle(typeName, data)) continue;
                    break;
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Error processing " + line + ": " + e.getMessage());
                    continue;
                }
            }
            LoggerFactory.getLogger(this.getClass()).error("No type name in result " + line);
        }
        sc.close();
        return result;
    }

    protected Thread createScanInputThread(final Process proc, final InputHandler handler) {
        Thread result = new Thread(new Runnable(){

            @Override
            public void run() {
                AbstractPythonProcessService.this.scanInputStream(proc, handler);
            }
        });
        return result;
    }

    protected <O> void handleResult(Class<O> cls, String data, String typeName) {
        try {
            OutTypeInfo<?> info = this.outTypeInfos.get(typeName);
            if (null != info) {
                TypeTranslator outT = ((OutTypeInfo)info).outTranslator;
                if (outT != null) {
                    Object tmp = outT.to((Object)data);
                    if (null != ((OutTypeInfo)info).ingestor) {
                        ((OutTypeInfo)info).ingestor.ingest(tmp);
                    } else {
                        LoggerFactory.getLogger(this.getClass()).error("No ingestor registered for: " + typeName);
                    }
                } else {
                    LoggerFactory.getLogger(this.getClass()).error("No result type translator registered for: " + typeName);
                }
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Receiving result: " + e.getMessage());
        }
    }

    protected String toJson(Map<String, String> reconfValues) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(reconfValues);
        }
        catch (JsonProcessingException e) {
            AbstractPythonProcessService.getLogger().error("Translating " + reconfValues + " to JSON failed: " + e.getMessage());
            return "{}";
        }
    }

    protected Process createAndCustomizeProcess(String data, Map<String, String> reconfValues) throws ExecutionException {
        try {
            ArrayList<String> args = new ArrayList<String>();
            if (null != this.pythonArgs) {
                args.addAll(this.pythonArgs);
            }
            if (null != reconfValues && reconfValues.size() > 0) {
                args.add("--configure");
                args.add(this.toJson(reconfValues));
            }
            if (null != data) {
                args.add("--data");
                args.add(StringEscapeUtils.escapeJava((String)data));
            }
            Process proc = AbstractProcessService.createProcess(this.getPythonExecutable(), this.startExecutableByName(), this.home, args);
            this.handleErrorStream(proc.getErrorStream());
            return proc;
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    protected String getLocationKey() {
        return this.locationKey;
    }

    protected File getPythonExecutable() {
        File result = null;
        String key = this.getLocationKey();
        if (null != key) {
            result = InstalledDependenciesSetup.getInstance().getLocation(key);
        }
        if (null == result) {
            result = PythonUtils.getPythonExecutable();
        }
        return result;
    }

    protected void handleErrorStream(InputStream err) {
        AbstractProcessService.redirectIO(err, System.err);
    }

    protected void stop() {
    }

    protected static Logger getLogger() {
        return LoggerFactory.getLogger(AbstractPythonProcessService.class);
    }

    @Override
    public <I> void registerInputTypeTranslator(Class<I> inCls, String inTypeName, TypeTranslator<I, String> inTrans) {
        InTypeInfo<I> info = this.obtainInTypeInfo(inCls, inTypeName);
        ((InTypeInfo)info).inTranslator = inTrans;
    }

    public InTypeInfo<?> getInTypeInfo(String inTypeName) {
        return this.inTypeInfos.get(inTypeName);
    }

    private <I> InTypeInfo<I> obtainInTypeInfo(Class<I> cls, String typeName) {
        InTypeInfo<Object> info = this.inTypeInfos.get(typeName);
        if (null == info) {
            info = new InTypeInfo<I>(cls);
            this.inTypeInfos.put(typeName, info);
        }
        return info;
    }

    public OutTypeInfo<?> getOutTypeInfo(String outTypeName) {
        return this.outTypeInfos.get(outTypeName);
    }

    private <O> OutTypeInfo<O> obtainOutTypeInfo(Class<O> cls, String typeName) {
        OutTypeInfo<Object> info = this.outTypeInfos.get(typeName);
        if (null == info) {
            info = new OutTypeInfo<O>(cls);
            this.outTypeInfos.put(typeName, info);
        }
        return info;
    }

    @Override
    public <O> void registerOutputTypeTranslator(Class<O> outCls, String outTypeName, TypeTranslator<String, O> outTrans) {
        OutTypeInfo<O> info = this.obtainOutTypeInfo(outCls, outTypeName);
        ((OutTypeInfo)info).outTranslator = outTrans;
    }

    @Override
    public <O> void attachIngestor(Class<O> outCls, String outTypeName, DataIngestor<O> ingestor) {
        OutTypeInfo<O> info = this.obtainOutTypeInfo(outCls, outTypeName);
        ((OutTypeInfo)info).ingestor = ingestor;
    }

    protected static String compose(String typeName, String data) {
        return typeName + '|' + data;
    }

    protected static interface InputHandler {
        public boolean handle(String var1, String var2) throws IOException;
    }

    protected class OutTypeInfo<T>
    extends AbstractTypeInfo<T> {
        private TypeTranslator<String, T> outTranslator;
        private DataIngestor<T> ingestor;

        protected OutTypeInfo(Class<T> type) {
            super(type);
        }

        protected TypeTranslator<String, T> getOutTranslator() {
            return this.outTranslator;
        }
    }

    protected class InTypeInfo<T>
    extends AbstractTypeInfo<T> {
        private TypeTranslator<T, String> inTranslator;

        protected InTypeInfo(Class<T> type) {
            super(type);
        }

        protected TypeTranslator<T, String> getInTranslator() {
            return this.inTranslator;
        }
    }

    protected static abstract class AbstractTypeInfo<T> {
        private Class<T> type;

        protected AbstractTypeInfo(Class<T> type) {
            this.type = type;
        }

        protected Class<T> getType() {
            return this.type;
        }
    }
}

