/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment.services;

import de.iip_ecosphere.platform.services.environment.EnvironmentSetup;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.Starter;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.services.environment.services.TraceToAasService;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.AbstractAasLifecycleDescriptor;
import de.iip_ecosphere.platform.support.iip_aas.ApplicationSetup;
import de.iip_ecosphere.platform.support.iip_aas.Version;
import de.iip_ecosphere.platform.support.iip_aas.config.CmdLine;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import de.iip_ecosphere.platform.transport.status.TraceRecord;
import java.util.concurrent.ExecutionException;
import test.de.iip_ecosphere.platform.test.amqp.qpid.TestQpidServer;

public class TraceToAasServiceMain {
    private static Server qpid;
    private static MyLifecycleDescriptor aasDesc;
    private static Server registryServer;
    private static Server aasServer;

    public static void startup(String host, int aasRegistryPort, int aasServerPort, int aasProtocolPort) {
        AasPartRegistry.AasSetup aasSetup;
        ServerAddress broker = new ServerAddress(Schema.IGNORE);
        qpid = new TestQpidServer(broker);
        qpid.start();
        if (aasRegistryPort < 0 || aasServerPort < 0) {
            aasSetup = AasPartRegistry.AasSetup.createLocalEphemeralSetup(null, (boolean)false);
        } else {
            aasSetup = new AasPartRegistry.AasSetup();
            if (null != host && host.length() > 0) {
                aasSetup.getServer().setHost(host);
                aasSetup.getRegistry().setHost(host);
                aasSetup.getImplementation().setHost(host);
            }
            aasSetup.getServer().setPort(aasServerPort);
            aasSetup.getRegistry().setPort(aasRegistryPort);
            if (aasProtocolPort < 0) {
                aasProtocolPort = NetUtils.getEphemeralPort();
            }
            aasSetup.getImplementation().setPort(aasProtocolPort);
        }
        String fullRegUri = AasFactory.getInstance().getFullRegistryUri(aasSetup.getRegistryEndpoint());
        System.out.println("Registry: " + fullRegUri);
        ServerRecipe rcp = AasFactory.getInstance().createServerRecipe();
        Endpoint regEndpoint = aasSetup.getRegistryEndpoint();
        ServerRecipe.LocalPersistenceType pType = ServerRecipe.LocalPersistenceType.INMEMORY;
        System.out.println("Starting " + pType + " AAS registry on " + regEndpoint.toUri());
        registryServer = rcp.createRegistryServer(regEndpoint, (ServerRecipe.PersistenceType)pType, new String[0]);
        registryServer.start();
        Endpoint serverEndpoint = aasSetup.getServerEndpoint();
        System.out.println("Starting " + pType + " AAS server on " + serverEndpoint.toUri());
        aasServer = rcp.createAasServer(aasSetup.getServerEndpoint(), (ServerRecipe.PersistenceType)pType, regEndpoint, new String[0]);
        aasServer.start();
        aasDesc = new MyLifecycleDescriptor(aasSetup);
        aasDesc.startup(new String[0]);
        EnvironmentSetup setup = Starter.getSetup();
        setup.setAas(aasSetup);
        TransportSetup transSetup = new TransportSetup();
        transSetup.setHost("localhost");
        transSetup.setPort(broker.getPort());
        transSetup.setUser("user");
        transSetup.setPassword("pwd");
        setup.setTransport(transSetup);
    }

    public static void shutdown() {
        aasDesc.shutdown();
        registryServer.stop(true);
        aasServer.stop(true);
        qpid.stop(true);
    }

    public static TraceToAasService createService() {
        ApplicationSetup app = new ApplicationSetup();
        app.setName("myApp");
        app.setId("app-0");
        app.setVersion("1.2.3");
        app.setDescription("");
        app.setManufacturerName("IIP-Ecosphere@de");
        app.setManufacturerLogo("IIP-Ecosphere-Logo.png");
        app.setProductImage("AppImage.png");
        app.setManufacturerProductDesignation("A simple testing app.@de");
        ApplicationSetup.Address addr = new ApplicationSetup.Address();
        addr.setCityTown("Hildesheim@de");
        addr.setDepartment("Software Systems Engineering@de");
        addr.setStreet("Universit\u00e4tsplatz 1@de");
        addr.setZipCode("30419@de");
        app.setAddress(addr);
        YamlService sDesc = new YamlService();
        sDesc.setName("TraceAasTest");
        sDesc.setVersion(new Version("0.1.0"));
        sDesc.setKind(ServiceKind.SINK_SERVICE);
        sDesc.setId("TraceAasTest");
        sDesc.setDeployable(true);
        return new TraceToAasService(app, sDesc);
    }

    public static void main(String[] args) throws ExecutionException {
        System.out.println("Starting AAS server/registry.");
        int aasServerPort = CmdLine.getIntArg((String[])args, (String)"aasServerPort", (int)8080);
        int aasRegistryPort = CmdLine.getIntArg((String[])args, (String)"aasRegistryPort", (int)8081);
        int aasProtocolPort = CmdLine.getIntArg((String[])args, (String)"aasProtocolPort", (int)9000);
        String aasHost = CmdLine.getArg((String[])args, (String)"aasHost", (String)"localhost");
        TraceToAasServiceMain.startup(aasHost, aasServerPort, aasRegistryPort, aasProtocolPort);
        System.out.println("Creating TraceToAAS service.");
        TraceToAasService service = TraceToAasServiceMain.createService();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.out.println("Shutting down TraceToAAS service");
            try {
                service.setState(ServiceState.STOPPING);
            }
            catch (ExecutionException e) {
                System.out.println("While shutting down TraceToAAS service: " + e.getMessage());
            }
            TraceToAasServiceMain.shutdown();
            System.out.println("Shutdown done.");
        }));
        System.out.println("Starting TraceToAAS service");
        service.setState(ServiceState.STARTING);
        System.out.println("Starting messages");
        int[] img = new int[]{128, 128, 64, 12, 0, 8};
        MyData data = new MyData(img);
        Transport.sendTraceRecord((TraceRecord)new TraceRecord("source", "sending", (Object)data));
        TimeUtils.sleep((int)700);
        Transport.sendTraceRecord((TraceRecord)new TraceRecord("rtsa", "receiving", (Object)data));
        TimeUtils.sleep((int)700);
        Transport.sendTraceRecord((TraceRecord)new TraceRecord("rtsa", "sending", (Object)data));
        TimeUtils.sleep((int)1500);
        Transport.sendTraceRecord((TraceRecord)new TraceRecord("receiver", "receiving", (Object)data));
        TimeUtils.sleep((int)700);
        System.out.println("Messages sent. Waiting until CTRL-C.");
        while (true) {
            TimeUtils.sleep((int)1000);
        }
    }

    public static class MyData {
        private long timestamp;
        private int[] image;

        public MyData() {
        }

        public MyData(int[] image) {
            this.timestamp = System.currentTimeMillis();
            this.image = image;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int[] getImage() {
            return this.image;
        }
    }

    private static class MyLifecycleDescriptor
    extends AbstractAasLifecycleDescriptor {
        protected MyLifecycleDescriptor(AasPartRegistry.AasSetup setup) {
            super("MyAas", () -> setup);
        }
    }
}

