/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment.metricsProvider.utils;

import de.iip_ecosphere.platform.support.TimeUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.json.Json;
import javax.json.JsonObject;
import org.junit.Assert;
import test.de.iip_ecosphere.platform.services.environment.metricsProvider.utils.ThrowingRunnable;

public class TestUtils {
    public static final String DATA = "DATA";

    public static JsonObject readJsonFromResources(String folder, String filename) throws IOException {
        String rssName = "jsonsamples/" + folder + "/" + filename;
        StringBuilder sb = new StringBuilder();
        InputStreamReader reader = null;
        InputStream is = TestUtils.class.getClassLoader().getResourceAsStream(rssName);
        if (null != is) {
            reader = new InputStreamReader(is);
        } else {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(rssName);
            if (resource != null) {
                reader = new FileReader(resource.getFile());
            }
        }
        if (null == reader) {
            Assert.fail((String)("Cannot read " + rssName + ", neiter from file system nor from classpath"));
        }
        BufferedReader br = new BufferedReader(reader);
        while (br.ready()) {
            sb.append(br.readLine());
        }
        br.close();
        return Json.createReader((Reader)new StringReader(sb.toString())).readObject();
    }

    public static void oneSecondRunnable() {
        TimeUtils.sleep((int)1000);
    }

    public static void twoSecondRunnable() {
        TimeUtils.sleep((int)2000);
    }

    public static void threeSecondRunnable() {
        TimeUtils.sleep((int)3000);
    }

    public static String oneSecondSupplier() {
        TimeUtils.sleep((int)1000);
        return DATA;
    }

    public static String twoSecondSupplier() {
        TimeUtils.sleep((int)2000);
        return DATA;
    }

    public static String threeSecondSupplier() {
        TimeUtils.sleep((int)3000);
        return DATA;
    }

    public static <T extends Throwable> T assertThrows(Class<T> expectedThrowable, ThrowingRunnable runnable) {
        return TestUtils.assertThrows(null, expectedThrowable, runnable);
    }

    public static <T extends Throwable> T assertThrows(String message, Class<T> expectedThrowable, ThrowingRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable actualThrown) {
            Class<?> actualThrowable;
            String actual;
            if (expectedThrowable.isInstance(actualThrown)) {
                Throwable retVal = actualThrown;
                return (T)retVal;
            }
            String expected = TestUtils.formatClass(expectedThrowable);
            if (expected.equals(actual = TestUtils.formatClass(actualThrowable = actualThrown.getClass()))) {
                expected = expected + "@" + Integer.toHexString(System.identityHashCode(expectedThrowable));
                actual = actual + "@" + Integer.toHexString(System.identityHashCode(actualThrowable));
            }
            String mismatchMessage = TestUtils.buildPrefix(message) + TestUtils.format("unexpected exception type thrown;", expected, actual);
            AssertionError assertionError = new AssertionError((Object)mismatchMessage);
            ((Throwable)((Object)assertionError)).initCause(actualThrown);
            throw assertionError;
        }
        String notThrownMessage = TestUtils.buildPrefix(message) + String.format("expected %s to be thrown, but nothing was thrown", TestUtils.formatClass(expectedThrowable));
        throw new AssertionError((Object)notThrownMessage);
    }

    private static String buildPrefix(String message) {
        return message != null && message.length() != 0 ? message + ": " : "";
    }

    private static String formatClass(Class<?> value) {
        String className = value.getCanonicalName();
        return className == null ? value.getName() : className;
    }

    static String format(String message, Object expected, Object actual) {
        String actualString;
        String expectedString;
        String formatted = "";
        if (message != null && !"".equals(message)) {
            formatted = message + " ";
        }
        if (TestUtils.equalsRegardingNull(expectedString = String.valueOf(expected), actualString = String.valueOf(actual))) {
            return formatted + "expected: " + TestUtils.formatClassAndValue(expected, expectedString) + " but was: " + TestUtils.formatClassAndValue(actual, actualString);
        }
        return formatted + "expected:<" + expectedString + "> but was:<" + actualString + ">";
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return className + "<" + valueString + ">";
    }

    private static boolean equalsRegardingNull(Object expected, Object actual) {
        if (expected == null) {
            return actual == null;
        }
        return TestUtils.isEquals(expected, actual);
    }

    private static boolean isEquals(Object expected, Object actual) {
        return expected.equals(actual);
    }
}

