/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas;

import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MetricsAasConstructionBundle;
import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MetricsExtractorRestClient;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.environment.metricsProvider.utils.TestUtils;

public class MetricsAasConstructionBundleTest {
    private static Submodel.SubmodelBuilder smBuilder;
    private static Submodel.SubmodelBuilder smBuilder2;
    private static InvocablesCreator iCreator;
    private static InvocablesCreator iCreator2;
    private static MetricsExtractorRestClient client;
    private static MetricsExtractorRestClient client2;
    private static ProtocolServerBuilder pBuilder;
    private static ProtocolServerBuilder pBuilder2;
    private static MetricsAasConstructionBundle bundle;

    @BeforeClass
    public static void setUpVariables() {
        ServerAddress vabServerAddress = new ServerAddress(Schema.HTTP);
        AasFactory factory = AasFactory.getInstance();
        Aas.AasBuilder aasBuilder = factory.createAasBuilder("aasname", "urn:::aas");
        iCreator = factory.createInvocablesCreator("", vabServerAddress.getHost(), vabServerAddress.getPort());
        smBuilder = aasBuilder.createSubmodelBuilder("smname", "urn:::sm");
        pBuilder = AasFactory.getInstance().createProtocolServerBuilder("", vabServerAddress.getPort());
        client = new MetricsExtractorRestClient("localhost", 8080);
        Aas.AasBuilder aasBuilder2 = factory.createAasBuilder("aasname2", "urn:::aas2");
        iCreator2 = factory.createInvocablesCreator("", vabServerAddress.getHost(), vabServerAddress.getPort());
        smBuilder2 = aasBuilder2.createSubmodelBuilder("smname2", "urn:::sm2");
        pBuilder2 = AasFactory.getInstance().createProtocolServerBuilder("", vabServerAddress.getPort());
        client2 = new MetricsExtractorRestClient("localhost", 4040);
    }

    @Before
    public void setUpBundle() {
        bundle = new MetricsAasConstructionBundle((SubmodelElementContainerBuilder)smBuilder, pBuilder, iCreator, client);
    }

    @Test
    public void testInitOk() {
        MetricsAasConstructionBundle bundle = new MetricsAasConstructionBundle((SubmodelElementContainerBuilder)smBuilder, pBuilder, iCreator, client);
        bundle.setFilter(null);
        Assert.assertNotNull((Object)bundle);
        Assert.assertEquals((Object)smBuilder, (Object)bundle.getSubmodelBuilder());
        Assert.assertEquals((Object)iCreator, (Object)bundle.getInvocablesCreator());
        Assert.assertEquals((Object)client, (Object)bundle.getClient());
        Assert.assertEquals((Object)pBuilder, (Object)bundle.getProtocolBuilder());
        Assert.assertNull((Object)bundle.getFilter());
    }

    @Test
    public void testInitNullSubmodel() {
        TestUtils.assertThrows(IllegalArgumentException.class, () -> new MetricsAasConstructionBundle(null, pBuilder, iCreator, client));
    }

    @Test
    public void testInitNullProtocolBuilder() {
        TestUtils.assertThrows(IllegalArgumentException.class, () -> new MetricsAasConstructionBundle((SubmodelElementContainerBuilder)smBuilder, null, iCreator, client));
    }

    @Test
    public void testInitNullInvocablesCreator() {
        TestUtils.assertThrows(IllegalArgumentException.class, () -> new MetricsAasConstructionBundle((SubmodelElementContainerBuilder)smBuilder, pBuilder, null, client));
    }

    @Test
    public void testInitNullClient() {
        TestUtils.assertThrows(IllegalArgumentException.class, () -> new MetricsAasConstructionBundle((SubmodelElementContainerBuilder)smBuilder, pBuilder, iCreator, null));
    }

    @Test
    public void testSetSubmodelBuilder() {
        Assert.assertEquals((Object)smBuilder, (Object)bundle.getSubmodelBuilder());
        bundle.setSubmodelBuilder((SubmodelElementContainerBuilder)smBuilder2);
        Assert.assertEquals((Object)smBuilder2, (Object)bundle.getSubmodelBuilder());
    }

    @Test
    public void testSetInvocablesCreator() {
        Assert.assertEquals((Object)iCreator, (Object)bundle.getInvocablesCreator());
        bundle.setInvocablesCreator(iCreator2);
        Assert.assertEquals((Object)iCreator2, (Object)bundle.getInvocablesCreator());
    }

    @Test
    public void testSetClient() {
        Assert.assertEquals((Object)client, (Object)bundle.getClient());
        bundle.setClient(client2);
        Assert.assertEquals((Object)client2, (Object)bundle.getClient());
    }

    @Test
    public void testSetProtocolBuilder() {
        Assert.assertEquals((Object)pBuilder, (Object)bundle.getProtocolBuilder());
        bundle.setProtocolBuilder(pBuilder2);
        Assert.assertEquals((Object)pBuilder2, (Object)bundle.getProtocolBuilder());
    }
}

