/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentations;

import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.TimerRepresentation;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.environment.metricsProvider.utils.TestUtils;

public class TimerRepresentationTest {
    private static final String FOLDER = "timerrepresentation";
    private static final String JSON_VALID = "validTimer.json";
    private static final String JSON_CLEAN = "cleanTimer.json";
    private static final String JSON_SINGLE = "singleTimer.json";
    private static final String JSON_INVALID_BASE_UNIT = "invalidTimerBadBaseUnit.json";
    private static final String JSON_INVALID_TWO_MEASUREMENTS = "invalidTimerTwoMeasurements.json";
    private static final String JSON_INVALID_FOUR_MEASUREMENTS = "invalidTimerFourMeasurements.json";
    private static final String JSON_INVALID_WRONG_STATISTIC = "invalidTimerWrongStatistic.json";
    private static final String JSON_INVALID_TWO_COUNT = "invalidTimerTwoCount.json";
    private static final String JSON_INVALID_TWO_TOTAL = "invalidTimerTwoTotal.json";
    private static final String JSON_INVALID_TWO_MAX = "invalidTimerTwoMax.json";
    private static final double NANOS = 1.0E9;
    private static final double MICROS = 1000000.0;
    private static final double MILLIS = 1000.0;
    private static final double SECONDS = 1.0;
    private static final double MINUTES = 0.016667;
    private static final double HOURS = 2.7778E-4;
    private static final double DAYS = 1.15741E-5;

    @Test
    public void testInitOkNoTags() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID);
        ArrayList tagList = new ArrayList();
        Meter.Id id = new Meter.Id(obj.getString("name"), Tags.of(tagList), obj.getString("baseUnit"), obj.getString("description"), Meter.Type.TIMER);
        Timer timer = TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[0]);
        Assert.assertNotNull((Object)timer);
        Assert.assertEquals((Object)id, (Object)timer.getId());
        Assert.assertEquals((long)3L, (long)timer.count());
        Assert.assertEquals((double)6.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)3.0, (double)timer.max(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)timer.baseTimeUnit()));
    }

    @Test
    public void testInitOkWithTags() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID);
        ArrayList<ImmutableTag> tagList = new ArrayList<ImmutableTag>();
        tagList.add(new ImmutableTag("key1", "value1"));
        tagList.add(new ImmutableTag("key2", "value2"));
        Meter.Id id = new Meter.Id(obj.getString("name"), Tags.of(tagList), obj.getString("baseUnit"), obj.getString("description"), Meter.Type.TIMER);
        Timer timer = TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[]{"key1:value1", "key2:value2"});
        Assert.assertNotNull((Object)timer);
        Assert.assertEquals((Object)id, (Object)timer.getId());
        Assert.assertEquals((long)3L, (long)timer.count());
        Assert.assertEquals((double)6.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)3.0, (double)timer.max(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)timer.baseTimeUnit()));
    }

    @Test
    public void testInitBadInvalidBaseUnit() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_INVALID_BASE_UNIT);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[0]));
    }

    @Test
    public void testInitBadTwoMeasurements() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_INVALID_TWO_MEASUREMENTS);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[0]));
    }

    @Test
    public void testInitBadFourMeasurements() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_INVALID_FOUR_MEASUREMENTS);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[0]));
    }

    @Test
    public void testInitBadWrongStatistic() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_INVALID_WRONG_STATISTIC);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[0]));
    }

    @Test
    public void testInitBadTwoCount() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_INVALID_TWO_COUNT);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[0]));
    }

    @Test
    public void testInitBadTwoTotal() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_INVALID_TWO_TOTAL);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[0]));
    }

    @Test
    public void testInitBadTwoMax() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_INVALID_TWO_MAX);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[0]));
    }

    @Test
    public void testTakeSnapshot() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID);
        Timer timer = TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[0]);
        Assert.assertNotNull((Object)timer.takeSnapshot());
    }

    @Test
    public void testRecordLong() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_CLEAN);
        Timer timer = TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[0]);
        Assert.assertEquals((long)0L, (long)timer.count());
        Assert.assertEquals((double)0.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)0.0, (double)timer.max(TimeUnit.SECONDS), (double)0.0);
        timer.record(0L, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)timer.count());
        Assert.assertEquals((double)0.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)0.0, (double)timer.max(TimeUnit.SECONDS), (double)0.0);
        timer.record(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)timer.count());
        Assert.assertEquals((double)1.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)1.0, (double)timer.max(TimeUnit.SECONDS), (double)0.0);
        timer.record(-1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)timer.count());
        Assert.assertEquals((double)0.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)1.0, (double)timer.max(TimeUnit.SECONDS), (double)0.0);
    }

    @Test
    public void testRecordSupplier() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_CLEAN);
        Timer timer = TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[0]);
        Assert.assertEquals((long)0L, (long)timer.count());
        Assert.assertEquals((double)0.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)0.0, (double)timer.max(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((Object)"DATA", (Object)timer.record(() -> TestUtils.oneSecondSupplier()));
        Assert.assertEquals((long)1L, (long)timer.count());
        Assert.assertEquals((double)1.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.5);
        Assert.assertEquals((double)1.0, (double)timer.max(TimeUnit.SECONDS), (double)0.5);
        Assert.assertEquals((Object)"DATA", (Object)timer.record(() -> TestUtils.threeSecondSupplier()));
        Assert.assertEquals((long)2L, (long)timer.count());
        Assert.assertEquals((double)4.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.5);
        Assert.assertEquals((double)3.0, (double)timer.max(TimeUnit.SECONDS), (double)0.5);
        Assert.assertEquals((Object)"DATA", (Object)timer.record(() -> TestUtils.twoSecondSupplier()));
        Assert.assertEquals((long)3L, (long)timer.count());
        Assert.assertEquals((double)6.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.5);
        Assert.assertEquals((double)3.0, (double)timer.max(TimeUnit.SECONDS), (double)0.5);
    }

    @Test
    public void testRecordCallable() throws Exception {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_CLEAN);
        Timer timer = TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[0]);
        Assert.assertEquals((long)0L, (long)timer.count());
        Assert.assertEquals((double)0.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)0.0, (double)timer.max(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((Object)"DATA", (Object)timer.recordCallable(() -> TestUtils.oneSecondSupplier()));
        Assert.assertEquals((long)1L, (long)timer.count());
        Assert.assertEquals((double)1.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.5);
        Assert.assertEquals((double)1.0, (double)timer.max(TimeUnit.SECONDS), (double)0.5);
        Assert.assertEquals((Object)"DATA", (Object)timer.recordCallable(() -> TestUtils.threeSecondSupplier()));
        Assert.assertEquals((long)2L, (long)timer.count());
        Assert.assertEquals((double)4.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.5);
        Assert.assertEquals((double)3.0, (double)timer.max(TimeUnit.SECONDS), (double)0.5);
        Assert.assertEquals((Object)"DATA", (Object)timer.recordCallable(() -> TestUtils.twoSecondSupplier()));
        Assert.assertEquals((long)3L, (long)timer.count());
        Assert.assertEquals((double)6.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.5);
        Assert.assertEquals((double)3.0, (double)timer.max(TimeUnit.SECONDS), (double)0.5);
    }

    @Test
    public void testRecordRunnable() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_CLEAN);
        Timer timer = TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[0]);
        Assert.assertEquals((long)0L, (long)timer.count());
        Assert.assertEquals((double)0.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)0.0, (double)timer.max(TimeUnit.SECONDS), (double)0.0);
        timer.record(() -> TestUtils.oneSecondRunnable());
        Assert.assertEquals((long)1L, (long)timer.count());
        Assert.assertEquals((double)1.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.5);
        Assert.assertEquals((double)1.0, (double)timer.max(TimeUnit.SECONDS), (double)0.5);
        timer.record(() -> TestUtils.threeSecondRunnable());
        Assert.assertEquals((long)2L, (long)timer.count());
        Assert.assertEquals((double)4.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.5);
        Assert.assertEquals((double)3.0, (double)timer.max(TimeUnit.SECONDS), (double)0.5);
        timer.record(() -> TestUtils.twoSecondRunnable());
        Assert.assertEquals((long)3L, (long)timer.count());
        Assert.assertEquals((double)6.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.5);
        Assert.assertEquals((double)3.0, (double)timer.max(TimeUnit.SECONDS), (double)0.5);
    }

    @Test
    public void testTotalTimeConversion() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_SINGLE);
        Timer timer = TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[0]);
        Assert.assertEquals((double)1.0E9, (double)timer.totalTime(TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)1000000.0, (double)timer.totalTime(TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)1000.0, (double)timer.totalTime(TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)1.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)1.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)0.016667, (double)timer.totalTime(TimeUnit.MINUTES), (double)5.0E-7);
        Assert.assertEquals((double)2.7778E-4, (double)timer.totalTime(TimeUnit.HOURS), (double)5.0E-9);
        Assert.assertEquals((double)1.15741E-5, (double)timer.totalTime(TimeUnit.DAYS), (double)5.0E-11);
    }

    @Test
    public void testMaxTimeConversion() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_SINGLE);
        Timer timer = TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[0]);
        Assert.assertEquals((double)1.0E9, (double)timer.max(TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)1000000.0, (double)timer.max(TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)1000.0, (double)timer.max(TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)1.0, (double)timer.max(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)1.0, (double)timer.max(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)0.016667, (double)timer.max(TimeUnit.MINUTES), (double)5.0E-7);
        Assert.assertEquals((double)2.7778E-4, (double)timer.max(TimeUnit.HOURS), (double)5.0E-9);
        Assert.assertEquals((double)1.15741E-5, (double)timer.max(TimeUnit.DAYS), (double)5.0E-11);
    }

    @Test
    public void testGetUpdater() throws Exception {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_SINGLE);
        Timer timer = TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[0]);
        double second = TimeUnit.SECONDS.toNanos(1L);
        timer.record(1L, TimeUnit.SECONDS);
        timer.record(() -> TestUtils.oneSecondSupplier());
        timer.recordCallable(() -> TestUtils.oneSecondSupplier());
        timer.record(() -> TestUtils.oneSecondRunnable());
        JsonObject updater = ((TimerRepresentation)timer).getUpdater();
        JsonArray recordings = updater.getJsonArray("recordings");
        Assert.assertEquals((Object)obj.getString("name"), (Object)updater.getString("name"));
        Assert.assertEquals((long)4L, (long)recordings.size());
        for (int i = 0; i < recordings.size(); ++i) {
            Assert.assertEquals((double)second, (double)recordings.getJsonNumber(i).doubleValue(), (double)(second / 5.0));
        }
    }

    @Test
    public void testMeasure() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID);
        Timer timer = TimerRepresentation.parseTimer((JsonObject)obj, (String[])new String[0]);
        List measurements = (List)timer.measure();
        Assert.assertEquals((long)3L, (long)measurements.size());
        for (Measurement m : measurements) {
            double expected;
            switch (m.getStatistic()) {
                case COUNT: {
                    expected = timer.count();
                    break;
                }
                case MAX: {
                    expected = timer.max(TimeUnit.SECONDS);
                    break;
                }
                case TOTAL_TIME: {
                    expected = timer.totalTime(TimeUnit.SECONDS);
                    break;
                }
                default: {
                    expected = 0.0;
                    Assert.fail((String)"Not a valid statistic!");
                }
            }
            Assert.assertEquals((double)expected, (double)m.getValue(), (double)0.0);
        }
    }

    @Test
    public void testNameInitOk() {
        String name = "name";
        ArrayList tagList = new ArrayList();
        Meter.Id id = new Meter.Id(name, Tags.of(tagList), null, null, Meter.Type.TIMER);
        Timer timer = TimerRepresentation.createNewTimer((String)name);
        Assert.assertNotNull((Object)timer);
        Assert.assertEquals((Object)id, (Object)timer.getId());
        Assert.assertEquals((long)0L, (long)timer.count());
        Assert.assertEquals((double)0.0, (double)timer.totalTime(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)0.0, (double)timer.max(TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)timer.baseTimeUnit()));
        List measurements = (List)timer.measure();
        Assert.assertEquals((long)3L, (long)measurements.size());
        for (Measurement m : measurements) {
            double expected;
            switch (m.getStatistic()) {
                case COUNT: {
                    expected = timer.count();
                    break;
                }
                case MAX: {
                    expected = timer.max(TimeUnit.SECONDS);
                    break;
                }
                case TOTAL_TIME: {
                    expected = timer.totalTime(TimeUnit.SECONDS);
                    break;
                }
                default: {
                    expected = 0.0;
                    Assert.fail((String)"Not a valid statistic!");
                }
            }
            Assert.assertEquals((double)expected, (double)m.getValue(), (double)0.0);
        }
    }
}

