/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentations;

import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.GaugeRepresentation;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.io.IOException;
import java.util.ArrayList;
import javax.json.JsonObject;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.environment.metricsProvider.utils.TestUtils;

public class MeterRepresentationTest {
    private static final String FOLDER = "meterrepresentation";
    private static final String JSON_VALID = "valid.json";
    private static final String JSON_VALID_NO_BASE_UNIT = "validNoBaseUnit.json";
    private static final String JSON_VALID_NO_DESCRIPTION = "validNoDescription.json";
    private static final String JSON_INVALID_NO_NAME = "invalidNoName.json";
    private static final String JSON_INVALID_NO_NAME_VALUE = "invalidNoNameValue.json";
    private static final String JSON_INVALID_NO_BASE_UNIT = "invalidNoBaseUnit.json";
    private static final String JSON_INVALID_NO_DESCRIPTION = "invalidNoDescription.json";

    @Test
    public void testInitOkNoTags() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID);
        ArrayList tagList = new ArrayList();
        Meter.Id id = new Meter.Id(obj.getString("name"), Tags.of(tagList), obj.getString("baseUnit"), obj.getString("description"), Meter.Type.GAUGE);
        Gauge meter = GaugeRepresentation.parseGauge((JsonObject)obj, (String[])new String[0]);
        Assert.assertNotNull((Object)meter);
        Assert.assertEquals((Object)id, (Object)meter.getId());
    }

    @Test
    public void testInitOkWithTags() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID);
        ArrayList<ImmutableTag> tagList = new ArrayList<ImmutableTag>();
        tagList.add(new ImmutableTag("key1", "value1"));
        tagList.add(new ImmutableTag("key2", "value2"));
        Tags tags = Tags.of(tagList);
        Meter.Id id = new Meter.Id(obj.getString("name"), tags, obj.getString("baseUnit"), obj.getString("description"), Meter.Type.GAUGE);
        Gauge meter = GaugeRepresentation.parseGauge((JsonObject)obj, (String[])new String[]{"key1:value1", "key2:value2"});
        Assert.assertNotNull((Object)meter);
        Assert.assertEquals((Object)id, (Object)meter.getId());
    }

    @Test
    public void testInitOkNoTagsNoBaseUnitValue() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID_NO_BASE_UNIT);
        ArrayList tagList = new ArrayList();
        Meter.Id id = new Meter.Id(obj.getString("name"), Tags.of(tagList), null, obj.getString("description"), Meter.Type.OTHER);
        Gauge meter = GaugeRepresentation.parseGauge((JsonObject)obj, (String[])new String[0]);
        Assert.assertNotNull((Object)meter);
        Assert.assertEquals((Object)id, (Object)meter.getId());
    }

    @Test
    public void testInitOkNoTagsNoDescriptionValue() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID_NO_DESCRIPTION);
        ArrayList tagList = new ArrayList();
        Meter.Id id = new Meter.Id(obj.getString("name"), Tags.of(tagList), obj.getString("baseUnit"), null, Meter.Type.OTHER);
        Gauge meter = GaugeRepresentation.parseGauge((JsonObject)obj, (String[])new String[0]);
        Assert.assertNotNull((Object)meter);
        Assert.assertEquals((Object)id, (Object)meter.getId());
    }

    @Test
    public void testInitNullJson() {
        TestUtils.assertThrows(IllegalArgumentException.class, () -> GaugeRepresentation.parseGauge(null, (String[])new String[0]));
    }

    @Test
    public void testTagNoKey() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID_NO_DESCRIPTION);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> GaugeRepresentation.parseGauge((JsonObject)obj, (String[])new String[]{":value"}));
    }

    @Test
    public void testTagNoValue() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID_NO_DESCRIPTION);
        String[] tags = new String[]{"key:"};
        TestUtils.assertThrows(IllegalArgumentException.class, () -> GaugeRepresentation.parseGauge((JsonObject)obj, (String[])tags));
    }

    @Test
    public void testTagRandomString() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID_NO_DESCRIPTION);
        String[] tags = new String[]{"potato"};
        TestUtils.assertThrows(IllegalArgumentException.class, () -> GaugeRepresentation.parseGauge((JsonObject)obj, (String[])tags));
    }

    @Test
    public void testInvalidJsonNoName() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_INVALID_NO_NAME);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> GaugeRepresentation.parseGauge((JsonObject)obj, (String[])new String[0]));
    }

    @Test
    public void testInvalidJsonNoNameValue() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_INVALID_NO_NAME_VALUE);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> GaugeRepresentation.parseGauge((JsonObject)obj, (String[])new String[0]));
    }

    @Test
    public void testInvalidJsonNoBaseUnit() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_INVALID_NO_BASE_UNIT);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> GaugeRepresentation.parseGauge((JsonObject)obj, (String[])new String[0]));
    }

    @Test
    public void testInvalidJsonNoDescription() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_INVALID_NO_DESCRIPTION);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> GaugeRepresentation.parseGauge((JsonObject)obj, (String[])new String[0]));
    }

    @Test
    public void testNameInitOk() {
        String name = "name";
        ArrayList tagList = new ArrayList();
        Meter.Id id = new Meter.Id(name, Tags.of(tagList), null, null, Meter.Type.GAUGE);
        Gauge meter = GaugeRepresentation.createNewGauge((String)name);
        Assert.assertNotNull((Object)meter);
        Assert.assertEquals((Object)id, (Object)meter.getId());
    }

    @Test
    public void testNameInitNullName() {
        TestUtils.assertThrows(IllegalArgumentException.class, () -> GaugeRepresentation.createNewGauge(null));
    }

    @Test
    public void testNameInitEmptyName() {
        TestUtils.assertThrows(IllegalArgumentException.class, () -> GaugeRepresentation.createNewGauge((String)""));
    }
}

