/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentations;

import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.CounterRepresentation;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.environment.metricsProvider.utils.TestUtils;

public class CounterRepresentationTest {
    private static final String FOLDER = "counterrepresentation";
    private static final String JSON_VALID = "validCounter.json";
    private static final String JSON_UPDATER = "jsonUpdater.json";
    private static final String JSON_INVALID_TWO_MEASUREMENTS = "invalidCounterTwoMeasurements.json";
    private static final String JSON_INVALID_WRONG_STATISTIC = "invalidCounterWrongStatistic.json";

    @Test
    public void testInitOkNoTags() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID);
        ArrayList tagList = new ArrayList();
        Meter.Id id = new Meter.Id(obj.getString("name"), Tags.of(tagList), obj.getString("baseUnit"), obj.getString("description"), Meter.Type.COUNTER);
        Counter counter = CounterRepresentation.parseCounter((JsonObject)obj, (String[])new String[0]);
        Assert.assertNotNull((Object)counter);
        Assert.assertEquals((Object)id, (Object)counter.getId());
        Assert.assertEquals((double)((JsonValue)obj.getJsonArray("measurements").get(0)).asJsonObject().getJsonNumber("value").doubleValue(), (double)counter.count(), (double)0.0);
    }

    @Test
    public void testInitOkWithTags() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID);
        ArrayList<ImmutableTag> tagList = new ArrayList<ImmutableTag>();
        tagList.add(new ImmutableTag("key1", "value1"));
        tagList.add(new ImmutableTag("key2", "value2"));
        Meter.Id id = new Meter.Id(obj.getString("name"), Tags.of(tagList), obj.getString("baseUnit"), obj.getString("description"), Meter.Type.COUNTER);
        Counter counter = CounterRepresentation.parseCounter((JsonObject)obj, (String[])new String[]{"key1:value1", "key2:value2"});
        Assert.assertNotNull((Object)counter);
        Assert.assertEquals((Object)id, (Object)counter.getId());
        Assert.assertEquals((double)((JsonValue)obj.getJsonArray("measurements").get(0)).asJsonObject().getJsonNumber("value").doubleValue(), (double)counter.count(), (double)0.0);
    }

    @Test
    public void testInitBadTwoMeasurements() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_INVALID_TWO_MEASUREMENTS);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> CounterRepresentation.parseCounter((JsonObject)obj, (String[])new String[0]));
    }

    @Test
    public void testInitBadWrongStatistic() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_INVALID_WRONG_STATISTIC);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> CounterRepresentation.parseCounter((JsonObject)obj, (String[])new String[0]));
    }

    @Test
    public void testIncrementByOne() throws IOException {
        double increment = 1.0;
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID);
        double original = ((JsonValue)obj.getJsonArray("measurements").get(0)).asJsonObject().getJsonNumber("value").doubleValue();
        Counter counter = CounterRepresentation.parseCounter((JsonObject)obj, (String[])new String[0]);
        Assert.assertEquals((double)original, (double)counter.count(), (double)0.0);
        counter.increment(increment);
        Assert.assertEquals((double)(original + increment), (double)counter.count(), (double)0.0);
    }

    @Test
    public void testIncrementByZero() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID);
        double original = ((JsonValue)obj.getJsonArray("measurements").get(0)).asJsonObject().getJsonNumber("value").doubleValue();
        Counter counter = CounterRepresentation.parseCounter((JsonObject)obj, (String[])new String[0]);
        Assert.assertEquals((double)original, (double)counter.count(), (double)0.0);
        counter.increment(0.0);
        Assert.assertEquals((double)original, (double)counter.count(), (double)0.0);
    }

    @Test
    public void testIncrementByNegativeOne() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID);
        Counter counter = CounterRepresentation.parseCounter((JsonObject)obj, (String[])new String[0]);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> counter.increment(-1.0));
    }

    @Test
    public void testGetUpdater() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID);
        JsonObject expected = TestUtils.readJsonFromResources(FOLDER, JSON_UPDATER);
        Counter counter = CounterRepresentation.parseCounter((JsonObject)obj, (String[])new String[0]);
        counter.increment(5.1);
        JsonObject updater = ((CounterRepresentation)counter).getUpdater();
        Assert.assertEquals((Object)expected, (Object)updater);
    }

    @Test
    public void testMeasure() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID);
        Counter counter = CounterRepresentation.parseCounter((JsonObject)obj, (String[])new String[0]);
        List measurements = (List)counter.measure();
        Assert.assertEquals((long)1L, (long)measurements.size());
        Assert.assertEquals((Object)Statistic.COUNT, (Object)((Measurement)measurements.get(0)).getStatistic());
        Assert.assertEquals((double)counter.count(), (double)((Measurement)measurements.get(0)).getValue(), (double)0.0);
    }

    @Test
    public void testNameInitOk() {
        String name = "name";
        ArrayList tagList = new ArrayList();
        Meter.Id id = new Meter.Id(name, Tags.of(tagList), null, null, Meter.Type.COUNTER);
        Counter counter = CounterRepresentation.createNewCounter((String)name);
        Assert.assertNotNull((Object)counter);
        Assert.assertEquals((Object)id, (Object)counter.getId());
        Assert.assertEquals((double)0.0, (double)counter.count(), (double)0.0);
        List measurements = (List)counter.measure();
        Assert.assertEquals((long)1L, (long)measurements.size());
        Assert.assertEquals((Object)Statistic.COUNT, (Object)((Measurement)measurements.get(0)).getStatistic());
        Assert.assertEquals((double)counter.count(), (double)((Measurement)measurements.get(0)).getValue(), (double)0.0);
    }
}

