/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment.metricsProvider;

import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.types.ConnectorInputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ConnectorOutputTypeTranslator;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MonitoredTranslatingProtocolAdapter;
import de.iip_ecosphere.platform.support.TimeUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class MonitoredTranslatingProtocolAdapterTest {
    @Test
    public void testAdapterWithLog() {
        File log = new File(FileUtils.getTempDirectory(), "monTest.log");
        log.deleteOnExit();
        MonitoredTranslatingProtocolAdapterTest.testAdapter(log);
    }

    @Test
    public void testAdapterWithoutLog() {
        MonitoredTranslatingProtocolAdapterTest.testAdapter(null);
    }

    private static void testAdapter(File log) {
        SimpleMeterRegistry reg = new SimpleMeterRegistry();
        MetricsProvider metrics = new MetricsProvider((MeterRegistry)reg);
        MonitoredTranslatingProtocolAdapter adapter = new MonitoredTranslatingProtocolAdapter((ConnectorOutputTypeTranslator)new ConnectorOutTranslator(), (ConnectorInputTypeTranslator)new ConnectorInTranslator(), metrics, log);
        int max = 10;
        for (int i = 0; i < 10; ++i) {
            try {
                adapter.adaptInput(adapter.adaptOutput((Object)"test"));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Timer iTimer = reg.get("adaptInputTime").timer();
        double tmp = iTimer.mean(TimeUnit.MILLISECONDS);
        Assert.assertTrue((140.0 <= tmp && tmp <= 200.0 ? 1 : 0) != 0);
        Assert.assertEquals((long)10L, (long)iTimer.count());
        Timer oTimer = reg.get("adaptOutputTime").timer();
        tmp = oTimer.mean(TimeUnit.MILLISECONDS);
        Assert.assertTrue((90.0 <= tmp && tmp <= 150.0 ? 1 : 0) != 0);
        Assert.assertEquals((long)10L, (long)oTimer.count());
        if (null != log) {
            Assert.assertTrue((boolean)log.exists());
            Assert.assertTrue((log.length() > 0L ? 1 : 0) != 0);
            try {
                System.out.println("LOG:");
                System.out.println(FileUtils.readFileToString((File)log, (String)"UTF-8"));
            }
            catch (IOException t) {
                t.printStackTrace();
            }
            FileUtils.deleteQuietly((File)log);
        }
    }

    private static class ConnectorInTranslator
    implements ConnectorInputTypeTranslator<ConnectorData, String> {
        private ConnectorInTranslator() {
        }

        public String from(ConnectorData data) throws IOException {
            TimeUtils.sleep((int)150);
            return data.data;
        }

        public ModelAccess getModelAccess() {
            return null;
        }

        public void setModelAccess(ModelAccess modelAccess) {
        }

        public Class<? extends String> getSourceType() {
            return String.class;
        }

        public Class<? extends ConnectorData> getTargetType() {
            return ConnectorData.class;
        }
    }

    private static class ConnectorOutTranslator
    implements ConnectorOutputTypeTranslator<String, ConnectorData> {
        private ConnectorOutTranslator() {
        }

        public ConnectorData to(String source) throws IOException {
            TimeUtils.sleep((int)100);
            ConnectorData result = new ConnectorData();
            result.data = source;
            return result;
        }

        public ModelAccess getModelAccess() {
            return null;
        }

        public void setModelAccess(ModelAccess modelAccess) {
        }

        public void initializeModelAccess() throws IOException {
        }

        public Class<? extends String> getSourceType() {
            return String.class;
        }

        public Class<? extends ConnectorData> getTargetType() {
            return ConnectorData.class;
        }
    }

    private static class ConnectorData {
        private String data;

        private ConnectorData() {
        }
    }
}

