/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment.metricsProvider;

import de.iip_ecosphere.platform.services.environment.metricsProvider.CapacityBaseUnit;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.environment.metricsProvider.utils.TestUtils;

public class MetricsProviderTest {
    private static final String ID_OK = "id.ok";
    private static final String ID_GOOD = "id.good";
    private static final String ID_PASSABLE = "id.passable";
    private static final String ID_BAD = "id.bad";
    private static MetricsProvider provider;

    protected MetricsProvider createProvider(MeterRegistry registry) {
        return new MetricsProvider(registry);
    }

    @Before
    public void setUpMetricsProvider() {
        provider = this.createProvider((MeterRegistry)new SimpleMeterRegistry());
    }

    @Test
    public void testInitOk() {
        MetricsProvider mProvider = this.createProvider((MeterRegistry)new SimpleMeterRegistry());
        Assert.assertNotNull((Object)mProvider);
    }

    @Test
    public void testInitNull() {
        TestUtils.assertThrows(IllegalArgumentException.class, () -> this.createProvider(null));
    }

    @Test
    public void testGaugeCrudOperations() {
        double value = 1.0;
        double value2 = 1.2;
        double negVal = -1.3;
        Assert.assertEquals((long)0L, (long)provider.getNumberOfCustomGauges());
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeGauge(ID_BAD));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeGauge(null));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.addGaugeValue(null, 1.0));
        Assert.assertEquals((long)0L, (long)provider.getNumberOfCustomGauges());
        provider.addGaugeValue(ID_GOOD, value);
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomGauges());
        Assert.assertEquals((double)value, (double)provider.getGaugeValue(ID_GOOD), (double)0.0);
        provider.addGaugeValue(ID_GOOD, value2);
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomGauges());
        Assert.assertEquals((double)value2, (double)provider.getGaugeValue(ID_GOOD), (double)0.0);
        provider.calculateMetrics();
        Assert.assertTrue((provider.getRegisteredGaugeValue("system.memory.total") > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)value2, (double)provider.getRegisteredGaugeValue(ID_GOOD), (double)0.0);
        provider.addGaugeValue(ID_GOOD, negVal);
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomGauges());
        Assert.assertEquals((double)negVal, (double)provider.getGaugeValue(ID_GOOD), (double)0.0);
        Assert.assertEquals((double)0.0, (double)provider.getGaugeValue(ID_BAD), (double)0.0);
        Assert.assertEquals((double)0.0, (double)provider.getGaugeValue(null), (double)0.0);
        provider.removeGauge(ID_GOOD);
        Assert.assertEquals((long)0L, (long)provider.getNumberOfCustomGauges());
        Assert.assertEquals((double)0.0, (double)provider.getGaugeValue(ID_GOOD), (double)0.0);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeGauge(ID_GOOD));
    }

    @Test
    public void testCounterCrudOperations() {
        double value = 1.1;
        double valueX2 = value + value;
        double negValue = -value;
        Assert.assertEquals((long)0L, (long)provider.getNumberOfCustomCounters());
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeCounter(ID_BAD));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeCounter(null));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.increaseCounter(null));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.increaseCounterBy(null, value));
        Assert.assertEquals((long)0L, (long)provider.getNumberOfCustomCounters());
        provider.increaseCounter(ID_GOOD);
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomCounters());
        Assert.assertEquals((double)1.0, (double)provider.getCounterValue(ID_GOOD), (double)0.0);
        provider.increaseCounter(ID_GOOD);
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomCounters());
        Assert.assertEquals((double)2.0, (double)provider.getCounterValue(ID_GOOD), (double)0.0);
        Assert.assertEquals((double)2.0, (double)provider.getRegisteredCounterValue(ID_GOOD), (double)0.0);
        provider.increaseCounterBy(ID_OK, value);
        Assert.assertEquals((long)2L, (long)provider.getNumberOfCustomCounters());
        Assert.assertEquals((double)value, (double)provider.getCounterValue(ID_OK), (double)0.0);
        provider.increaseCounterBy(ID_OK, value);
        Assert.assertEquals((long)2L, (long)provider.getNumberOfCustomCounters());
        Assert.assertEquals((double)valueX2, (double)provider.getCounterValue(ID_OK), (double)0.0);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.increaseCounterBy(ID_OK, negValue));
        Assert.assertEquals((long)2L, (long)provider.getNumberOfCustomCounters());
        Assert.assertEquals((double)valueX2, (double)provider.getCounterValue(ID_OK), (double)0.0);
        Assert.assertEquals((double)0.0, (double)provider.getCounterValue(ID_BAD), (double)0.0);
        Assert.assertEquals((double)0.0, (double)provider.getCounterValue(null), (double)0.0);
        provider.removeCounter(ID_GOOD);
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomCounters());
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeCounter(ID_GOOD));
    }

    private void prepareTimerCrudTest() {
        Assert.assertEquals((long)0L, (long)provider.getNumberOfCustomTimers());
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeTimer(ID_BAD));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeTimer(null));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.recordWithTimer(null, () -> TestUtils.oneSecondRunnable()));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.recordWithTimer(ID_GOOD, (Runnable)null));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> {
            String cfr_ignored_0 = (String)provider.recordWithTimer(null, () -> TestUtils.oneSecondSupplier());
        });
        TestUtils.assertThrows(IllegalArgumentException.class, () -> {
            String cfr_ignored_0 = (String)provider.recordWithTimer(ID_GOOD, (Supplier)null);
        });
        Assert.assertEquals((long)0L, (long)provider.getNumberOfCustomTimers());
    }

    @Test
    public void testTimerCrudOperations() {
        this.prepareTimerCrudTest();
        provider.recordWithTimer(ID_GOOD, () -> TestUtils.oneSecondRunnable());
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)1.0, (double)provider.getTotalTimeFromTimer(ID_GOOD), (double)0.5);
        Assert.assertEquals((double)1.0, (double)provider.getMaxTimeFromTimer(ID_GOOD), (double)0.5);
        Assert.assertEquals((long)1L, (long)provider.getTimerCount(ID_GOOD));
        provider.recordWithTimer(ID_GOOD, () -> TestUtils.threeSecondRunnable());
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)4.0, (double)provider.getTotalTimeFromTimer(ID_GOOD), (double)0.5);
        Assert.assertEquals((double)3.0, (double)provider.getMaxTimeFromTimer(ID_GOOD), (double)0.5);
        Assert.assertEquals((long)2L, (long)provider.getTimerCount(ID_GOOD));
        Assert.assertEquals((long)2L, (long)provider.getRegisteredTimerCount(ID_GOOD));
        provider.recordWithTimer(ID_GOOD, () -> TestUtils.twoSecondRunnable());
        Assert.assertEquals((long)1L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)6.0, (double)provider.getTotalTimeFromTimer(ID_GOOD), (double)0.5);
        Assert.assertEquals((double)3.0, (double)provider.getMaxTimeFromTimer(ID_GOOD), (double)0.5);
        Assert.assertEquals((long)3L, (long)provider.getTimerCount(ID_GOOD));
        Assert.assertEquals((Object)"DATA", (Object)provider.recordWithTimer(ID_OK, () -> TestUtils.oneSecondSupplier()));
        Assert.assertEquals((long)2L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)1.0, (double)provider.getTotalTimeFromTimer(ID_OK), (double)0.5);
        Assert.assertEquals((double)1.0, (double)provider.getMaxTimeFromTimer(ID_OK), (double)0.5);
        Assert.assertEquals((long)1L, (long)provider.getTimerCount(ID_OK));
        Assert.assertEquals((Object)"DATA", (Object)provider.recordWithTimer(ID_OK, () -> TestUtils.threeSecondSupplier()));
        Assert.assertEquals((long)2L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)4.0, (double)provider.getTotalTimeFromTimer(ID_OK), (double)0.5);
        Assert.assertEquals((double)3.0, (double)provider.getMaxTimeFromTimer(ID_OK), (double)0.5);
        Assert.assertEquals((long)2L, (long)provider.getTimerCount(ID_OK));
        Assert.assertEquals((Object)"DATA", (Object)provider.recordWithTimer(ID_OK, () -> TestUtils.twoSecondSupplier()));
        Assert.assertEquals((long)2L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)6.0, (double)provider.getTotalTimeFromTimer(ID_OK), (double)0.5);
        Assert.assertEquals((double)3.0, (double)provider.getMaxTimeFromTimer(ID_OK), (double)0.5);
        Assert.assertEquals((long)3L, (long)provider.getTimerCount(ID_OK));
        provider.recordWithTimer(ID_PASSABLE, 1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)3L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)1.0, (double)provider.getTotalTimeFromTimer(ID_PASSABLE), (double)0.0);
        Assert.assertEquals((double)1.0, (double)provider.getMaxTimeFromTimer(ID_PASSABLE), (double)0.0);
        Assert.assertEquals((long)1L, (long)provider.getTimerCount(ID_PASSABLE));
        provider.recordWithTimer(ID_PASSABLE, 3000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)3L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)4.0, (double)provider.getTotalTimeFromTimer(ID_PASSABLE), (double)0.0);
        Assert.assertEquals((double)3.0, (double)provider.getMaxTimeFromTimer(ID_PASSABLE), (double)0.0);
        Assert.assertEquals((long)2L, (long)provider.getTimerCount(ID_PASSABLE));
        provider.recordWithTimer(ID_PASSABLE, 2000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)3L, (long)provider.getNumberOfCustomTimers());
        Assert.assertEquals((double)6.0, (double)provider.getTotalTimeFromTimer(ID_PASSABLE), (double)0.0);
        Assert.assertEquals((double)3.0, (double)provider.getMaxTimeFromTimer(ID_PASSABLE), (double)0.0);
        Assert.assertEquals((long)3L, (long)provider.getTimerCount(ID_PASSABLE));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.recordWithTimer(ID_PASSABLE, -1000L, TimeUnit.MILLISECONDS));
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.recordWithTimer(ID_PASSABLE, 1000L, null));
        Assert.assertEquals((double)0.0, (double)provider.getTotalTimeFromTimer(ID_BAD), (double)0.0);
        Assert.assertEquals((double)0.0, (double)provider.getTotalTimeFromTimer(null), (double)0.0);
        Assert.assertEquals((double)0.0, (double)provider.getMaxTimeFromTimer(ID_BAD), (double)0.0);
        Assert.assertEquals((double)0.0, (double)provider.getMaxTimeFromTimer(null), (double)0.0);
        Assert.assertEquals((long)0L, (long)provider.getTimerCount(ID_BAD));
        Assert.assertEquals((long)0L, (long)provider.getTimerCount(null));
        provider.removeTimer(ID_GOOD);
        Assert.assertEquals((long)2L, (long)provider.getNumberOfCustomTimers());
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.removeTimer(ID_GOOD));
    }

    @Test
    public void setMemoryBaseUnitOk() {
        provider.setMemoryBaseUnit(CapacityBaseUnit.KILOBYTES);
        Assert.assertEquals((Object)CapacityBaseUnit.KILOBYTES, (Object)provider.getMemoryBaseUnit());
    }

    @Test
    public void setMemoryBaseUnitNull() {
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.setMemoryBaseUnit(null));
    }

    @Test
    public void setDiskBaseUnitOk() {
        provider.setDiskBaseUnit(CapacityBaseUnit.MEGABYTES);
        Assert.assertEquals((Object)CapacityBaseUnit.MEGABYTES, (Object)provider.getDiskBaseUnit());
    }

    @Test
    public void setDiskBaseUnitNull() {
        TestUtils.assertThrows(IllegalArgumentException.class, () -> provider.setDiskBaseUnit(null));
    }

    @Test
    public void testLists() {
        this.assertList(provider.getCustomCounterList(), provider.getNumberOfCustomCounters() == 0);
        this.assertList(provider.getCustomGaugeList(), provider.getNumberOfCustomGauges() == 0);
        this.assertList(provider.getCustomTimerList(), provider.getNumberOfCustomTimers() == 0);
        this.assertList(provider.getTaggedMeterList(), false);
        this.assertList(provider.getSimpleMeterList(), false);
    }

    private void assertList(String list, boolean expectedEmpty) {
        if (expectedEmpty) {
            Assert.assertEquals((Object)"[]", (Object)list);
        } else {
            Assert.assertTrue((list.length() > 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)list.matches("\\[(\"\\S+\"(,\\s*\"\\S+\")*)?\\]"));
        }
    }
}

