/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslators;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;

public class ReconfigureTest {
    private int param1;
    private String param2;
    private int param3;

    @Test
    public void testReconfigureFailWithRecovery() {
        this.param1 = 0;
        this.param2 = null;
        this.param3 = 10;
        HashMap configurers = new HashMap();
        AbstractService.addConfigurer(configurers, (String)"param1", Integer.class, (TypeTranslator)TypeTranslators.INTEGER, v -> {
            this.param1 = v;
        }, () -> this.param1);
        AbstractService.addConfigurer(configurers, (String)"param2", String.class, (TypeTranslator)TypeTranslators.STRING, v -> {
            this.param2 = v;
        }, () -> this.param2);
        AbstractService.addConfigurer(configurers, (String)"param3", Integer.class, (TypeTranslator)TypeTranslators.INTEGER, v -> {
            this.param3 = v;
        });
        TreeMap<String, String> values = new TreeMap<String, String>();
        values.put("param1", "20");
        values.put("param2", "abba");
        values.put("param3", "abba");
        try {
            AbstractService.reconfigure(values, n -> (ParameterConfigurer)configurers.get(n), (boolean)true, (ServiceState)ServiceState.AVAILABLE);
            Assert.fail();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.param1);
        Assert.assertNull((Object)this.param2);
        Assert.assertEquals((long)10L, (long)this.param3);
    }

    @Test
    public void testReconfigureFailWithoutRecovery() {
        this.param1 = 0;
        this.param2 = null;
        this.param3 = 10;
        HashMap configurers = new HashMap();
        AbstractService.addConfigurer(configurers, (String)"param1", Integer.class, (TypeTranslator)TypeTranslators.INTEGER, v -> {
            this.param1 = v;
        }, () -> this.param1);
        AbstractService.addConfigurer(configurers, (String)"param2", String.class, (TypeTranslator)TypeTranslators.STRING, v -> {
            this.param2 = v;
        }, () -> this.param2);
        AbstractService.addConfigurer(configurers, (String)"param3", Integer.class, (TypeTranslator)TypeTranslators.INTEGER, v -> {
            this.param3 = v;
        });
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("param1", "20");
        values.put("param2", "abba");
        values.put("param3", "abba");
        try {
            AbstractService.reconfigure(values, n -> (ParameterConfigurer)configurers.get(n), (boolean)false, (ServiceState)ServiceState.AVAILABLE);
            Assert.fail();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        Assert.assertTrue((this.param1 == 0 || this.param1 == 20 ? 1 : 0) != 0);
        Assert.assertTrue((this.param2 == null || this.param2.equals("abba") ? 1 : 0) != 0);
        Assert.assertEquals((long)10L, (long)this.param3);
    }

    @Test
    public void testReconfigureSuccessful() {
        this.param1 = 0;
        this.param2 = null;
        this.param3 = 10;
        HashMap configurers = new HashMap();
        AbstractService.addConfigurer(configurers, (String)"param1", Integer.class, (TypeTranslator)TypeTranslators.INTEGER, v -> {
            this.param1 = v;
        }, () -> this.param1);
        AbstractService.addConfigurer(configurers, (String)"param2", String.class, (TypeTranslator)TypeTranslators.STRING, v -> {
            this.param2 = v;
        }, () -> this.param2);
        AbstractService.addConfigurer(configurers, (String)"param3", Integer.class, (TypeTranslator)TypeTranslators.INTEGER, v -> {
            this.param3 = v;
        });
        HashMap values = new HashMap();
        ((ParameterConfigurer)configurers.get("param1")).addValue(values, (Object)20);
        ((ParameterConfigurer)configurers.get("param2")).addValue(values, (Object)"abba");
        ((ParameterConfigurer)configurers.get("param3")).addValue(values, (Object)-1);
        try {
            AbstractService.reconfigure(values, n -> (ParameterConfigurer)configurers.get(n), (boolean)true, (ServiceState)ServiceState.AVAILABLE);
        }
        catch (ExecutionException e) {
            Assert.fail();
        }
        Assert.assertEquals((long)20L, (long)this.param1);
        Assert.assertEquals((Object)"abba", (Object)this.param2);
        Assert.assertEquals((long)-1L, (long)this.param3);
        this.param1 = 0;
        this.param2 = null;
        this.param3 = 10;
        try {
            AbstractService.reconfigure(values, n -> (ParameterConfigurer)configurers.get(n), (boolean)false, (ServiceState)ServiceState.AVAILABLE);
        }
        catch (ExecutionException e) {
            Assert.fail();
        }
        Assert.assertEquals((long)20L, (long)this.param1);
        Assert.assertEquals((Object)"abba", (Object)this.param2);
        Assert.assertEquals((long)-1L, (long)this.param3);
    }

    @Test
    public void testReconfigureNull() throws ExecutionException {
        AbstractService.reconfigure(null, null, (boolean)false, (ServiceState)ServiceState.AVAILABLE);
    }
}

