/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.DataIngestor;
import de.iip_ecosphere.platform.services.environment.PythonAsyncProcessService;
import de.iip_ecosphere.platform.services.environment.PythonSyncProcessService;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlProcess;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.iip_aas.Version;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslators;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.environment.pythonEnv.Rec13;
import test.de.iip_ecosphere.platform.services.environment.pythonEnv.Rec13Impl;
import test.de.iip_ecosphere.platform.services.environment.pythonEnv.Rec13InTranslator;
import test.de.iip_ecosphere.platform.services.environment.pythonEnv.Rec13OutTranslator;

public class PythonProcessServiceTest {
    private List<String> composeCmdLineArguments() {
        File f = new File("src/test/python");
        ArrayList<String> args = new ArrayList<String>();
        args.add("--mode");
        args.add("console");
        args.add("--modulesPath");
        args.add(f.getAbsolutePath());
        args.add("--sid");
        args.add("1234");
        return args;
    }

    @Test
    public void testAsyncProcessService() throws ExecutionException, IOException {
        final AtomicInteger receivedStringCount = new AtomicInteger(0);
        final AtomicInteger receivedRec13Count = new AtomicInteger(0);
        YamlService sDesc = new YamlService();
        sDesc.setName("Test");
        sDesc.setVersion(new Version("0.0.1"));
        sDesc.setKind(ServiceKind.TRANSFORMATION_SERVICE);
        sDesc.setId("Test");
        sDesc.setDeployable(true);
        YamlProcess pDesc = new YamlProcess();
        pDesc.setHomePath("src/main/python");
        pDesc.setCmdArg(this.composeCmdLineArguments());
        sDesc.setProcess(pDesc);
        String stringTypeName = "S";
        String rec13TypeName = "Rec13";
        PythonAsyncProcessService service = new PythonAsyncProcessService(sDesc);
        service.enableFileDeletion(false);
        service.registerInputTypeTranslator(String.class, "S", TypeTranslators.STRING);
        service.registerOutputTypeTranslator(String.class, "S", TypeTranslators.STRING);
        service.attachIngestor(String.class, "S", (DataIngestor)new DataIngestor<String>(){

            public void ingest(String data) {
                receivedStringCount.incrementAndGet();
            }
        });
        service.registerInputTypeTranslator(Rec13.class, "Rec13", (TypeTranslator)new Rec13InTranslator());
        service.registerOutputTypeTranslator(Rec13.class, "Rec13", (TypeTranslator)new Rec13OutTranslator());
        service.attachIngestor(Rec13.class, "Rec13", (DataIngestor)new DataIngestor<Rec13>(){

            public void ingest(Rec13 data) {
                receivedRec13Count.incrementAndGet();
            }
        });
        service.setState(ServiceState.STARTING);
        service.process("S", (Object)"test");
        service.process("S", (Object)"test");
        service.processQuiet("S", (Object)"test");
        Rec13Impl r = new Rec13Impl();
        r.setIntField(10);
        r.setStringField("abba");
        service.process("Rec13", (Object)r);
        TimeUtils.sleep((int)1000);
        service.setState(ServiceState.STOPPING);
        Assert.assertEquals((long)3L, (long)receivedStringCount.get());
        service.activate();
        service.passivate();
    }

    @Test
    public void testSyncProcessService() throws ExecutionException, IOException {
        YamlService sDesc = new YamlService();
        sDesc.setName("Test");
        sDesc.setVersion(new Version("0.0.1"));
        sDesc.setKind(ServiceKind.TRANSFORMATION_SERVICE);
        sDesc.setId("Test");
        sDesc.setDeployable(true);
        YamlProcess pDesc = new YamlProcess();
        pDesc.setHomePath("src/main/python");
        pDesc.setCmdArg(this.composeCmdLineArguments());
        sDesc.setProcess(pDesc);
        String stringTypeName = "S";
        String rec13TypeName = "Rec13";
        PythonSyncProcessService service = new PythonSyncProcessService(sDesc);
        service.registerInputTypeTranslator(String.class, "S", TypeTranslators.STRING);
        service.registerOutputTypeTranslator(String.class, "S", TypeTranslators.STRING);
        service.registerInputTypeTranslator(Rec13.class, "Rec13", (TypeTranslator)new Rec13InTranslator());
        service.registerOutputTypeTranslator(Rec13.class, "Rec13", (TypeTranslator)new Rec13OutTranslator());
        service.setState(ServiceState.STARTING);
        Assert.assertEquals((Object)"test", (Object)service.process("S", (Object)"test"));
        Assert.assertEquals((Object)"test", (Object)service.process("S", (Object)"test"));
        Assert.assertEquals((Object)"test", (Object)service.processQuiet("S", (Object)"test"));
        Rec13Impl r = new Rec13Impl();
        r.setIntField(10);
        r.setStringField("abba");
        Assert.assertEquals((Object)r, (Object)service.processQuiet("Rec13", (Object)r));
        service.setState(ServiceState.STOPPING);
        service.activate();
        service.passivate();
    }
}

