/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.PythonUtils;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasServer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import org.junit.Ignore;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.environment.AasCreator;
import test.de.iip_ecosphere.platform.services.environment.AbstractEnvironmentTest;
import test.de.iip_ecosphere.platform.services.environment.MyService;

public class PythonEnvironmentTest
extends AbstractEnvironmentTest {
    private static void redirectIO(final InputStream src, final PrintStream dest) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Scanner sc = new Scanner(src);
                while (sc.hasNextLine()) {
                    dest.println(sc.nextLine());
                }
                sc.close();
            }
        }).start();
    }

    public static Process createPythonProcess(File dir, String ... args) throws IOException {
        String pythonPath = PythonUtils.getPythonExecutable().toString();
        System.out.println("Using Python: " + pythonPath);
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(pythonPath);
        for (String a : args) {
            tmp.add(a);
        }
        System.out.println("Cmd line: " + tmp);
        ProcessBuilder processBuilder = new ProcessBuilder(tmp);
        processBuilder.directory(dir);
        Process python = processBuilder.start();
        PythonEnvironmentTest.redirectIO(python.getInputStream(), System.out);
        PythonEnvironmentTest.redirectIO(python.getErrorStream(), System.err);
        return python;
    }

    public static Process createPythonProcess(String ... args) throws IOException {
        return PythonEnvironmentTest.createPythonProcess(new File("./src/test/python"), args);
    }

    @Test
    public void testPythonEnvironment() throws IOException, ExecutionException {
        this.testPythonEnvironment("");
    }

    @Test
    public void testPythonEnvironmentHttp() throws IOException, ExecutionException {
        this.testPythonEnvironment("VAB-HTTP");
    }

    @Test
    @Ignore(value="VAB-HTTPS Server does not yet exist, certificate use on in support.aas.BaSyx unclear")
    public void testPythonEnvironmentHttps() throws IOException, ExecutionException {
        this.testPythonEnvironment("VAB-HTTPS");
    }

    private void testPythonEnvironment(String protocol) throws IOException, ExecutionException {
        ServerAddress vabServer = new ServerAddress(Schema.HTTP);
        ArrayList<String> args = new ArrayList<String>();
        args.add("__init__.py");
        args.add("--port");
        args.add(String.valueOf(vabServer.getPort()));
        if (protocol.length() > 0) {
            args.add("--protocol");
            args.add(protocol);
        }
        String[] tmp = new String[args.size()];
        Process python = PythonEnvironmentTest.createPythonProcess(args.toArray(tmp));
        TimeUtils.sleep((int)1000);
        ServerAddress aasServer = new ServerAddress(Schema.HTTP);
        Endpoint aasServerBase = new Endpoint(aasServer, "");
        Endpoint aasServerRegistry = new Endpoint(aasServer, "registry");
        MyService service = new MyService();
        Aas aas = AasCreator.createAas(vabServer, (Service)service, protocol);
        AasServer httpServer = AasFactory.getInstance().createDeploymentRecipe(aasServerBase).addInMemoryRegistry(aasServerRegistry.getEndpoint()).deploy(aas).createServer(new String[0]).start();
        AbstractEnvironmentTest.testAas(aasServerRegistry, (Service)service);
        httpServer.stop(true);
        python.destroy();
    }
}

