/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.AbstractProcessService;
import de.iip_ecosphere.platform.services.environment.AbstractStringProcessService;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlProcess;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.iip_aas.Version;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class ProcessServiceTest {
    @Test
    public void testProcessService() throws ExecutionException, IOException {
        final AtomicInteger receivedCount = new AtomicInteger(0);
        ReceptionCallback<String> rcp = new ReceptionCallback<String>(){

            public void received(String data) {
                Assert.assertTrue((data != null && data.length() > 0 ? 1 : 0) != 0);
                receivedCount.incrementAndGet();
            }

            public Class<String> getType() {
                return String.class;
            }
        };
        YamlService sDesc = new YamlService();
        sDesc.setName("Test");
        sDesc.setVersion(new Version("0.0.1"));
        sDesc.setKind(ServiceKind.TRANSFORMATION_SERVICE);
        sDesc.setId("Test");
        sDesc.setDeployable(true);
        YamlProcess pDesc = new YamlProcess();
        pDesc.setExecutable("java");
        pDesc.setHomePath("target/test-classes");
        sDesc.setProcess(pDesc);
        Assert.assertTrue((AbstractProcessService.getProcessId(null) < 0L ? 1 : 0) != 0);
        TestService service = new TestService(new InDataTypeTranslator(), new OutDataTypeTranslator(), rcp, sDesc);
        service.setState(ServiceState.STARTING);
        service.process("test");
        service.process("test");
        service.process("test");
        long pid = service.getPid();
        service.setState(ServiceState.STOPPING);
        Assert.assertEquals((long)3L, (long)receivedCount.get());
        Assert.assertTrue((pid > 0L ? 1 : 0) != 0);
        service.activate();
        service.passivate();
    }

    @Test
    public void testNamingSupport() {
        Assert.assertTrue((AbstractProcessService.getOsArch((boolean)true).length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((AbstractProcessService.getOsArch((boolean)false).length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)AbstractProcessService.getExecutableSuffix());
        String exec = AbstractProcessService.getExecutableName((String)"test", (String)"1.2.3");
        Assert.assertNotNull((Object)exec);
        Assert.assertTrue((exec.indexOf("test") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((exec.indexOf("1.2.3") >= 0 ? 1 : 0) != 0);
    }

    private static class OutDataTypeTranslator
    implements TypeTranslator<String, String> {
        private OutDataTypeTranslator() {
        }

        public String from(String data) throws IOException {
            return null;
        }

        public String to(String source) throws IOException {
            return source;
        }
    }

    private static class InDataTypeTranslator
    implements TypeTranslator<String, String> {
        private InDataTypeTranslator() {
        }

        public String from(String data) throws IOException {
            return null;
        }

        public String to(String source) throws IOException {
            return source;
        }
    }

    private static class TestService
    extends AbstractStringProcessService<String, String> {
        protected TestService(TypeTranslator<String, String> inTrans, TypeTranslator<String, String> outTrans, ReceptionCallback<String> callback, YamlService yaml) {
            super(inTrans, outTrans, callback, yaml);
        }

        public void migrate(String resourceId) throws ExecutionException {
        }

        public void update(URI location) throws ExecutionException {
        }

        public void switchTo(String targetId) throws ExecutionException {
        }

        public void reconfigure(Map<String, String> values) throws ExecutionException {
        }

        protected int getWaitTimeBeforeDestroy() {
            return 2000;
        }

        protected ServiceState start() throws ExecutionException {
            YamlProcess sSpec = this.getProcessSpec();
            File exe = (File)TestService.selectNotNull((Object)sSpec, s -> s.getExecutablePath(), (Object)new File("java"));
            File home = (File)TestService.selectNotNull((Object)sSpec, s -> s.getHomePath(), (Object)new File("target/test-classes"));
            ArrayList<String> args = new ArrayList<String>();
            args.add("test.de.iip_ecosphere.platform.services.environment.ForwardingApp");
            this.addProcessSpecCmdArg(args);
            this.createAndConfigureProcess(exe, true, home, args);
            return null;
        }
    }
}

