/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.security.services.kodex;

import de.iip_ecosphere.platform.security.services.kodex.KodexRestService;
import de.iip_ecosphere.platform.security.services.kodex.MultiKodexRestService;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlProcess;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.iip_aas.Version;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;
import test.de.iip_ecosphere.platform.security.services.kodex.InData;
import test.de.iip_ecosphere.platform.security.services.kodex.InDataJsonTypeTranslator;
import test.de.iip_ecosphere.platform.security.services.kodex.OutData;
import test.de.iip_ecosphere.platform.security.services.kodex.OutDataJsonTypeTranslator;

public class KodexRestServiceTest {
    private static boolean measure = Boolean.valueOf(System.getProperty("kodex.measure", "true"));
    private long startTime;
    private long endTime;
    private long count = 0L;
    private ArrayList<Long[]> runtime = new ArrayList();

    private void setStartTime(long start) {
        this.startTime = start;
    }

    private void setEndTime(long end) {
        this.endTime = end;
    }

    private void setCount(long newCount) {
        this.count = newCount;
    }

    private long getStartTime() {
        return this.startTime;
    }

    private long getEndTime() {
        return this.endTime;
    }

    private long getCount() {
        return this.count;
    }

    private long calcRuntime() {
        return this.getEndTime() - this.getStartTime();
    }

    private void createExcelFile(ArrayList<Long[]> runtimeList) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet("RestRuntime");
        String[] columnHeadings = new String[]{"Tupel amount", "Runtime in ms"};
        Font headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)12);
        headerFont.setColor(IndexedColors.BLACK.index);
        CellStyle headerStyle = workbook.createCellStyle();
        headerStyle.setFont(headerFont);
        headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headerStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        Row headerRow = sheet.createRow(0);
        for (int i = 0; i < columnHeadings.length; ++i) {
            Cell cell = headerRow.createCell(i);
            cell.setCellValue(columnHeadings[i]);
            cell.setCellStyle(headerStyle);
        }
        CellStyle contentStyle = workbook.createCellStyle();
        contentStyle.setAlignment(HorizontalAlignment.CENTER);
        int rowCount = 1;
        for (Long[] item : this.runtime) {
            Row row = sheet.createRow(rowCount++);
            Cell tupelAmount = row.createCell(0);
            tupelAmount.setCellValue((double)item[0].longValue());
            tupelAmount.setCellStyle(contentStyle);
            Cell runtime = row.createCell(1);
            runtime.setCellValue((double)item[1].longValue());
            runtime.setCellStyle(contentStyle);
        }
        for (int i = 0; i < columnHeadings.length; ++i) {
            sheet.autoSizeColumn(i);
        }
        File folder = new File("./measures");
        folder.mkdirs();
        File output = new File(folder, "RestRuntime.xlsx");
        FileOutputStream fileOutputStream = new FileOutputStream(output);
        workbook.write((OutputStream)fileOutputStream);
        fileOutputStream.close();
        workbook.close();
        LoggerFactory.getLogger(KodexRestServiceTest.class).info("Excel file (RestRuntime.xlsx) with runtime measures created in {}", (Object)output);
    }

    private static void process(KodexRestService<InData, OutData> service, InData data) throws IOException {
        if (!measure) {
            LoggerFactory.getLogger(KodexRestServiceTest.class).info("Input: {id=\"" + data.getId() + "\" name=\"" + data.getName() + "\"}");
        }
        service.process((Object)data);
    }

    @Test(timeout=360000L)
    public void testKodexRestService() throws IOException, ExecutionException {
        final AtomicInteger receivedCount = new AtomicInteger(0);
        ReceptionCallback<OutData> rcp = new ReceptionCallback<OutData>(){

            public void received(OutData data) {
                boolean smallCounts;
                Assert.assertTrue((data.getId() != null && data.getId().length() > 0 ? 1 : 0) != 0);
                Assert.assertTrue((data.getName() != null && data.getName().length() > 0 ? 1 : 0) != 0);
                Assert.assertTrue((data.getKip() != null && data.getKip().length() > 0 ? 1 : 0) != 0);
                receivedCount.incrementAndGet();
                if (!measure) {
                    LoggerFactory.getLogger(KodexRestServiceTest.class).info("Received result: {kip=\"" + data.getKip() + "\" id=\"" + data.getId() + "\" name=\"" + data.getName() + "\"}");
                }
                KodexRestServiceTest.this.setCount(KodexRestServiceTest.this.getCount() + 1L);
                boolean bl = smallCounts = KodexRestServiceTest.this.getCount() == 1L || KodexRestServiceTest.this.getCount() == 10L || KodexRestServiceTest.this.getCount() == 100L;
                if (smallCounts || KodexRestServiceTest.this.getCount() == 1000L || KodexRestServiceTest.this.getCount() == 10000L || KodexRestServiceTest.this.getCount() == 15000L) {
                    KodexRestServiceTest.this.setEndTime(System.currentTimeMillis());
                    Long[] tmp = new Long[]{KodexRestServiceTest.this.getCount(), KodexRestServiceTest.this.calcRuntime()};
                    KodexRestServiceTest.this.runtime.add(tmp);
                }
            }

            public Class<OutData> getType() {
                return OutData.class;
            }
        };
        YamlService sDesc = new YamlService();
        sDesc.setName("KodexRestTest");
        sDesc.setVersion(new Version("0.1.6"));
        sDesc.setKind(ServiceKind.TRANSFORMATION_SERVICE);
        sDesc.setId("KodexRestTest");
        sDesc.setDeployable(true);
        YamlProcess pDesc = new YamlProcess();
        pDesc.setExecutablePath(new File("./src/main/resources/"));
        pDesc.setHomePath(new File("./src/test/resources"));
        sDesc.setProcess(pDesc);
        new KodexRestService((TypeTranslator)new InDataJsonTypeTranslator(), (TypeTranslator)new OutDataJsonTypeTranslator(), (ReceptionCallback)rcp, sDesc);
        KodexRestService service = new KodexRestService((TypeTranslator)new InDataJsonTypeTranslator(), (TypeTranslator)new OutDataJsonTypeTranslator(), (ReceptionCallback)rcp, sDesc, "example-data.yml");
        service.setState(ServiceState.STARTING);
        this.setCount(0L);
        this.setStartTime(System.currentTimeMillis());
        int max = measure ? 15000 : 100;
        for (int i = 0; i < max; ++i) {
            KodexRestServiceTest.process((KodexRestService<InData, OutData>)service, new InData("test", "test"));
        }
        TimeUtils.sleep((int)2500);
        LoggerFactory.getLogger(KodexRestServiceTest.class).info("Stopping service, may take two minutes on Windows");
        service.setState(ServiceState.STOPPING);
        Assert.assertTrue((receivedCount.get() > 0 ? 1 : 0) != 0);
        LoggerFactory.getLogger(KodexRestServiceTest.class).info("Activating/Passivating");
        service.activate();
        LoggerFactory.getLogger(KodexRestServiceTest.class).info("Passivating service, may take two minutes on Windows");
        service.passivate();
        this.createExcelFile(this.runtime);
    }

    @Test
    public void testMultiKodexRestService() throws ExecutionException {
        AtomicInteger receivedCount = new AtomicInteger(0);
        YamlService sDesc = new YamlService();
        sDesc.setName("KodexRestTest");
        sDesc.setVersion(new Version("0.1.6"));
        sDesc.setKind(ServiceKind.TRANSFORMATION_SERVICE);
        sDesc.setId("KodexRestTest");
        sDesc.setDeployable(true);
        YamlProcess pDesc = new YamlProcess();
        pDesc.setExecutablePath(new File("./src/main/resources/"));
        pDesc.setHomePath(new File("./src/test/resources"));
        sDesc.setProcess(pDesc);
        MultiKodexRestService service = new MultiKodexRestService(sDesc, "example-data.yml");
        service.registerInputTypeTranslator(InData.class, "items", (TypeTranslator)new InDataJsonTypeTranslator());
        service.registerOutputTypeTranslator(OutData.class, "items", (TypeTranslator)new OutDataJsonTypeTranslator());
        service.attachIngestor(OutData.class, "items", data -> {
            Assert.assertTrue((data.getId() != null && data.getId().length() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((data.getName() != null && data.getName().length() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((data.getKip() != null && data.getKip().length() > 0 ? 1 : 0) != 0);
            receivedCount.incrementAndGet();
        });
        service.setState(ServiceState.STARTING);
        service.processQuiet("items", (Object)new InData("test", "test"));
        service.processQuiet("items", (Object)new InData("test", "test"));
        service.processQuiet("items", (Object)new InData("test", "test"));
        TimeUtils.sleep((int)2500);
        LoggerFactory.getLogger(KodexRestServiceTest.class).info("Stopping service, may take two minutes on Windows");
        service.setState(ServiceState.STOPPING);
        Assert.assertTrue((receivedCount.get() > 0 ? 1 : 0) != 0);
    }
}

