/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.monitoring;

import de.iip_ecosphere.platform.monitoring.MonitoringReceiver;
import de.iip_ecosphere.platform.monitoring.MonitoringSetup;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import de.iip_ecosphere.platform.transport.status.StatusMessage;
import io.micrometer.core.instrument.Meter;
import java.util.HashSet;
import java.util.Set;
import javax.json.JsonObject;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.monitoring.AbstractMonitoringReceiverTest;
import test.de.iip_ecosphere.platform.test.amqp.qpid.TestQpidServer;

public class MonitoringReceiverTest
extends AbstractMonitoringReceiverTest {
    @Override
    protected Server createBroker(ServerAddress broker) {
        return new TestQpidServer(broker);
    }

    @Test
    public void testReceiver() {
        MyMonitoringReceiverLifecycle mrl = new MyMonitoringReceiverLifecycle();
        this.runScenario(mrl);
        mrl.getInstance().doAsserts();
    }

    protected class MyMonitoringReceiverLifecycle
    implements AbstractMonitoringReceiverTest.MonitoringRecieverLifecycle {
        private MyReceiver receiver;

        protected MyMonitoringReceiverLifecycle() {
        }

        @Override
        public void start(TransportSetup transSetup) {
            MonitoringSetup.getInstance().setTransport(transSetup);
            this.receiver = new MyReceiver();
            this.receiver.start();
        }

        @Override
        public void stop() {
            this.receiver.stop();
        }

        protected MyReceiver getInstance() {
            return this.receiver;
        }
    }

    protected class MyReceiver
    extends MonitoringReceiver {
        private String createdExporterId;
        private Set<String> receivedMeterStreams = new HashSet<String>();
        private int statusCount;
        private int meterRecCount;
        private int meterCount;
        private int meterCount2;

        protected MyReceiver() {
        }

        protected MonitoringReceiver.Exporter createExporter(String id) {
            return new MyExporter(id);
        }

        protected void notifyMeterReception(String stream, String id, JsonObject obj) {
            this.receivedMeterStreams.add(stream);
            ++this.meterRecCount;
        }

        protected void notifyStatusReceived(StatusMessage msg) {
            ++this.statusCount;
        }

        protected void notifyMeterAdded(Meter meter) {
            if (meter != null) {
                ++this.meterCount2;
            }
        }

        protected void doAsserts() {
            String deviceId = Id.getDeviceId();
            Assert.assertEquals((Object)deviceId, (Object)this.createdExporterId);
            Assert.assertTrue((boolean)this.receivedMeterStreams.contains("EcsMetrics"));
            Assert.assertTrue((boolean)this.receivedMeterStreams.contains("ServiceMetrics"));
            Assert.assertTrue((this.statusCount >= 4 ? 1 : 0) != 0);
            Assert.assertTrue((this.meterRecCount > 0 ? 1 : 0) != 0);
            Assert.assertTrue((this.meterCount > 0 ? 1 : 0) != 0);
            Assert.assertTrue((this.meterCount2 > 0 ? 1 : 0) != 0);
        }

        private class MyExporter
        extends MonitoringReceiver.Exporter {
            protected MyExporter(String id) {
                super((MonitoringReceiver)MyReceiver.this, id);
                MyReceiver.this.createdExporterId = id;
            }

            protected void initialize() {
            }

            protected void addMeter(Meter meter) {
                if (meter != null) {
                    ++MyReceiver.this.meterCount;
                }
            }
        }
    }
}

