/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.monitoring;

import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.CounterRepresentation;
import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.GaugeRepresentation;
import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.TimerRepresentation;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.Submodel;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;

public class TimeRecorder {
    private static final int LOOP = 200;
    private Submodel sm;
    private ArrayList<JsonObject> objects;
    private ArrayList<JsonArray> arrays;
    private ArrayList<Counter> counters;
    private ArrayList<Gauge> gauges;
    private ArrayList<Timer> timers;
    private JsonObject meter;
    private String[] tags;
    private long start;
    private long retrieve;
    private long parse;
    private long counterRT = 0L;
    private long counterPT = 0L;
    private long counterTT = 0L;
    private long gaugeRT = 0L;
    private long gaugePT = 0L;
    private long gaugeTT = 0L;
    private long timerRT = 0L;
    private long timerPT = 0L;
    private long timerTT = 0L;

    public static void main(String[] args) throws IOException, ExecutionException {
        TimeRecorder rec = new TimeRecorder();
        rec.initialize();
        System.out.println("Connection established successfully, retrieving data...");
        System.out.println();
        rec.measure();
        rec.printResults();
    }

    private void initialize() throws IOException {
        Endpoint registry = new Endpoint(new ServerAddress(Schema.HTTP, 4001), "registry");
        AasFactory factory = AasFactory.getInstance();
        Aas aas = factory.obtainRegistry(registry).retrieveAas("urn:::prototype.four.aas");
        this.sm = aas.getSubmodel("proto4sm");
    }

    private void measure() throws ExecutionException {
        for (int k = 0; k < 200; ++k) {
            int i;
            this.counters = new ArrayList();
            this.objects = new ArrayList();
            this.arrays = new ArrayList();
            this.start = System.nanoTime();
            this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("suppliercustomcounter").getValue()));
            this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("consumercustomcounter").getValue()));
            this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("jvmgcmemoryallocated").getValue()));
            this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("jvmgcmemorypromoted").getValue()));
            this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("jvmclassesunloaded").getValue()));
            this.arrays.add(TimeRecorder.retrieveArray(this.sm.getProperty("logbackevents").getValue()));
            this.retrieve = System.nanoTime();
            for (JsonObject jo : this.objects) {
                this.counters.add(CounterRepresentation.parseCounter((JsonObject)jo, (String[])new String[0]));
            }
            for (JsonArray ja : this.arrays) {
                for (i = 0; i < ja.size(); ++i) {
                    this.tags = TimeRecorder.retrieveTags(ja.getJsonObject(i).getJsonArray("tags"));
                    this.meter = ja.getJsonObject(i).getJsonObject("meter");
                    this.counters.add(CounterRepresentation.parseCounter((JsonObject)this.meter, (String[])this.tags));
                }
            }
            this.parse = System.nanoTime();
            this.counterRT += (this.retrieve - this.start) / (long)this.counters.size();
            this.counterPT += (this.parse - this.retrieve) / (long)this.counters.size();
            this.counterTT += (this.parse - this.start) / (long)this.counters.size();
            this.gauges = new ArrayList();
            this.objects = new ArrayList();
            this.arrays = new ArrayList();
            this.start = System.nanoTime();
            this.add();
            this.retrieve = System.nanoTime();
            for (JsonObject jo : this.objects) {
                this.gauges.add(GaugeRepresentation.parseGauge((JsonObject)jo, (String[])new String[0]));
            }
            for (JsonArray ja : this.arrays) {
                for (i = 0; i < ja.size(); ++i) {
                    this.tags = TimeRecorder.retrieveTags(ja.getJsonObject(i).getJsonArray("tags"));
                    this.meter = ja.getJsonObject(i).getJsonObject("meter");
                    this.gauges.add(GaugeRepresentation.parseGauge((JsonObject)this.meter, (String[])this.tags));
                }
            }
            this.parse = System.nanoTime();
            this.gaugeRT += (this.retrieve - this.start) / (long)this.gauges.size();
            this.gaugePT += (this.parse - this.retrieve) / (long)this.gauges.size();
            this.gaugeTT += (this.parse - this.start) / (long)this.gauges.size();
            this.timers = new ArrayList();
            this.objects = new ArrayList();
            this.arrays = new ArrayList();
            this.start = System.nanoTime();
            this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("suppliercustomtimer").getValue()));
            this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("consumercustomtimer").getValue()));
            this.arrays.add(TimeRecorder.retrieveArray(this.sm.getProperty("jvmgcpause").getValue()));
            this.retrieve = System.nanoTime();
            for (JsonObject jo : this.objects) {
                this.timers.add(TimerRepresentation.parseTimer((JsonObject)jo, (String[])new String[0]));
            }
            for (JsonArray ja : this.arrays) {
                for (i = 0; i < ja.size(); ++i) {
                    this.tags = TimeRecorder.retrieveTags(ja.getJsonObject(i).getJsonArray("tags"));
                    this.meter = ja.getJsonObject(i).getJsonObject("meter");
                    this.timers.add(TimerRepresentation.parseTimer((JsonObject)this.meter, (String[])this.tags));
                }
            }
            this.parse = System.nanoTime();
            this.timerRT += (this.retrieve - this.start) / (long)this.timers.size();
            this.timerPT += (this.parse - this.retrieve) / (long)this.timers.size();
            this.timerTT += (this.parse - this.start) / (long)this.timers.size();
        }
    }

    private void printResults() {
        System.out.println("Printing mean results for 200 loops:");
        System.out.println();
        System.out.println("Counter Retrieval Time: " + this.counterRT / 200L);
        System.out.println("Counter Parsing Time: " + this.counterPT / 200L);
        System.out.println("Counter Total Time: " + this.counterTT / 200L);
        System.out.println();
        System.out.println("Gauge Retrieval Time: " + this.gaugeRT / 200L);
        System.out.println("Gauge Parsing Time: " + this.gaugePT / 200L);
        System.out.println("Gauge Total Time: " + this.gaugeTT / 200L);
        System.out.println();
        System.out.println("Timer Retrieval Time: " + this.timerRT / 200L);
        System.out.println("Timer Parsing Time: " + this.timerPT / 200L);
        System.out.println("Timer Total Time: " + this.timerTT / 200L);
    }

    private void add() throws ExecutionException {
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("suppliercustomgauge").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("consumercustomgauge").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("consumerreceptiongauge").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("jvmgclivedatasize").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("jvmgcmaxdatasize").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("jvmthreadsdaemon").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("jvmthreadslive").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("jvmthreadspeak").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("processcpuusage").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("processstarttime").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("processuptime").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("systemcpuusage").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("Storage_Free").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("Storage_Capacity").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("Storage_Usable").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("Allocated_Storage").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("Memory_Free").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("Memory_Capacity").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("Allocated_Memory").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("Memory_Used").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("systemcpucount").getValue()));
        this.objects.add(TimeRecorder.retrieveObject(this.sm.getProperty("jvmclassesloaded").getValue()));
        this.arrays.add(TimeRecorder.retrieveArray(this.sm.getProperty("jvmthreadsstates").getValue()));
        this.arrays.add(TimeRecorder.retrieveArray(this.sm.getProperty("jvmmemorycommitted").getValue()));
        this.arrays.add(TimeRecorder.retrieveArray(this.sm.getProperty("jvmmemorymax").getValue()));
        this.arrays.add(TimeRecorder.retrieveArray(this.sm.getProperty("jvmmemoryused").getValue()));
        this.arrays.add(TimeRecorder.retrieveArray(this.sm.getProperty("jvmbuffermemoryused").getValue()));
        this.arrays.add(TimeRecorder.retrieveArray(this.sm.getProperty("jvmbuffertotalcapacity").getValue()));
        this.arrays.add(TimeRecorder.retrieveArray(this.sm.getProperty("jvmbuffercount").getValue()));
    }

    private static JsonObject retrieveObject(Object json) {
        return Json.createReader((Reader)new StringReader(String.valueOf(json))).readObject();
    }

    private static JsonArray retrieveArray(Object json) {
        return Json.createReader((Reader)new StringReader(String.valueOf(json))).readArray();
    }

    private static String[] retrieveTags(JsonArray tagsArr) {
        String[] tags = new String[tagsArr.size()];
        for (int i = 0; i < tagsArr.size(); ++i) {
            tags[i] = tagsArr.getString(i);
        }
        return tags;
    }
}

