/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.monitoring;

import de.iip_ecosphere.platform.ecsRuntime.Monitor;
import de.iip_ecosphere.platform.monitoring.MonitoringSetup;
import de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import de.iip_ecosphere.platform.transport.status.ActionType;
import de.iip_ecosphere.platform.transport.status.ActionTypes;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.Timer;
import java.util.TimerTask;

public abstract class AbstractMonitoringReceiverTest {
    protected abstract Server createBroker(ServerAddress var1);

    protected void runScenario(MonitoringRecieverLifecycle mrl) {
        System.out.println("Starting broker");
        ServerAddress broker = new ServerAddress(Schema.IGNORE);
        Server qpid = this.createBroker(broker);
        qpid.start();
        TransportSetup transSetup = new TransportSetup();
        transSetup.setHost("localhost");
        transSetup.setPort(broker.getPort());
        transSetup.setUser("user");
        transSetup.setPassword("pwd");
        MonitoringSetup.getInstance().setTransport(transSetup);
        Transport.setTransportSetup(() -> transSetup);
        Monitor.setTransportSetup(() -> transSetup);
        System.out.println("Creating/starting receiver");
        mrl.start(transSetup);
        System.out.println("Onboarding device");
        Monitor.sendResourceStatus((ActionType)ActionTypes.ADDED, (String[])new String[0]);
        Monitor.startScheduling();
        System.out.println("Device onboarded");
        System.out.println("Starting service monitoring");
        final MetricsProvider mProvider = new MetricsProvider((MeterRegistry)new SimpleMeterRegistry());
        mProvider.setInjectedValues(transSetup);
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                mProvider.calculateMetrics();
            }
        }, 0L, 1000L);
        String serviceId = "aiService";
        Transport.sendServiceStatus((ActionType)ActionTypes.ADDED, (String)serviceId, (String[])new String[0]);
        mProvider.increaseCounter("service.aiService.sent");
        mProvider.increaseCounter("service.aiService.received");
        mProvider.increaseCounter("service.aiService.received");
        Transport.sendServiceStatus((ActionType)ActionTypes.REMOVED, (String)serviceId, (String[])new String[0]);
        System.out.println("Sleeping...");
        TimeUtils.sleep((int)this.getSleepTime());
        System.out.println("Device offboarding");
        Monitor.sendResourceStatus((ActionType)ActionTypes.REMOVED, (String[])new String[0]);
        System.out.println("Stopping");
        timer.cancel();
        mrl.stop();
        mProvider.destroy();
        Monitor.stopScheduling();
        Transport.releaseConnector();
        qpid.stop(true);
        Transport.setTransportSetup(null);
        Monitor.setTransportSetup(null);
    }

    protected int getSleepTime() {
        return 6000;
    }

    protected static interface MonitoringRecieverLifecycle {
        public void start(TransportSetup var1);

        public void stop();
    }
}

