/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.monitoring;

import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MeterType;
import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MetricsAasConstructionBundle;
import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MetricsAasConstructor;
import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MetricsExtractorRestClient;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;

public class AasServer {
    public static final int REGISTRY_PORT_NO = 4001;
    public static final String AAS_URN = "urn:::prototype.four.aas";
    public static final String AAS_NAME = "proto4aas";
    public static final String SM_URN = "urn:::prototype.four.submodel";
    public static final String SM_NAME = "proto4sm";
    public static final String PROP_NAME = "name";
    public static final String PROP_VERSION = "version";
    public static final String PROP_DESCRIPTION = "description";
    public static final String SUPPLIER_TIMER_ID = "suppliercustomtimer";
    public static final String SUPPLIER_GAUGE_ID = "suppliercustomgauge";
    public static final String SUPPLIER_COUNTER_ID = "suppliercustomcounter";
    public static final String CONSUMER_TIMER_ID = "consumercustomtimer";
    public static final String CONSUMER_GAUGE_ID = "consumercustomgauge";
    public static final String CONSUMER_COUNTER_ID = "consumercustomcounter";
    public static final String CONSUMER_RECV_ID = "consumerreceptiongauge";
    public static final String REST_GAUGE_ID = "restgauge";
    public static final String REST_COUNTER_ID = "restcounter";
    public static final String REST_TIMER_ID = "resttimer";
    private static final String SERVICE_HOST = "localhost";
    private static final int SERVICE_PORT = 8080;
    private static final String TIMEOUT_MSG = "Timeout! Shuttimg down the servers";

    public static void main(String[] args) throws Exception {
        ServerAddress aasServerAddress = new ServerAddress(Schema.HTTP, 4001);
        ServerAddress vabServerAddress = new ServerAddress(Schema.HTTP);
        Endpoint aasServerBase = new Endpoint(aasServerAddress, "");
        Endpoint registry = new Endpoint(aasServerAddress, "registry");
        System.out.println("Endpoints created");
        AasFactory factory = AasFactory.getInstance();
        Aas.AasBuilder aasBuilder = factory.createAasBuilder(AAS_NAME, AAS_URN);
        InvocablesCreator iCreator = factory.createInvocablesCreator("", vabServerAddress.getHost(), vabServerAddress.getPort());
        Submodel.SubmodelBuilder smBuilder = aasBuilder.createSubmodelBuilder(SM_NAME, SM_URN);
        ProtocolServerBuilder pBuilder = AasFactory.getInstance().createProtocolServerBuilder("", vabServerAddress.getPort());
        MetricsExtractorRestClient client = new MetricsExtractorRestClient(SERVICE_HOST, 8080);
        MetricsAasConstructionBundle bundle = new MetricsAasConstructionBundle((SubmodelElementContainerBuilder)smBuilder, pBuilder, iCreator, client);
        System.out.println("Bundle created");
        smBuilder.createPropertyBuilder(PROP_NAME).setType(Type.STRING).bind(iCreator.createGetter(PROP_NAME), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder(PROP_VERSION).setType(Type.STRING).bind(iCreator.createGetter(PROP_VERSION), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder(PROP_DESCRIPTION).setType(Type.STRING).bind(iCreator.createGetter(PROP_DESCRIPTION), InvocablesCreator.READ_ONLY).build();
        pBuilder.defineProperty(PROP_NAME, () -> "My service", null);
        pBuilder.defineProperty(PROP_VERSION, () -> "1.2.3", null);
        pBuilder.defineProperty(PROP_DESCRIPTION, () -> "Prototype 4 AAS", null);
        MetricsAasConstructor.addMetricsToBundle((MetricsAasConstructionBundle)bundle);
        MetricsAasConstructor.addCustomMetric((MetricsAasConstructionBundle)bundle, (String)SUPPLIER_TIMER_ID, (MeterType)MeterType.TIMER);
        MetricsAasConstructor.addCustomMetric((MetricsAasConstructionBundle)bundle, (String)SUPPLIER_GAUGE_ID, (MeterType)MeterType.GAUGE);
        MetricsAasConstructor.addCustomMetric((MetricsAasConstructionBundle)bundle, (String)SUPPLIER_COUNTER_ID, (MeterType)MeterType.COUNTER);
        MetricsAasConstructor.addCustomMetric((MetricsAasConstructionBundle)bundle, (String)CONSUMER_TIMER_ID, (MeterType)MeterType.TIMER);
        MetricsAasConstructor.addCustomMetric((MetricsAasConstructionBundle)bundle, (String)CONSUMER_GAUGE_ID, (MeterType)MeterType.GAUGE);
        MetricsAasConstructor.addCustomMetric((MetricsAasConstructionBundle)bundle, (String)CONSUMER_COUNTER_ID, (MeterType)MeterType.COUNTER);
        MetricsAasConstructor.addCustomMetric((MetricsAasConstructionBundle)bundle, (String)CONSUMER_RECV_ID, (MeterType)MeterType.GAUGE);
        MetricsAasConstructor.addCustomMetric((MetricsAasConstructionBundle)bundle, (String)REST_TIMER_ID, (MeterType)MeterType.TIMER);
        MetricsAasConstructor.addCustomMetric((MetricsAasConstructionBundle)bundle, (String)REST_GAUGE_ID, (MeterType)MeterType.GAUGE);
        MetricsAasConstructor.addCustomMetric((MetricsAasConstructionBundle)bundle, (String)REST_COUNTER_ID, (MeterType)MeterType.COUNTER);
        AasServer.illegalMetricsTests(bundle);
        System.out.println("Metrics added");
        smBuilder.build();
        Aas aas = (Aas)aasBuilder.build();
        Server aasServer = (Server)pBuilder.build();
        aasServer.start();
        System.out.println("AAS server started");
        de.iip_ecosphere.platform.support.aas.AasServer httpServer = factory.createDeploymentRecipe(aasServerBase).addInMemoryRegistry(registry.getEndpoint()).deploy(aas).createServer(new String[0]);
        httpServer.start();
        System.out.println("HTTP server started");
        System.out.println("Registry can be found on address: " + aasServerAddress.toServerUri() + registry.getEndpoint());
        Thread.sleep(120000L);
        System.out.println(TIMEOUT_MSG);
        httpServer.stop(true);
        aasServer.stop(true);
    }

    private static void illegalMetricsTests(MetricsAasConstructionBundle bundle) throws Exception {
        try {
            MetricsAasConstructor.addCustomMetric((MetricsAasConstructionBundle)bundle, null, (MeterType)MeterType.COUNTER);
            throw new Exception("No exception was thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                MetricsAasConstructor.addCustomMetric((MetricsAasConstructionBundle)bundle, (String)"", (MeterType)MeterType.COUNTER);
                throw new Exception("No exception was thrown");
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    MetricsAasConstructor.addCustomMetric((MetricsAasConstructionBundle)bundle, (String)"invalid", null);
                    throw new Exception("No exception was thrown");
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    try {
                        MetricsAasConstructor.addCustomMetric(null, (String)"invalid", (MeterType)MeterType.COUNTER);
                        throw new Exception("No exception was thrown");
                    }
                    catch (IllegalArgumentException illegalArgumentException4) {
                        try {
                            MetricsAasConstructor.addMetricsToBundle(null);
                            throw new Exception("No exception was thrown");
                        }
                        catch (IllegalArgumentException illegalArgumentException5) {
                            return;
                        }
                    }
                }
            }
        }
    }
}

