/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.monitoring;

import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.CounterRepresentation;
import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.GaugeRepresentation;
import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.TimerRepresentation;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.Submodel;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

public class AasJerseyClient {
    private Submodel sm;

    public static void main(String[] args) throws IOException, ExecutionException {
        AasJerseyClient client = new AasJerseyClient();
        client.initialize();
        System.out.println("Connection established successfully, retrieving data...");
        System.out.println();
        client.retrieveBaseProperties();
        client.testLists();
        client.testBasics();
        client.testRest();
        client.testConfiguration();
    }

    private void initialize() throws IOException {
        Endpoint registry = new Endpoint(new ServerAddress(Schema.HTTP, 4001), "registry");
        AasFactory factory = AasFactory.getInstance();
        Aas aas = factory.obtainRegistry(registry).retrieveAas("urn:::prototype.four.aas");
        this.sm = aas.getSubmodel("proto4sm");
    }

    private void retrieveBaseProperties() throws ExecutionException {
        System.out.println("Base properties:");
        System.out.println(this.sm.getProperty("name").getValue());
        System.out.println(this.sm.getProperty("version").getValue());
        System.out.println(this.sm.getProperty("description").getValue());
        System.out.println();
    }

    private void testLists() throws ExecutionException {
        int i;
        JsonArray gaugesList = AasJerseyClient.retrieveArray(this.sm.getProperty("gaugelist").getValue());
        JsonArray counterList = AasJerseyClient.retrieveArray(this.sm.getProperty("counterlist").getValue());
        JsonArray timerList = AasJerseyClient.retrieveArray(this.sm.getProperty("timerlist").getValue());
        JsonArray taggedList = AasJerseyClient.retrieveArray(this.sm.getProperty("taggedmeterlist").getValue());
        JsonArray simpleList = AasJerseyClient.retrieveArray(this.sm.getProperty("simplemeterlist").getValue());
        System.out.println("Meter lists:");
        System.out.println("\tGauges list:");
        for (i = 0; i < gaugesList.size(); ++i) {
            System.out.println("\t\t" + gaugesList.getString(i));
        }
        System.out.println("\tCounters list:");
        for (i = 0; i < counterList.size(); ++i) {
            System.out.println("\t\t" + counterList.getString(i));
        }
        System.out.println("\tTimer list:");
        for (i = 0; i < timerList.size(); ++i) {
            System.out.println("\t\t" + timerList.getString(i));
        }
        System.out.println("\tTagged meter list:");
        for (i = 0; i < taggedList.size(); ++i) {
            System.out.println("\t\t" + taggedList.getString(i));
        }
        System.out.println("\tSimple meter list:");
        for (i = 0; i < simpleList.size(); ++i) {
            System.out.println("\t\t" + simpleList.getString(i));
        }
        System.out.println();
    }

    private void testBasics() throws ExecutionException {
        JsonObject meter;
        String[] tags;
        ArrayList<Counter> counters = new ArrayList<Counter>();
        ArrayList<Object> objects = new ArrayList<JsonObject>();
        ArrayList<Object> arrays = new ArrayList<JsonArray>();
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("suppliercustomcounter").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("consumercustomcounter").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("jvmgcmemoryallocated").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("jvmgcmemorypromoted").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("jvmclassesunloaded").getValue()));
        arrays.add(AasJerseyClient.retrieveArray(this.sm.getProperty("logbackevents").getValue()));
        for (JsonObject jsonObject : objects) {
            counters.add(CounterRepresentation.parseCounter((JsonObject)jsonObject, (String[])new String[0]));
        }
        for (JsonArray jsonArray : arrays) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                tags = AasJerseyClient.retrieveTags(jsonArray.getJsonObject(i).getJsonArray("tags"));
                meter = jsonArray.getJsonObject(i).getJsonObject("meter");
                counters.add(CounterRepresentation.parseCounter((JsonObject)meter, (String[])tags));
            }
        }
        System.out.println("Counters:");
        for (Counter counter : counters) {
            System.out.println(counter.getId() + " >>> " + counter.count());
        }
        System.out.println();
        ArrayList<Gauge> gauges = new ArrayList<Gauge>();
        objects = new ArrayList();
        arrays = new ArrayList();
        this.retrieveGauges(objects, arrays);
        for (JsonObject jsonObject : objects) {
            gauges.add(GaugeRepresentation.parseGauge((JsonObject)jsonObject, (String[])new String[0]));
        }
        for (JsonArray jsonArray : arrays) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                tags = AasJerseyClient.retrieveTags(jsonArray.getJsonObject(i).getJsonArray("tags"));
                meter = jsonArray.getJsonObject(i).getJsonObject("meter");
                gauges.add(GaugeRepresentation.parseGauge((JsonObject)meter, (String[])tags));
            }
        }
        System.out.println("Gauges:");
        for (Gauge gauge : gauges) {
            System.out.println(gauge.getId() + " >>> " + gauge.value());
        }
        System.out.println();
        ArrayList<Timer> arrayList = new ArrayList<Timer>();
        objects = new ArrayList();
        arrays = new ArrayList();
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("suppliercustomtimer").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("consumercustomtimer").getValue()));
        arrays.add(AasJerseyClient.retrieveArray(this.sm.getProperty("jvmgcpause").getValue()));
        for (JsonObject jsonObject : objects) {
            arrayList.add(TimerRepresentation.parseTimer((JsonObject)jsonObject, (String[])new String[0]));
        }
        for (JsonArray jsonArray : arrays) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                tags = AasJerseyClient.retrieveTags(jsonArray.getJsonObject(i).getJsonArray("tags"));
                meter = jsonArray.getJsonObject(i).getJsonObject("meter");
                arrayList.add(TimerRepresentation.parseTimer((JsonObject)meter, (String[])tags));
            }
        }
        System.out.println("Timers:");
        for (Timer timer : arrayList) {
            System.out.println(timer.getId() + " >>> CNT > " + timer.count() + " || MAX > " + timer.max(timer.baseTimeUnit()) + " || TOT > " + timer.totalTime(timer.baseTimeUnit()));
        }
        System.out.println();
    }

    private void retrieveGauges(ArrayList<JsonObject> objects, ArrayList<JsonArray> arrays) throws ExecutionException {
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("suppliercustomgauge").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("consumercustomgauge").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("consumerreceptiongauge").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("jvmgclivedatasize").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("jvmgcmaxdatasize").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("jvmthreadsdaemon").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("jvmthreadslive").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("jvmthreadspeak").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("processcpuusage").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("processstarttime").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("processuptime").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("systemcpuusage").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("Storage_Free").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("Storage_Capacity").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("Storage_Usable").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("Allocated_Storage").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("Memory_Free").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("Memory_Capacity").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("Allocated_Memory").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("Memory_Used").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("systemcpucount").getValue()));
        objects.add(AasJerseyClient.retrieveObject(this.sm.getProperty("jvmclassesloaded").getValue()));
        arrays.add(AasJerseyClient.retrieveArray(this.sm.getProperty("jvmthreadsstates").getValue()));
        arrays.add(AasJerseyClient.retrieveArray(this.sm.getProperty("jvmmemorycommitted").getValue()));
        arrays.add(AasJerseyClient.retrieveArray(this.sm.getProperty("jvmmemorymax").getValue()));
        arrays.add(AasJerseyClient.retrieveArray(this.sm.getProperty("jvmmemoryused").getValue()));
        arrays.add(AasJerseyClient.retrieveArray(this.sm.getProperty("jvmbuffermemoryused").getValue()));
        arrays.add(AasJerseyClient.retrieveArray(this.sm.getProperty("jvmbuffertotalcapacity").getValue()));
        arrays.add(AasJerseyClient.retrieveArray(this.sm.getProperty("jvmbuffercount").getValue()));
    }

    private void testRest() throws ExecutionException {
        JsonObject gaugeObj = AasJerseyClient.retrieveObject(this.sm.getProperty("restgauge").getValue());
        JsonObject counterObj = AasJerseyClient.retrieveObject(this.sm.getProperty("restcounter").getValue());
        JsonObject timerObj = AasJerseyClient.retrieveObject(this.sm.getProperty("resttimer").getValue());
        Gauge gauge = GaugeRepresentation.parseGauge((JsonObject)gaugeObj, (String[])new String[0]);
        Counter counter = CounterRepresentation.parseCounter((JsonObject)counterObj, (String[])new String[0]);
        Timer timer = TimerRepresentation.parseTimer((JsonObject)timerObj, (String[])new String[0]);
        System.out.println("Initial state of REST sample objects:");
        AasJerseyClient.printRestSampleObjects(gauge, counter, timer);
        ((GaugeRepresentation)gauge).setValue(12.32);
        counter.increment(12.34);
        timer.record(1L, TimeUnit.SECONDS);
        timer.record(3L, TimeUnit.SECONDS);
        timer.record(2L, TimeUnit.SECONDS);
        String gUpdater = ((GaugeRepresentation)gauge).getUpdater().toString();
        String cUpdater = ((CounterRepresentation)counter).getUpdater().toString();
        String tUpdater = ((TimerRepresentation)timer).getUpdater().toString();
        JsonObjectBuilder job = Json.createObjectBuilder();
        job.add("name", "restgauge");
        job.add("value", "potato");
        String fakeUpdater = job.build().toString();
        try {
            this.sm.getOperation("updaterestgauge").invoke(new Object[]{fakeUpdater});
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        this.sm.getOperation("updaterestgauge").invoke(new Object[]{gUpdater});
        this.sm.getOperation("updaterestcounter").invoke(new Object[]{cUpdater});
        this.sm.getOperation("updateresttimer").invoke(new Object[]{tUpdater});
        gaugeObj = AasJerseyClient.retrieveObject(this.sm.getProperty("restgauge").getValue());
        counterObj = AasJerseyClient.retrieveObject(this.sm.getProperty("restcounter").getValue());
        timerObj = AasJerseyClient.retrieveObject(this.sm.getProperty("resttimer").getValue());
        gauge = GaugeRepresentation.parseGauge((JsonObject)gaugeObj, (String[])new String[0]);
        counter = CounterRepresentation.parseCounter((JsonObject)counterObj, (String[])new String[0]);
        timer = TimerRepresentation.parseTimer((JsonObject)timerObj, (String[])new String[0]);
        System.out.println("Updated state of REST sample objects:");
        AasJerseyClient.printRestSampleObjects(gauge, counter, timer);
        this.sm.getOperation("deleterestgauge").invoke(new Object[0]);
        this.sm.getOperation("deleterestcounter").invoke(new Object[0]);
        this.sm.getOperation("deleteresttimer").invoke(new Object[0]);
        System.out.println("Updated state of REST sample objects:");
        System.out.println(this.sm.getProperty("restgauge").getValue());
        System.out.println(this.sm.getProperty("restcounter").getValue());
        System.out.println(this.sm.getProperty("resttimer").getValue());
        System.out.println();
        try {
            this.sm.getOperation("updaterestgauge").invoke(new Object[]{fakeUpdater});
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        try {
            this.sm.getOperation("deleterestgauge").invoke(new Object[0]);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    private void testConfiguration() throws ExecutionException {
        JsonObject memoryObj = AasJerseyClient.retrieveObject(this.sm.getProperty("Memory_Capacity").getValue());
        JsonObject diskObj = AasJerseyClient.retrieveObject(this.sm.getProperty("Storage_Capacity").getValue());
        Gauge memory = GaugeRepresentation.parseGauge((JsonObject)memoryObj, (String[])new String[0]);
        Gauge disk = GaugeRepresentation.parseGauge((JsonObject)diskObj, (String[])new String[0]);
        System.out.println("Printing memory and disk base units before update");
        System.out.println("Memory Base Unit >>> " + memory.getId().getBaseUnit());
        System.out.println("Disk Base Unit >>> " + disk.getId().getBaseUnit());
        JsonObjectBuilder memoryJob = Json.createObjectBuilder().add("unit", "bytes");
        JsonObjectBuilder diskJob = Json.createObjectBuilder().add("unit", "kilobytes");
        this.sm.getOperation("setmemorybaseunit").invoke(new Object[]{memoryJob.build().toString()});
        this.sm.getOperation("setdiskbaseunit").invoke(new Object[]{diskJob.build().toString()});
        memoryObj = AasJerseyClient.retrieveObject(this.sm.getProperty("Memory_Capacity").getValue());
        diskObj = AasJerseyClient.retrieveObject(this.sm.getProperty("Storage_Capacity").getValue());
        memory = GaugeRepresentation.parseGauge((JsonObject)memoryObj, (String[])new String[0]);
        disk = GaugeRepresentation.parseGauge((JsonObject)diskObj, (String[])new String[0]);
        System.out.println("Printing memory and disk base units after update");
        System.out.println("Memory Base Unit >>> " + memory.getId().getBaseUnit());
        System.out.println("Disk Base Unit >>> " + disk.getId().getBaseUnit());
    }

    private static JsonObject retrieveObject(Object json) {
        return Json.createReader((Reader)new StringReader(String.valueOf(json))).readObject();
    }

    private static JsonArray retrieveArray(Object json) {
        return Json.createReader((Reader)new StringReader(String.valueOf(json))).readArray();
    }

    private static String[] retrieveTags(JsonArray tagsArr) {
        String[] tags = new String[tagsArr.size()];
        for (int i = 0; i < tagsArr.size(); ++i) {
            tags[i] = tagsArr.getString(i);
        }
        return tags;
    }

    private static void printRestSampleObjects(Gauge gauge, Counter counter, Timer timer) {
        System.out.println(gauge.getId() + " >>> " + gauge.value());
        System.out.println(counter.getId() + " >>> " + counter.count());
        System.out.println(timer.getId() + " >>> CNT > " + timer.count() + " || MAX > " + timer.max(timer.baseTimeUnit()) + " || TOT > " + timer.totalTime(timer.baseTimeUnit()));
    }
}

