/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.monitoring.prometheus;

import de.iip_ecosphere.platform.monitoring.prometheus.AlertManagerImporter;
import de.iip_ecosphere.platform.monitoring.prometheus.ConfigModifier;
import de.iip_ecosphere.platform.monitoring.prometheus.IipEcospherePrometheusExporter;
import de.iip_ecosphere.platform.monitoring.prometheus.PrometheusMonitoringSetup;
import de.iip_ecosphere.platform.services.environment.AbstractProcessService;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.JarUtils;
import de.iip_ecosphere.platform.support.LifecycleDescriptor;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.iip_aas.config.ServerAddressHolder;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.transport.Transport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Supplier;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.LoggerFactory;

public class PrometheusLifecycleDescriptor
implements LifecycleDescriptor {
    public static final String PROMETHEUS = "prometheus";
    public static final String PROMETHEUS_VERSION = "2.34.0";
    public static final String ALERTMGR = "alertmanager";
    public static final String ALERTMGR_VERSION = "0.24.0";
    public static final String PROMETHEUS_CONFIG_INITIAL = "prometheus.yml.init";
    public static final String PROMETHEUS_CONFIG = "prometheus.yml";
    public static final String ALERTMGR_CONFIG = "alertmanager.yml";
    public static final String RESOURCES = "src/main/resources";
    private static boolean debug = false;
    private Process prometheusProcess;
    private Process alertMgrProcess;
    private File prometheusWorkingDirectory;
    private IipEcospherePrometheusExporter exporter;
    private AlertManagerImporter alertImporter;
    private ModifierRunnable modifierRunnable = new ModifierRunnable();
    private Deque<ConfigModifier> modifierQueue = new ConcurrentLinkedDeque<ConfigModifier>();
    private Supplier<IipEcospherePrometheusExporter> exporterSupplier = () -> new IipEcospherePrometheusExporter();
    private Supplier<AlertManagerImporter> alertMgrSupplier = () -> new AlertManagerImporter();
    private Supplier<ConfigModifier> modifierSupplier = () -> new ConfigModifier(PrometheusLifecycleDescriptor.getDefaultScrapePoints(), c -> this.modifierQueue.addLast((ConfigModifier)c));

    private static List<ConfigModifier.ScrapeEndpoint> getDefaultScrapePoints() {
        ArrayList<ConfigModifier.ScrapeEndpoint> result = new ArrayList<ConfigModifier.ScrapeEndpoint>();
        PrometheusMonitoringSetup setup = PrometheusMonitoringSetup.getInstance();
        result.add(new ConfigModifier.ScrapeEndpoint(PROMETHEUS, new Endpoint(Schema.HTTP, "localhost", setup.getPrometheus().getExporter().getPort(), "/metrics")));
        return result;
    }

    public static void setDebugFlag(boolean flag) {
        debug = flag;
    }

    private void updateConfiguration(ConfigModifier modifier, boolean notify) {
        try {
            HttpPost httppost;
            CloseableHttpClient httpclient;
            HttpResponse response;
            int code;
            PrometheusMonitoringSetup.PrometheusSetup setup = PrometheusMonitoringSetup.getInstance().getPrometheus();
            File cfg = new File(this.prometheusWorkingDirectory, PROMETHEUS_CONFIG);
            Path initCfgPath = new File(this.prometheusWorkingDirectory, PROMETHEUS_CONFIG_INITIAL).toPath();
            Files.copy(initCfgPath, cfg.toPath(), StandardCopyOption.REPLACE_EXISTING);
            PrintWriter writer = new PrintWriter(new FileWriter(cfg, false));
            writer.println("global:");
            writer.println("  scrape_interval: " + setup.getScrapeInterval() + "ms");
            writer.println("  scrape_timeout: " + setup.getScrapeTimeoutSafe() + "ms");
            writer.println("  evaluation_interval: " + setup.getEvaluationInterval() + "ms");
            writer.println("");
            writer.println("scrape_configs:");
            for (ConfigModifier.ScrapeEndpoint e : modifier.scrapeEndpoints()) {
                Endpoint ep = e.getScrapePoint();
                writer.println("  - job_name: \"" + e.getName() + "\"");
                writer.println("    metrics_path: \"" + ep.getEndpoint() + "\"");
                writer.println("    scheme: \"" + ep.getSchema().name().toLowerCase() + "\"");
                writer.println("    static_configs:");
                writer.println("      - targets: [\"" + ep.getHost() + ":" + ep.getPort() + "\"]");
            }
            writer.println();
            ServerAddressHolder alertMgr = setup.getAlertMgr();
            if (alertMgr.getPort() > 0) {
                writer.println("# Alertmanager configuration");
                writer.println("alerting:");
                writer.println("  alertmanagers:");
                writer.println("    - api_version: v1");
                writer.println("      static_configs:");
                writer.println("        - targets:");
                writer.println("           - " + alertMgr.getHost() + ":" + alertMgr.getPort());
            }
            writer.println("rule_files:");
            writer.println("  # - \"first_rules.yml\"");
            writer.println("  # - \"second_rules.yml\"");
            writer.close();
            if (notify && (code = (response = (httpclient = HttpClients.createDefault()).execute((HttpUriRequest)(httppost = new HttpPost(setup.getServer().getServerAddress().toServerUri() + "/-/reload")))).getStatusLine().getStatusCode()) >= 400) {
                String phrase = response.getStatusLine().getReasonPhrase();
                LoggerFactory.getLogger(PrometheusLifecycleDescriptor.class).info("Cannot update configuration. HTTP response: {} {}", (Object)code, (Object)phrase);
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(PrometheusLifecycleDescriptor.class).info("Cannot update configuration: {}", (Object)e.getMessage());
        }
    }

    private static InputStream getResource(String name) throws IOException {
        InputStream in = ResourceLoader.getResourceAsStream((String)name, (ResourceResolver[])new ResourceResolver[0]);
        if (in == null) {
            in = new FileInputStream(new File(RESOURCES, name));
        }
        return in;
    }

    public void startup(String[] args) {
        PrometheusMonitoringSetup setup = PrometheusMonitoringSetup.getInstance();
        Transport.setTransportSetup(() -> setup.getTransport());
        if (!setup.getPrometheus().getExporter().isRunning()) {
            this.exporter = this.exporterSupplier.get();
            this.exporter.setModifierSupplier(this.modifierSupplier);
            this.exporter.start();
        }
        if (!setup.getPrometheus().getServer().isRunning()) {
            String zipName = AbstractProcessService.getExecutablePrefix((String)PROMETHEUS, (String)PROMETHEUS_VERSION) + ".zip";
            String exeName = AbstractProcessService.getExecutableName((String)PROMETHEUS, (String)PROMETHEUS_VERSION);
            String alertExeName = AbstractProcessService.getExecutableName((String)ALERTMGR, (String)ALERTMGR_VERSION);
            this.prometheusWorkingDirectory = FileUtils.createTmpFolder((String)"iip-prometheus");
            File prometheusFile = new File(this.prometheusWorkingDirectory, exeName);
            File alertMgrFile = new File(this.prometheusWorkingDirectory, alertExeName);
            try {
                InputStream in = PrometheusLifecycleDescriptor.getResource(PROMETHEUS_CONFIG);
                Path initCfgPath = new File(this.prometheusWorkingDirectory, PROMETHEUS_CONFIG_INITIAL).toPath();
                Files.copy(in, initCfgPath, StandardCopyOption.REPLACE_EXISTING);
                in.close();
                Files.copy(initCfgPath, new File(this.prometheusWorkingDirectory, PROMETHEUS_CONFIG).toPath(), StandardCopyOption.REPLACE_EXISTING);
                in = PrometheusLifecycleDescriptor.getResource(ALERTMGR_CONFIG);
                Path alertCfgPath = new File(this.prometheusWorkingDirectory, ALERTMGR_CONFIG).toPath();
                Files.copy(in, alertCfgPath, StandardCopyOption.REPLACE_EXISTING);
                in.close();
                this.updateConfiguration(new ConfigModifier(PrometheusLifecycleDescriptor.getDefaultScrapePoints(), null), false);
                in = PrometheusLifecycleDescriptor.getResource(zipName);
                JarUtils.extractZip((InputStream)in, (Path)this.prometheusWorkingDirectory.toPath());
                in.close();
                prometheusFile.setExecutable(true);
                in = PrometheusLifecycleDescriptor.getResource(alertExeName);
                Path alertMgrPath = new File(this.prometheusWorkingDirectory, alertExeName).toPath();
                Files.copy(in, alertMgrPath, StandardCopyOption.REPLACE_EXISTING);
                in.close();
                alertMgrFile.setExecutable(true);
                ArrayList<String> pArgs = new ArrayList<String>();
                pArgs.add(alertMgrFile.getAbsolutePath());
                pArgs.add("--config.file=alertmanager.yml");
                pArgs.add("--web.listen-address=:" + setup.getPrometheus().getAlertMgr().getPort());
                if (debug) {
                    pArgs.add("--log.level=debug");
                }
                ProcessBuilder procBuilder = new ProcessBuilder(pArgs);
                procBuilder.directory(this.prometheusWorkingDirectory);
                procBuilder.inheritIO();
                this.alertMgrProcess = procBuilder.start();
                LoggerFactory.getLogger(this.getClass()).info("{} {} started on port {}", new Object[]{ALERTMGR, ALERTMGR_VERSION, setup.getPrometheus().getAlertMgr().getPort()});
                pArgs = new ArrayList();
                pArgs.add(prometheusFile.getAbsolutePath());
                pArgs.add("--config.file=prometheus.yml");
                pArgs.add("--web.enable-lifecycle");
                pArgs.add("--web.listen-address=:" + setup.getPrometheus().getServer().getPort());
                if (debug) {
                    pArgs.add("--log.level=debug");
                }
                procBuilder = new ProcessBuilder(pArgs);
                procBuilder.directory(this.prometheusWorkingDirectory);
                procBuilder.inheritIO();
                this.prometheusProcess = procBuilder.start();
                LoggerFactory.getLogger(this.getClass()).info("{} {} started on port {}", new Object[]{PROMETHEUS, PROMETHEUS_VERSION, setup.getPrometheus().getServer().getPort()});
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Starting Prometheus: {}", (Object)e.getMessage());
            }
        }
        new Thread(this.modifierRunnable).start();
        if (!setup.getPrometheus().getAlertMgr().isRunning()) {
            this.alertImporter = this.alertMgrSupplier.get();
            this.alertImporter.start();
        }
    }

    public void setExporterSupplier(Supplier<IipEcospherePrometheusExporter> supplier) {
        if (null != supplier) {
            this.exporterSupplier = supplier;
        }
    }

    public void deleteWorkingFiles() {
        if (this.prometheusWorkingDirectory != null) {
            String exeName = AbstractProcessService.getExecutableName((String)PROMETHEUS, (String)PROMETHEUS_VERSION);
            new File(this.prometheusWorkingDirectory.getAbsolutePath(), exeName).delete();
            String alertMgrName = AbstractProcessService.getExecutableName((String)PROMETHEUS, (String)ALERTMGR);
            new File(this.prometheusWorkingDirectory.getAbsolutePath(), alertMgrName).delete();
            new File(this.prometheusWorkingDirectory.getAbsolutePath(), PROMETHEUS_CONFIG).delete();
            new File(this.prometheusWorkingDirectory.getAbsolutePath(), ALERTMGR_CONFIG).delete();
        }
    }

    public IipEcospherePrometheusExporter getExporter() {
        return this.exporter;
    }

    public void shutdown() {
        if (null != this.alertImporter) {
            this.alertImporter.stop();
        }
        if (null != this.exporter) {
            this.exporter.stop();
        }
        this.modifierRunnable.stop();
        if (null != this.prometheusProcess) {
            this.prometheusProcess.destroyForcibly();
            LoggerFactory.getLogger(this.getClass()).info("{} {} shutdown", (Object)PROMETHEUS, (Object)PROMETHEUS_VERSION);
            this.prometheusProcess = null;
        }
        if (null != this.alertMgrProcess) {
            this.alertMgrProcess.destroyForcibly();
            LoggerFactory.getLogger(this.getClass()).info("{} {} shutdown", (Object)ALERTMGR, (Object)ALERTMGR_VERSION);
            this.alertMgrProcess = null;
        }
        Transport.releaseConnector();
        this.deleteWorkingFiles();
    }

    public Thread getShutdownHook() {
        return new Thread(() -> this.shutdown());
    }

    public int priority() {
        return 1;
    }

    private class ModifierRunnable
    implements Runnable {
        private boolean isRunning = true;

        private ModifierRunnable() {
        }

        @Override
        public void run() {
            while (this.isRunning) {
                ConfigModifier modifier = PrometheusLifecycleDescriptor.this.modifierQueue.poll();
                if (null != modifier) {
                    PrometheusLifecycleDescriptor.this.updateConfiguration(modifier, true);
                }
                TimeUtils.sleep((int)200);
            }
        }

        public void stop() {
            this.isRunning = false;
        }
    }
}

