/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.monitoring.prometheus;

import de.iip_ecosphere.platform.monitoring.MonitoringReceiver;
import de.iip_ecosphere.platform.monitoring.prometheus.ConfigModifier;
import de.iip_ecosphere.platform.monitoring.prometheus.PrometheusMonitoringSetup;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.Gauge;
import io.prometheus.client.exporter.common.TextFormat;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Wrapper;
import org.apache.catalina.startup.Tomcat;
import org.slf4j.LoggerFactory;
import si.matjazcerkvenik.alertmonitor.data.DAO;
import si.matjazcerkvenik.alertmonitor.model.DEvent;
import si.matjazcerkvenik.alertmonitor.util.AmMetrics;

public class IipEcospherePrometheusExporter
extends MonitoringReceiver {
    public static final String DEFAULT_METRICS_SERVLET_NAME = "metrics";
    public static final String DEFAULT_METRICS_ENDPOINT = "/metrics";
    private static final MeterFilter[] METER_FILTERS = MetricsProvider.append((MeterFilter[])MetricsProvider.DEFAULT_METER_FILTERS, (MeterFilter[])new MeterFilter[]{MeterFilter.denyNameStartsWith((String)"alertmonitor.")});
    private Tomcat server;
    private Context context;
    private Supplier<ConfigModifier> modifier;
    private int port;
    private File webapps;

    public void setModifierSupplier(Supplier<ConfigModifier> modifier) {
        this.modifier = modifier;
    }

    public void start() {
        super.start();
        try {
            PrometheusMonitoringSetup setup = PrometheusMonitoringSetup.getInstance();
            this.port = setup.getPrometheus().getExporter().getPort();
            if (this.port < 0) {
                this.port = NetUtils.getEphemeralPort();
                setup.getPrometheus().getExporter().setPort(this.port);
            }
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Starting prometheus export endpoint on port {}", (Object)this.port);
            Thread serverThread = new Thread(() -> {
                try {
                    this.server = new Tomcat();
                    File home = this.server.getEngine().getCatalinaHome();
                    this.server.setBaseDir(home.getName());
                    this.server.setPort(this.port);
                    this.server.setHostname("localhost");
                    this.server.getHost().setAppBase(".");
                    this.webapps = new File(home, "webapps");
                    this.webapps.mkdirs();
                    String contextPath = "";
                    String docBase = new File(".").getAbsolutePath();
                    this.context = this.server.addContext(contextPath, docBase);
                    DefaultExports.initialize();
                    this.addServlet(DEFAULT_METRICS_SERVLET_NAME, (Servlet)new PrometheusMetricsServlet());
                    this.server.getConnector();
                    this.server.start();
                    this.server.getServer().await();
                }
                catch (LifecycleException e) {
                    e.printStackTrace();
                }
            });
            serverThread.start();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Starting prometheus export endpoint: {}", (Object)e.getMessage());
        }
    }

    public void stop() {
        if (null != this.server) {
            try {
                this.server.stop();
                this.server = null;
            }
            catch (Exception e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Shutting down prometheus export endpoint: {}", (Object)e.getMessage());
            }
        }
        super.stop();
    }

    protected String addServlet(String id, Servlet servlet) {
        String path = this.getPath(id);
        Wrapper newWrapper = this.context.createWrapper();
        newWrapper.setName(id);
        newWrapper.setLoadOnStartup(1);
        newWrapper.setServlet(servlet);
        this.context.addChild((Container)newWrapper);
        this.context.addServletMappingDecoded(path + "/*", id);
        return path;
    }

    private String getPath(String id) {
        return "/" + id;
    }

    protected void removeServlet(String id) {
        Container container = this.context.findChild(id);
        if (null != container) {
            this.context.removeServletMapping(this.getPath(id));
            this.context.removeChild(container);
        }
    }

    protected MonitoringReceiver.Exporter createExporter(String id) {
        return new PrometheusExporter(id);
    }

    protected void notifyExporterAdded(MonitoringReceiver.Exporter exporter) {
        this.writeScrapeConfig();
    }

    protected void notifyExporterRemoved(MonitoringReceiver.Exporter exporter) {
        this.writeScrapeConfig();
    }

    private void writeScrapeConfig() {
        if (null != this.modifier) {
            ConfigModifier m = this.modifier.get();
            for (MonitoringReceiver.Exporter e : this.exporters()) {
                m.addScrapeEndpoint(((PrometheusExporter)e).getScrapeEntry());
            }
            m.end();
        }
    }

    protected class PrometheusExporter
    extends MonitoringReceiver.Exporter {
        private MyPrometheusMeterRegistry registry;
        private ConfigModifier.ScrapeEndpoint entry;
        private RegistryServlet servlet;

        protected PrometheusExporter(String id) {
            super((MonitoringReceiver)IipEcospherePrometheusExporter.this, id);
            this.registry = new MyPrometheusMeterRegistry();
            this.servlet = new RegistryServlet(this.registry);
        }

        protected void initialize() {
            String id = this.getId();
            String path = IipEcospherePrometheusExporter.this.addServlet(id, (Servlet)this.servlet);
            this.entry = new ConfigModifier.ScrapeEndpoint(id, new Endpoint(Schema.HTTP, IipEcospherePrometheusExporter.this.port, path));
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Added device context {}", (Object)path);
        }

        protected ConfigModifier.ScrapeEndpoint getScrapeEntry() {
            return this.entry;
        }

        protected void addMeter(Meter meter) {
            if (null != meter) {
                try {
                    this.registry.remove(meter.getId());
                    this.registry.createMeter(meter.getId(), meter.getId().getType(), meter.measure());
                }
                catch (Throwable t) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Cannot add meter ({}, {}, {}): {}", new Object[]{meter.getId(), meter.getId().getType(), meter.measure(), t.getMessage()});
                }
            }
        }

        protected void dispose() {
            IipEcospherePrometheusExporter.this.removeServlet(this.getId());
            this.servlet.destroy();
            super.dispose();
        }
    }

    public static class RegistryServlet
    extends HttpServlet {
        private static final long serialVersionUID = -3178584303722836948L;
        private PrometheusMeterRegistry registry;

        private RegistryServlet(PrometheusMeterRegistry registry) {
            this.registry = registry;
        }

        public static Set<String> parseNames(HttpServletRequest req) {
            String[] includedParam = req.getParameterValues("name[]");
            if (includedParam == null) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(includedParam));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.setContentType("text/plain; version=0.0.4; charset=utf-8");
            try (BufferedWriter writer = new BufferedWriter(resp.getWriter());){
                writer.append(this.registry.scrape("text/plain; version=0.0.4; charset=utf-8", RegistryServlet.parseNames(req)));
                ((Writer)writer).flush();
            }
            resp.setStatus(200);
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.doGet(req, resp);
        }
    }

    private static class MyPrometheusMeterRegistry
    extends PrometheusMeterRegistry {
        MyPrometheusMeterRegistry() {
            super(PrometheusConfig.DEFAULT);
            MetricsProvider.apply((MeterRegistry)this, (MeterFilter[])MetricsProvider.DEFAULT_METER_FILTERS);
        }

        protected Meter createMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
            return this.newMeter(id, type, measurements);
        }
    }

    private static class PrometheusMetricsServlet
    extends HttpServlet {
        private static final long serialVersionUID = 7153742267407172657L;

        private PrometheusMetricsServlet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            AmMetrics.alertmonitor_active_alerts_count.clear();
            for (DEvent n : DAO.getInstance().getActiveAlerts().values()) {
                ((Gauge.Child)AmMetrics.alertmonitor_active_alerts_count.labels(new String[]{n.getAlertname(), n.getSeverity()})).inc();
            }
            AmMetrics.alertmonitor_alerts_balance_factor.set(DAO.getInstance().calculateAlertsBalanceFactor());
            AmMetrics.alertmonitor_last_event_timestamp.set((double)AmMetrics.lastEventTimestamp);
            resp.setStatus(200);
            resp.setContentType("text/plain; version=0.0.4; charset=utf-8");
            try (PrintWriter writer = resp.getWriter();){
                Set<String> included = this.parse(req);
                TextFormat.write004((Writer)writer, (Enumeration)AmMetrics.registry.filteredMetricFamilySamples(id -> included.contains(id) || MetricsProvider.include((String)id.replaceAll("_", "."), (MeterFilter[])METER_FILTERS)));
                ((Writer)writer).flush();
            }
        }

        private Set<String> parse(HttpServletRequest req) {
            String[] includedParam = req.getParameterValues("name[]");
            if (includedParam == null) {
                return Collections.emptySet();
            }
            return new HashSet<String>(Arrays.asList(includedParam));
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            this.doGet(req, resp);
        }
    }
}

