/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.kiServices.rapidminer.rtsa;

import de.iip_ecosphere.platform.kiServices.rapidminer.rtsa.RtsaRestService;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlProcess;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.iip_aas.Version;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;
import test.de.iip_ecosphere.platform.kiServices.rapidminer.rtsa.InData;
import test.de.iip_ecosphere.platform.kiServices.rapidminer.rtsa.InDataJsonTypeTranslator;
import test.de.iip_ecosphere.platform.kiServices.rapidminer.rtsa.OutData;
import test.de.iip_ecosphere.platform.kiServices.rapidminer.rtsa.OutDataJsonTypeTranslator;

public class RtsaRestServiceTest {
    private static void process(RtsaRestService<InData, OutData> service, InData data) throws IOException {
        LoggerFactory.getLogger(RtsaRestServiceTest.class).info("Input: {id=" + data.getId() + " value1=" + data.getValue1() + " value2 = " + data.getValue2() + "}");
        service.process((Object)data);
    }

    private boolean forceFake() {
        return false;
    }

    @Test(timeout=60000L)
    public void testRtsaRestService() throws IOException, ExecutionException {
        final AtomicInteger receivedCount = new AtomicInteger(0);
        ReceptionCallback<OutData> rcp = new ReceptionCallback<OutData>(){

            public void received(OutData data) {
                receivedCount.incrementAndGet();
                LoggerFactory.getLogger(RtsaRestServiceTest.class).info("Received result: id=" + data.getId() + " value1=" + data.getValue1() + " value2=" + data.getValue2() + " confidence = " + data.getConfidence() + " prediction=" + data.isPrediction());
            }

            public Class<OutData> getType() {
                return OutData.class;
            }
        };
        YamlService sDesc = new YamlService();
        sDesc.setName("RtsaRestTest");
        sDesc.setVersion(new Version("0.14.5"));
        sDesc.setKind(ServiceKind.TRANSFORMATION_SERVICE);
        sDesc.setId("RtsaRestTest");
        sDesc.setDeployable(true);
        YamlProcess pDesc = new YamlProcess();
        sDesc.setProcess(pDesc);
        File rtsa = new File("src/main/resources/rtsa");
        RtsaRestService service = rtsa.exists() && !this.forceFake() ? new RtsaRestService((TypeTranslator)new InDataJsonTypeTranslator(), (TypeTranslator)new OutDataJsonTypeTranslator(), (ReceptionCallback)rcp, sDesc) : new FakeRtsaRestService(new InDataJsonTypeTranslator(), new OutDataJsonTypeTranslator(), rcp, sDesc);
        service.setState(ServiceState.STARTING);
        while (service.getState() != ServiceState.RUNNING) {
            TimeUtils.sleep((int)500);
        }
        RtsaRestServiceTest.process((RtsaRestService<InData, OutData>)service, new InData(1, 1.3, 3.0));
        RtsaRestServiceTest.process((RtsaRestService<InData, OutData>)service, new InData(1, 1.5, 2.0));
        RtsaRestServiceTest.process((RtsaRestService<InData, OutData>)service, new InData(1, 1.7, 4.0));
        for (int count = 0; receivedCount.get() == 0 && count < 20; ++count) {
            TimeUtils.sleep((int)200);
        }
        TimeUtils.sleep((int)500);
        LoggerFactory.getLogger(RtsaRestServiceTest.class).info("Stopping service");
        service.setState(ServiceState.STOPPING);
        while (service.getState() != ServiceState.STOPPED) {
            TimeUtils.sleep((int)500);
        }
        TimeUtils.sleep((int)500);
        Assert.assertTrue((receivedCount.get() >= 1 ? 1 : 0) != 0);
    }

    private static class FakeRtsaRestService<I, O>
    extends RtsaRestService<I, O> {
        public FakeRtsaRestService(TypeTranslator<I, String> inTrans, TypeTranslator<String, O> outTrans, ReceptionCallback<O> callback, YamlService yaml) {
            super(inTrans, outTrans, callback, yaml);
        }

        protected String getMainClass(File rtsaPath) {
            return "test.de.iip_ecosphere.platform.kiServices.rapidminer.rtsa.FakeRtsa";
        }

        protected String getClasspath(File rtsaPath) {
            String result = de.iip_ecosphere.platform.support.FileUtils.getResolvedPath((File)new File("."), (String)"target/test-classes");
            File f = new File("target/test-classes/classpath");
            if (f.exists()) {
                try {
                    String tmp = FileUtils.readFileToString((File)f, (String)"UTF-8");
                    result = result + File.pathSeparator + tmp;
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Cannot read test classpath file");
                }
            } else {
                f = new File("target/fake/rtsa/lib");
                File[] jars = f.listFiles();
                if (f.exists() && null != jars) {
                    for (File j : jars) {
                        result = result + File.pathSeparator + j.getAbsolutePath();
                    }
                } else {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Cannot complete test classpath");
                }
            }
            return result;
        }

        protected String getBaseDir(File rtsaPath) {
            return de.iip_ecosphere.platform.support.FileUtils.getResolvedPath((File)new File("."), (String)"target/fake");
        }
    }
}

