/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.kiServices.rapidminer.rtsa;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.support.JarUtils;
import de.iip_ecosphere.platform.support.iip_aas.config.AbstractSetup;
import de.iip_ecosphere.platform.support.iip_aas.config.CmdLine;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spark.Route;
import spark.Spark;

public class FakeRtsa {
    private static Random random = new Random();
    private static Map<String, FunctionMapping> functions = new HashMap<String, FunctionMapping>();

    public static void main(String[] args) throws IOException {
        long start = System.currentTimeMillis();
        int serverPort = Integer.parseInt(System.getProperty("server.port", "8090"));
        String defaultPath = CmdLine.getArg((String[])args, (String)"iip.rtsa.path", (String)"iip_basic/score_v1");
        boolean verbose = CmdLine.getBooleanArg((String[])args, (String)"verbose", (boolean)true);
        boolean waitAtStart = CmdLine.getBooleanArg((String[])args, (String)"waitAtStart", (boolean)true);
        File baseDir = new File(System.getProperty("scoring-agent.baseDir", "."));
        System.out.println("This is FakeRtsa on port: " + serverPort + " with basedir " + baseDir);
        FakeRtsa.extractDeployments(baseDir);
        List<Deployment> deployments = FakeRtsa.loadDeployments(baseDir, defaultPath);
        for (Deployment d : deployments) {
            Route route = (req, res) -> {
                String request = FakeRtsa.lines(req.body()).collect(Collectors.joining("\n"));
                if (verbose) {
                    System.out.println("FakeRtsa Received Request: " + request);
                }
                String respText = FakeRtsa.createResponse(request, d);
                res.body(respText);
                res.status(200);
                return res.body();
            };
            Spark.port((int)serverPort);
            String path = d.getPath();
            Spark.post((String)("/services/" + path), (Route)route);
            Spark.get((String)("/services/" + path), (Route)route);
            Spark.put((String)("/services/" + path), (Route)route);
            Spark.delete((String)("/services/" + path), (Route)route);
        }
        Spark.awaitInitialization();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.out.println("Stopping FakeRtsa");
            Spark.stop();
            Spark.awaitStop();
            System.out.println("Stopped FakeRtsa");
        }));
        new Thread(() -> {
            long end = System.currentTimeMillis();
            if (waitAtStart) {
                long diff = end - start;
                if (diff < 2500L) {
                    try {
                        Thread.sleep(2500L - diff);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                end = System.currentTimeMillis();
            }
            System.out.println("Started Application in " + (end - start) + " ms");
        }).start();
    }

    private static void extractDeployments(File baseDir) {
        File dep = new File(baseDir, "deployments");
        System.out.println("Extracting deployments from " + dep.getAbsolutePath());
        Path baseDirPath = baseDir.toPath();
        File[] deps = dep.listFiles();
        if (null != deps) {
            for (File d : deps) {
                if (!d.getName().endsWith(".zip")) continue;
                try {
                    FileInputStream fis = new FileInputStream(d);
                    JarUtils.extractZip((InputStream)fis, (Path)baseDirPath);
                    fis.close();
                    System.out.println(" - unzipped: " + d.getName());
                }
                catch (IOException e) {
                    System.out.println(" - Cannot unzip deployment " + d.getName() + ": " + e.getMessage());
                }
            }
        }
    }

    private static List<Deployment> loadDeployments(File baseDir, String defaultPath) {
        System.out.println("Loading deployments:");
        File dep = new File(baseDir, "home/deployments");
        ArrayList<Deployment> result = new ArrayList<Deployment>();
        File[] deps = dep.listFiles();
        if (null != deps) {
            for (File d : deps) {
                if (d.getName().endsWith(".jar")) {
                    try {
                        result.add(new Deployment(d, defaultPath));
                        System.out.println(" - added: " + d.getName());
                    }
                    catch (IOException e) {
                        System.out.println(" - cannot add " + d.getName() + ": " + e.getMessage());
                    }
                    continue;
                }
                System.out.println(" - cannot add " + d.getName() + " as no JAR");
            }
        }
        return result;
    }

    public static Stream<String> lines(String string) {
        return Stream.of(string.replace("\r\n", "\n").split("\n"));
    }

    private static String createResponse(String request, Deployment deployment) {
        String result;
        try {
            ObjectMapper mapper = new ObjectMapper();
            Input input = (Input)mapper.readValue(request, Input.class);
            if (input.data != null) {
                for (Map values : input.data) {
                    Object newValue;
                    FunctionMapping fm;
                    HashSet done = new HashSet();
                    HashSet toRemove = new HashSet();
                    for (Map.Entry entry : values.entrySet()) {
                        done.add(entry.getKey());
                        fm = deployment.getMapping((String)entry.getKey());
                        if (null == fm) continue;
                        newValue = fm.map(entry.getValue());
                        if (null != newValue) {
                            entry.setValue(newValue);
                            continue;
                        }
                        toRemove.add(entry.getKey());
                    }
                    for (String string : deployment.getMappings().keySet()) {
                        if (done.contains(string) || null == (fm = deployment.getMapping(string)) || null == (newValue = fm.map(null))) continue;
                        values.put(string, newValue);
                    }
                    for (String string : toRemove) {
                        values.remove(string);
                    }
                }
            }
            result = mapper.writeValueAsString((Object)input);
        }
        catch (JsonProcessingException e) {
            System.out.println("Cannot read input: " + request + ": " + e.getMessage());
            result = request;
        }
        return result;
    }

    static {
        functions.put("PASS", p -> p);
        functions.put("SKIP", p -> null);
        functions.put("RANDOM_PROBABILITY", p -> random.nextDouble());
        functions.put("RANDOM_BOOLEAN", p -> random.nextBoolean());
        functions.put("RANDOM_SELECT", new RandomArgumentSelector());
    }

    public static class Input {
        private Map<String, Object>[] data;

        public void setData(Map<String, Object>[] data) {
            this.data = data;
        }

        public Map<String, Object>[] getData() {
            return this.data;
        }
    }

    public static final class Spec {
        private String path = "";
        private Map<String, String> mappings = new HashMap<String, String>();

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Map<String, String> getMappings() {
            return this.mappings;
        }

        public void setMappings(Map<String, String> mappings) {
            this.mappings = mappings;
        }
    }

    public static enum FunctionMapping1 {
        RANDOM_PROBABILITY,
        RANDOM_BOOLEAN,
        SKIP,
        PASS;

    }

    public static class RandomArgumentSelector
    implements FunctionMapping {
        private String[] args;

        public RandomArgumentSelector() {
        }

        private RandomArgumentSelector(String[] args) {
            this.args = args;
        }

        @Override
        public Object map(Object value) {
            Object result = null == this.args ? value : this.args[random.nextInt(this.args.length)];
            return result;
        }

        @Override
        public FunctionMapping bind(String[] args) {
            return new RandomArgumentSelector(args);
        }
    }

    public static interface FunctionMapping {
        public Object map(Object var1);

        default public FunctionMapping bind(String[] args) {
            return this;
        }
    }

    private static class Deployment {
        private File file;
        private URLClassLoader loader;
        private String path;
        private Spec spec;

        private Deployment(File file, String defaultPath) throws IOException {
            this.file = file;
            this.loader = new URLClassLoader(new URL[]{file.toURI().toURL()});
            this.path = defaultPath;
            this.readSpec(this.loader.getResourceAsStream("spec.yml"));
        }

        private void readSpec(InputStream in) throws IOException {
            if (null == in) {
                System.out.println("No spec in deployment " + this.file.getName() + ". Assuming defaults.");
            } else {
                this.spec = (Spec)AbstractSetup.readFromYaml(Spec.class, (InputStream)in);
                if (null != this.path && this.path.length() > 0) {
                    this.path = this.spec.getPath();
                }
            }
        }

        public String getPath() {
            return this.path;
        }

        public FunctionMapping getMapping(String field) {
            String funcSpec;
            FunctionMapping result = (FunctionMapping)functions.get("PASS");
            if (null != this.spec && null != (funcSpec = this.spec.getMappings().get(field))) {
                FunctionMapping fm;
                String[] args = null;
                String funcName = funcSpec;
                int argsStartPos = funcSpec.indexOf(40);
                int argsEndPos = funcSpec.lastIndexOf(41);
                if (argsStartPos > 1 && argsEndPos > 0) {
                    funcName = funcSpec.substring(0, argsStartPos);
                    String argsTmp = "";
                    if (argsStartPos + 1 < argsEndPos) {
                        argsTmp = funcSpec.substring(argsStartPos + 1, argsEndPos);
                    }
                    args = argsTmp.split(",");
                }
                if (null != (fm = (FunctionMapping)functions.get(funcName))) {
                    result = fm.bind(args);
                }
            }
            return result;
        }

        public Map<String, String> getMappings() {
            return null == this.spec ? new HashMap() : this.spec.getMappings();
        }
    }
}

