/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.kiServices.rapidminer.rtsa;

import de.iip_ecosphere.platform.services.environment.AbstractRestProcessService;
import de.iip_ecosphere.platform.services.environment.InstalledDependenciesSetup;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlProcess;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.iip_aas.config.CmdLine;
import de.iip_ecosphere.platform.support.net.NetworkManagerFactory;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import org.slf4j.LoggerFactory;

public class RtsaRestService<I, O>
extends AbstractRestProcessService<I, O> {
    public static final String VERSION = "0.14.5";
    private File home;
    private Process proc;
    private String instancePath = "iip_basic/score_v1";
    private int instancePort = 8090;
    private String networkPortKey;

    public RtsaRestService(TypeTranslator<I, String> inTrans, TypeTranslator<String, O> outTrans, ReceptionCallback<O> callback, YamlService yaml) {
        super(inTrans, outTrans, callback, yaml);
    }

    protected ServiceState start() throws ExecutionException {
        YamlProcess sSpec = this.getProcessSpec();
        File rtsaPath = (File)RtsaRestService.selectNotNull((Object)sSpec, s -> s.getExecutablePath(), (Object)new File("./src/main/resources/rtsa"));
        String javaKey = this.isFakeRtsa(rtsaPath) ? InstalledDependenciesSetup.getJavaKey() : "JAVA8";
        File exe = InstalledDependenciesSetup.location((String)javaKey);
        this.home = (File)RtsaRestService.selectNotNull((Object)sSpec, s -> s.getHomePath(), (Object)new File("./src/test/resources"));
        this.home = FileUtils.getResolvedFile((File)this.home);
        ArrayList<String> args = new ArrayList<String>();
        this.networkPortKey = "rtsa_" + this.getServiceSpec().getId();
        this.instancePort = NetworkManagerFactory.getInstance().obtainPort(this.networkPortKey).getPort();
        args.add("-Dspring.config.location=" + this.getConfigLocation(rtsaPath));
        args.add("-Dscoring-agent.baseDir=" + this.getBaseDir(rtsaPath));
        args.add("-Dserver.port=" + this.instancePort);
        args.add("-Dspring.pid.file=" + this.getPidFile(rtsaPath));
        args.add("-Dlog4j2.formatMsgNoLookups=true");
        args.add("-classpath");
        args.add(this.getClasspath(rtsaPath));
        args.add(this.getMainClass(rtsaPath));
        this.addProcessSpecCmdArg(args);
        this.parseArgs(args.toArray(new String[0]));
        this.proc = this.createAndConfigureProcess(exe, false, this.home, args);
        this.setupConnectionManager();
        return null;
    }

    protected ServiceState stop() {
        if (null != this.networkPortKey) {
            NetworkManagerFactory.getInstance().releasePort(this.networkPortKey);
            this.networkPortKey = null;
        }
        return super.stop();
    }

    private void parseArgs(String[] args) {
        this.instancePath = CmdLine.getArg((String[])args, (String)"iip.rtsa.path", (String)this.instancePath);
    }

    protected String getClasspath(File rtsaPath) {
        return FileUtils.getResolvedPath((File)rtsaPath, (String)"lib") + File.separator + "*";
    }

    protected String getConfigLocation(File rtsaPath) {
        return FileUtils.getResolvedPath((File)rtsaPath, (String)"/home/config/agent.properties");
    }

    protected String getPidFile(File rtsaPath) {
        return FileUtils.getResolvedPath((File)rtsaPath, (String)"/home/pid");
    }

    protected String getBaseDir(File rtsaPath) {
        return FileUtils.getResolvedPath((File)rtsaPath, (String)"");
    }

    protected boolean isFakeRtsa(File rtsaPath) {
        File libsFake = new File(rtsaPath, "lib/fakeRtsa.jar");
        return libsFake.exists();
    }

    protected String getMainClass(File rtsaPath) {
        String result = this.isFakeRtsa(rtsaPath) ? "test.de.iip_ecosphere.platform.kiServices.rapidminer.rtsa.FakeRtsa" : "com.rapidminer.execution.scoring.Application";
        return result;
    }

    protected String getApiPath() {
        return "http://localhost:" + this.instancePort + "/services/" + this.instancePath;
    }

    protected String getBearerToken() {
        return null;
    }

    protected void handleInputStream(final InputStream in) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (RtsaRestService.this.getState() == ServiceState.STARTING || null != RtsaRestService.this.proc && RtsaRestService.this.proc.isAlive()) {
                    Scanner sc = new Scanner(in);
                    while (sc.hasNextLine()) {
                        String line = sc.nextLine();
                        LoggerFactory.getLogger(this.getClass()).info(line);
                        if (!line.contains("Started Application in")) continue;
                        try {
                            RtsaRestService.this.setState(ServiceState.RUNNING);
                        }
                        catch (ExecutionException e) {
                            LoggerFactory.getLogger(this.getClass()).error(e.getMessage());
                        }
                    }
                    sc.close();
                    try {
                        RtsaRestService.this.setState(ServiceState.STOPPED);
                    }
                    catch (ExecutionException e) {
                        LoggerFactory.getLogger(this.getClass()).error(e.getMessage());
                    }
                }
            }
        }).start();
    }

    protected String adjustRestQuery(String input) {
        return "{\"data\":[" + input + "]}";
    }

    protected String adjustRestResponse(String response) {
        String result = response.replace("{\"data\":[", "");
        result = result.replace("]}", "");
        return result;
    }

    protected int getWaitTimeBeforeDestroy() {
        return 100;
    }

    public void migrate(String resourceId) throws ExecutionException {
    }

    public void update(URI location) throws ExecutionException {
    }

    public void switchTo(String targetId) throws ExecutionException {
    }

    public void reconfigure(Map<String, String> values) throws ExecutionException {
    }
}

