/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.kiServices.functions.images;

import de.iip_ecosphere.platform.kiServices.functions.images.ImageEncodingDecoding;
import de.iip_ecosphere.platform.kiServices.functions.images.ImageProcessing;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageProcessingTests {
    public static final String TEST_FILE_PATH = "src/test/resources/testImage.jpg";
    public static final String TEST_FILE_OUT_PATH = "src/test/resources/testImageOut1.jpg";

    public static void main(String[] args) {
        try {
            ImageProcessingTests.createB64ImageStringFromImage("src/test/resources/testImageQR1.jpg");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(TEST_FILE_PATH));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BufferedImage result = ImageProcessing.thresholdImage((BufferedImage)image, (int)75);
        try {
            ImageIO.write((RenderedImage)result, "jpg", new File(TEST_FILE_OUT_PATH));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createB64ImageStringFromImage(String path) throws IOException {
        String base64EncodedImage = ImageEncodingDecoding.readImageAsBase64String((String)path);
        FileOutputStream file = new FileOutputStream(new File("src/test/resources/testImageAsBytesb64"));
        file.write(base64EncodedImage.getBytes());
    }

    public static BufferedImage testGrayscaling(BufferedImage image) {
        ImageProcessing.grayScaleImage((BufferedImage)image);
        return image;
    }

    public static BufferedImage testThresholdingImage(BufferedImage image, int threshold) {
        image = ImageProcessing.thresholdImage((BufferedImage)image, (int)threshold);
        return image;
    }

    public static BufferedImage testRescalingOfImage(BufferedImage image, int height, int width) {
        image = ImageProcessing.rescaleImage((BufferedImage)image, (int)height, (int)width);
        return image;
    }
}

