/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime.ssh;

import de.iip_ecosphere.platform.deviceMgt.Credentials;
import de.iip_ecosphere.platform.support.Server;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.SystemUtils;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.shell.ProcessShellFactory;
import org.apache.sshd.server.shell.ShellFactory;
import org.slf4j.LoggerFactory;

public class RemoteAccessServer
implements Server {
    public static final String SSH_HOST = "0.0.0.0";
    public static final int SSH_PORT = 5555;
    private SshServer server;
    private boolean started = false;
    private CredentialsManager credentialsManager = new CredentialsManager();

    RemoteAccessServer() {
    }

    public Server start() {
        if (this.server != null && this.server.isStarted()) {
            this.server = SshServer.setUpDefaultServer();
            this.server.setHost(SSH_HOST);
            this.server.setPort(5555);
            this.server.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(new File("file.ser").toPath()));
            this.server.setPasswordAuthenticator((username, password, session) -> this.credentialsManager.authenticate(username, password));
            if (SystemUtils.IS_OS_WINDOWS) {
                LoggerFactory.getLogger(RemoteAccessServer.class).error("Cannot start Device Management SSH server on Windows.");
                this.server = null;
                return null;
            }
            this.server.setShellFactory((ShellFactory)new ProcessShellFactory("/bin/sh -i -l", new String[]{"/bin/sh", "-i", "-l"}));
            try {
                this.server.start();
                this.started = true;
            }
            catch (IOException e) {
                LoggerFactory.getLogger(RemoteAccessServer.class).error("Cannot start Device Management SSH server: " + e.getMessage());
                this.server = null;
                return null;
            }
        }
        return this;
    }

    public void stop(boolean immediately) {
        if (null != this.server) {
            try {
                this.server.stop(immediately);
                this.started = false;
            }
            catch (IOException e) {
                LoggerFactory.getLogger(RemoteAccessServer.class).error("Stopping Device Management SSH server: " + e.getMessage());
            }
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public CredentialsManager getCredentialsManager() {
        return this.credentialsManager;
    }

    public class CredentialsManager {
        private List<Credentials> credentials = new ArrayList<Credentials>();

        public List<Credentials> getCredentials() {
            return this.credentials;
        }

        public Credentials getCredentials(String key) {
            return this.credentials.stream().filter(ts -> ts.getKey().equals(key)).findFirst().orElse(null);
        }

        public boolean authenticate(String key, String secret) {
            Credentials edgeTunnelSettings = this.getCredentials(key);
            return edgeTunnelSettings != null && edgeTunnelSettings.getSecret().equals(secret);
        }

        public void addCredentials(Credentials credentials) {
            this.credentials.add(credentials);
        }

        public Credentials addGeneratedCredentials() {
            Credentials credentials = new Credentials(UUID.randomUUID().toString().replaceAll("-", "").substring(0, 16), UUID.randomUUID().toString().replaceAll("-", "").substring(0, 16));
            this.credentials.add(credentials);
            return credentials;
        }
    }
}

