/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime.deviceAas;

import de.iip_ecosphere.platform.ecsRuntime.NameplateSetup;
import de.iip_ecosphere.platform.ecsRuntime.deviceAas.DeviceAasProvider;
import de.iip_ecosphere.platform.ecsRuntime.deviceAas.DeviceAasProviderDescriptor;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.types.technicaldata.FurtherInformation;
import de.iip_ecosphere.platform.support.aas.types.technicaldata.GeneralInformation;
import de.iip_ecosphere.platform.support.aas.types.technicaldata.TechnicalDataSubmodel;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.AasUtils;
import de.iip_ecosphere.platform.support.iip_aas.ApplicationSetup;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.support.iip_aas.PlatformAas;
import de.iip_ecosphere.platform.support.iip_aas.config.AbstractSetup;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.LoggerFactory;

public class YamlDeviceAasProvider
extends DeviceAasProvider {
    public static final String SUBMODEL_NAMEPLATE = "Nameplate";
    public static final String NAME_PROPERTY_PRODUCTIMAGE = "ProductImage";
    private String aasAddress = null;

    @Override
    public String getURN() {
        return "urn:::AAS:::" + this.getIdShort() + "#";
    }

    @Override
    public String getIdShort() {
        return AasUtils.fixId((String)("device" + Id.getDeviceIdAas()));
    }

    @Override
    public String getDeviceAasAddress() {
        if (null == this.aasAddress) {
            String id = this.getIdShort();
            String urn = this.getURN();
            AasFactory factory = AasFactory.getInstance();
            Aas aas = null;
            try {
                aas = AasPartRegistry.retrieveAas((String)urn);
            }
            catch (IOException e) {
                try {
                    NameplateSetup nSetup = YamlDeviceAasProvider.obtainNameplateSetup();
                    Aas.AasBuilder aasBuilder = factory.createAasBuilder(id, urn);
                    TechnicalDataSubmodel.TechnicalDataSubmodelBuilder tdBuilder = aasBuilder.createTechnicalDataSubmodelBuilder(null);
                    GeneralInformation.GeneralInformationBuilder giBuilder = tdBuilder.createGeneralInformationBuilder(nSetup.getManufacturerName(), LangString.create((String)nSetup.getManufacturerProductDesignation()), "", "");
                    PlatformAas.createAddress((SubmodelElementContainerBuilder)giBuilder, (ApplicationSetup.Address)nSetup.getAddress());
                    AasUtils.resolveImage((String)nSetup.getProductImage(), (ResourceResolver)AasUtils.CLASSPATH_RESOURCE_RESOLVER, (boolean)false, (n, r, m) -> giBuilder.addProductImageFile(n, r, m));
                    AasUtils.resolveImage((String)nSetup.getManufacturerLogo(), (ResourceResolver)AasUtils.CLASSPATH_RESOURCE_RESOLVER, (boolean)true, (n, r, m) -> giBuilder.setManufacturerLogo(r, m));
                    giBuilder.build();
                    GregorianCalendar now = new GregorianCalendar();
                    XMLGregorianCalendar cal = DatatypeFactory.newInstance().newXMLGregorianCalendar(now);
                    FurtherInformation.FurtherInformationBuilder fiBuilder = tdBuilder.createFurtherInformationBuilder(cal);
                    fiBuilder.build();
                    tdBuilder.createTechnicalPropertiesBuilder().build();
                    tdBuilder.createProductClassificationsBuilder().build();
                    tdBuilder.build();
                    aas = (Aas)aasBuilder.build();
                    AasPartRegistry.remoteDeploy((List)CollectionUtils.addAll(new ArrayList(), (Object[])new Aas[]{aas}));
                }
                catch (IOException | DatatypeConfigurationException e1) {
                    LoggerFactory.getLogger(this.getClass()).error("Creating nameplate AAS: {}", (Object)e.getMessage());
                }
            }
            if (null != aas) {
                try {
                    Registry reg = factory.obtainRegistry(AasPartRegistry.getSetup().getRegistryEndpoint());
                    this.aasAddress = reg.getEndpoint(aas);
                    LoggerFactory.getLogger(this.getClass()).info("Device AAS address for {}/{}: {}", new Object[]{id, urn, this.aasAddress});
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Obtaining factory/endpoint: {}", (Object)e.getMessage());
                }
            }
        }
        return this.aasAddress;
    }

    public static NameplateSetup obtainNameplateSetup() throws IOException {
        InputStream is = AasUtils.CLASSPATH_RESOURCE_RESOLVER.resolve("nameplate.yml");
        if (null == is) {
            try {
                is = new FileInputStream("src/test/resources/nameplate.yml");
            }
            catch (IOException e) {
                LoggerFactory.getLogger(YamlDeviceAasProvider.class).info("Checking AAS for id {}", (Object)Id.getDeviceId());
                is = AasUtils.CLASSPATH_RESOURCE_RESOLVER.resolve(Id.getDeviceId().toUpperCase() + ".yml");
            }
        }
        return (NameplateSetup)AbstractSetup.readFromYaml(NameplateSetup.class, (InputStream)is);
    }

    public static class Descriptor
    implements DeviceAasProviderDescriptor {
        @Override
        public DeviceAasProvider createInstance() {
            return new YamlDeviceAasProvider();
        }

        @Override
        public boolean createsMultiProvider() {
            return false;
        }
    }
}

