/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime.deviceAas;

import de.iip_ecosphere.platform.ecsRuntime.deviceAas.DeviceAasProvider;
import de.iip_ecosphere.platform.ecsRuntime.deviceAas.DeviceAasProviderDescriptor;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.support.net.UriResolver;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public class AasxDeviceAasProvider
extends DeviceAasProvider {
    private String aasAddress = null;
    private String identifier;
    private String idShort;

    @Override
    public String getURN() {
        return this.identifier;
    }

    @Override
    public String getIdShort() {
        return this.idShort;
    }

    @Override
    public String getDeviceAasAddress() {
        if (null == this.aasAddress) {
            List<Aas> loadedAas;
            try {
                loadedAas = AasxDeviceAasProvider.obtainAas();
            }
            catch (IOException e) {
                loadedAas = null;
                LoggerFactory.getLogger(this.getClass()).error("Loading device AASX: {}", (Object)e.getMessage());
            }
            Aas aas = null;
            if (null != loadedAas) {
                ArrayList<Aas> toDeploy = new ArrayList<Aas>();
                for (Aas a : loadedAas) {
                    if (null == aas) {
                        aas = a;
                        this.identifier = a.getIdentification();
                        this.idShort = aas.getIdShort();
                    }
                    try {
                        AasPartRegistry.retrieveAas((String)a.getIdentification());
                    }
                    catch (IOException e) {
                        toDeploy.add(a);
                    }
                }
                if (!toDeploy.isEmpty()) {
                    try {
                        AasPartRegistry.remoteDeploy(toDeploy);
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Deploying device AASX: {}", (Object)e.getMessage());
                    }
                }
            }
            if (null != aas) {
                try {
                    Registry reg = AasFactory.getInstance().obtainRegistry(AasPartRegistry.getSetup().getRegistryEndpoint());
                    this.aasAddress = reg.getEndpoint(aas);
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Obtaining factory/endpoint: {}", (Object)e.getMessage());
                }
            } else {
                LoggerFactory.getLogger(this.getClass()).warn("No device AAS found");
            }
        }
        return this.aasAddress;
    }

    private static List<Aas> obtainAas() throws IOException {
        List result = null;
        ClassLoader loader = AasxDeviceAasProvider.class.getClassLoader();
        URL url = loader.getResource("device.aasx");
        if (null == url) {
            File f = new File("src/test/resources/device.aasx");
            if (f.exists()) {
                url = f.toURI().toURL();
            } else {
                LoggerFactory.getLogger(AasxDeviceAasProvider.class).info("Checking AAS for id {}", (Object)Id.getDeviceId());
                url = loader.getResource(Id.getDeviceId().toUpperCase() + ".aasx");
            }
        }
        if (null != url) {
            try {
                File aasxFile = UriResolver.resolveToFile((URI)url.toURI(), null);
                result = AasFactory.getInstance().createPersistenceRecipe().readFrom(aasxFile);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return result;
    }

    public static class Descriptor
    implements DeviceAasProviderDescriptor {
        @Override
        public DeviceAasProvider createInstance() {
            return new AasxDeviceAasProvider();
        }

        @Override
        public boolean createsMultiProvider() {
            return false;
        }
    }
}

