/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime;

import de.iip_ecosphere.platform.ecsRuntime.EcsFactory;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MetricsAasConstructor;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.transport.Transport;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.LoggerFactory;

public class Monitor {
    public static final String TRANSPORT_METRICS_CHANNEL = "EcsMetrics";
    private static MetricsProvider provider = new MetricsProvider((MeterRegistry)new SimpleMeterRegistry());
    private static Timer timer = new Timer();
    private static boolean update = false;

    static MetricsProvider getMetricsProvider() {
        return provider;
    }

    public static void startScheduling() {
        final String id = Id.getDeviceId();
        Transport.createConnector();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                provider.calculateMetrics();
                if (null != Transport.getConnector()) {
                    try {
                        Transport.getConnector().asyncSend(Monitor.TRANSPORT_METRICS_CHANNEL, (Object)provider.toJson(id, update, new MeterFilter[0]));
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(Monitor.class).error("Cannot sent monitoring message: " + e.getMessage());
                    }
                    update = true;
                }
            }
        }, 0L, (long)EcsFactory.getSetup().getMonitoringUpdatePeriod());
    }

    public static void stopScheduling() {
        MetricsAasConstructor.clear();
        timer.cancel();
        Transport.releaseConnector();
    }
}

