/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime;

import de.iip_ecosphere.platform.ecsRuntime.ContainerManager;
import de.iip_ecosphere.platform.ecsRuntime.EcsFactoryDescriptor;
import de.iip_ecosphere.platform.ecsRuntime.EcsSetup;
import de.iip_ecosphere.platform.support.iip_aas.config.AbstractSetup;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import java.io.IOException;
import java.util.Optional;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EcsFactory.class.getName());
    private static EcsFactoryDescriptor desc;
    private static ContainerManager manager;
    private static EcsSetup conf;

    private static void init() {
        if (null == desc) {
            ServiceLoader<EcsFactoryDescriptor> loader = ServiceLoader.load(EcsFactoryDescriptor.class);
            Optional first = ServiceLoaderUtils.findFirst(loader);
            if (first.isPresent()) {
                desc = (EcsFactoryDescriptor)first.get();
            } else {
                LOGGER.info("No container manager available. No container operations offered in AAS.");
            }
        }
        if (null == conf) {
            if (null != desc) {
                conf = desc.getConfiguration();
            } else {
                try {
                    conf = (EcsSetup)((Object)AbstractSetup.readFromYaml(EcsSetup.class));
                }
                catch (IOException e) {
                    conf = new EcsSetup();
                    LOGGER.error("No configuration, falling back to default " + e.getMessage());
                }
            }
        }
    }

    public static ContainerManager getContainerManager() {
        if (null == manager) {
            EcsFactory.init();
            if (null != desc && null != (manager = desc.createContainerManagerInstance())) {
                LOGGER.info("Container manager implementation registered: " + manager.getClass().getName());
            }
        }
        return manager;
    }

    public static EcsSetup getSetup() {
        if (null == conf) {
            EcsFactory.init();
        }
        return conf;
    }

    static {
        manager = null;
    }
}

