/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime;

import de.iip_ecosphere.platform.ecsRuntime.ContainerDescriptor;
import de.iip_ecosphere.platform.ecsRuntime.ContainerState;
import de.iip_ecosphere.platform.support.iip_aas.Version;
import de.iip_ecosphere.platform.support.iip_aas.config.AbstractSetup;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.slf4j.LoggerFactory;

public class BasicContainerDescriptor
implements ContainerDescriptor {
    private String id;
    private String name;
    private Version version;
    private ContainerState state;
    private URI uri;
    private String imageFile;

    public BasicContainerDescriptor() {
    }

    protected BasicContainerDescriptor(String id, String name, Version version, URI uri) {
        if (null == id || id.length() == 0) {
            throw new IllegalArgumentException("id must not be null or empty");
        }
        if (null == name || name.length() == 0) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        if (null == version) {
            throw new IllegalArgumentException("version must not be null");
        }
        this.id = id;
        this.name = name;
        this.version = version;
        this.state = ContainerState.AVAILABLE;
        this.setUri(uri);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public void setState(ContainerState state) {
        if (null != state) {
            this.state = state;
        }
    }

    @Override
    public ContainerState getState() {
        return this.state;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        if (null == uri) {
            throw new IllegalArgumentException("uri must not be null");
        }
        this.uri = uri.normalize();
    }

    public void setImageFile(String imageFile) {
        this.imageFile = imageFile;
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public void setDockerImageZipfile(String dockerImageZipfile) {
        this.imageFile = dockerImageZipfile;
    }

    public String getDockerImageZipfile() {
        return this.imageFile;
    }

    public static BasicContainerDescriptor readFromYamlFile(File file) {
        BasicContainerDescriptor result = null;
        try {
            FileInputStream in = new FileInputStream(file);
            result = BasicContainerDescriptor.readFromYaml(in, file.toURI());
        }
        catch (FileNotFoundException e) {
            LoggerFactory.getLogger(BasicContainerDescriptor.class).error("Reading container descriptor: " + e.getMessage());
        }
        return result;
    }

    public static BasicContainerDescriptor readFromYaml(InputStream in, URI uri) {
        BasicContainerDescriptor result = null;
        if (in != null) {
            try {
                result = (BasicContainerDescriptor)AbstractSetup.readFromYaml(BasicContainerDescriptor.class, (InputStream)in);
                result.setUri(uri);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(BasicContainerDescriptor.class).error("Reading container descriptor: " + e.getMessage());
            }
        }
        return result;
    }
}

