/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime;

import de.iip_ecosphere.platform.ecsRuntime.BasicContainerDescriptor;
import de.iip_ecosphere.platform.ecsRuntime.ContainerDescriptor;
import de.iip_ecosphere.platform.ecsRuntime.ContainerManager;
import de.iip_ecosphere.platform.ecsRuntime.ContainerState;
import de.iip_ecosphere.platform.ecsRuntime.EcsAas;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.slf4j.LoggerFactory;

public abstract class AbstractContainerManager<C extends ContainerDescriptor>
implements ContainerManager {
    private Map<String, C> containers = Collections.synchronizedMap(new HashMap());

    @Override
    public Set<String> getIds() {
        return this.containers.keySet();
    }

    public Collection<C> getContainers() {
        return this.containers.values();
    }

    public C getContainer(String id) {
        return (C)((ContainerDescriptor)this.containers.get(id));
    }

    @Override
    public ContainerState getState(String id) {
        ContainerDescriptor d;
        ContainerState result = ContainerState.UNKNOWN;
        if (null != id && null != (d = (ContainerDescriptor)this.containers.get(id))) {
            result = d.getState();
        }
        return result;
    }

    protected String addContainer(String id, C descriptor) throws ExecutionException {
        this.checkId(id, "id");
        if (this.containers.containsKey(id)) {
            this.throwExecutionException(null, "Container id '" + id + "' is already known");
        }
        this.containers.put(id, descriptor);
        EcsAas.notifyContainerAdded(descriptor);
        return id;
    }

    @Override
    public void undeployContainer(String id) throws ExecutionException {
        ContainerDescriptor desc;
        this.checkId(id, "id");
        if (!this.containers.containsKey(id)) {
            this.throwExecutionException("Undeploying container " + id, "Container is not known. Cannot migrate container.");
        }
        if (ContainerState.AVAILABLE == (desc = (ContainerDescriptor)this.containers.get(id)).getState() || ContainerState.STOPPED == desc.getState()) {
            this.containers.remove(id);
            EcsAas.notifyContainerRemoved(desc);
        } else {
            this.throwExecutionException("Undeploying container " + id, "Container is in state " + (Object)((Object)desc.getState()) + ". Cannot undeploy container.");
        }
    }

    protected void setState(BasicContainerDescriptor container, ContainerState state) throws ExecutionException {
        ContainerState.validateTransition(container.getState(), state);
        container.setState(state);
        EcsAas.notifyContainerStateChanged(container);
    }

    protected C getContainer(String id, String idText, String activityText) throws ExecutionException {
        Optional<ContainerDescriptor> fallback;
        this.checkId(id, idText);
        ContainerDescriptor result = (ContainerDescriptor)this.containers.get(id);
        if (null == result && (fallback = this.containers.values().stream().filter(c -> id.equals(c.getUri().toString())).findAny()).isPresent()) {
            result = fallback.get();
        }
        if (null == result) {
            this.throwExecutionException(null, "Container id '" + id + "' is not known. Cannot " + activityText + " container.");
        }
        return (C)result;
    }

    protected void checkId(String id, String text) throws ExecutionException {
        if (null == id || id.length() == 0) {
            this.throwExecutionException(null, "Container " + text + "must be given (not null or empty)");
        }
    }

    @Override
    public void migrateContainer(String id, String resourceId) throws ExecutionException {
        ContainerDescriptor desc;
        this.checkId(id, "id");
        if (!this.containers.containsKey(id)) {
            this.throwExecutionException("Migrating container " + id, "Container is not known. Cannot migrate container.");
        }
        if (ContainerState.DEPLOYED == (desc = (ContainerDescriptor)this.containers.get(id)).getState()) {
            this.stopContainer(id);
        } else {
            this.throwExecutionException("Migrating container " + id, "Container is in state " + (Object)((Object)desc.getState()) + ". Cannot undeploy container.");
        }
    }

    protected void throwExecutionException(String action, Throwable th) throws ExecutionException {
        action = action != null && action.length() > 0 ? action + ":" : "";
        LoggerFactory.getLogger(this.getClass()).error(action + th.getMessage());
        throw new ExecutionException(th);
    }

    protected void throwExecutionException(String action, String message) throws ExecutionException {
        action = action != null && action.length() > 0 ? action + ":" : "";
        LoggerFactory.getLogger(this.getClass()).error(action + message);
        throw new ExecutionException(message, null);
    }
}

