/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime.lxc;

import au.com.jcloud.lxd.bean.LxdServerCredential;
import au.com.jcloud.lxd.enums.ContainerStateAction;
import au.com.jcloud.lxd.enums.RemoteServer;
import au.com.jcloud.lxd.model.Container;
import au.com.jcloud.lxd.model.Image;
import au.com.jcloud.lxd.service.ILinuxCliService;
import au.com.jcloud.lxd.service.ILxdApiService;
import au.com.jcloud.lxd.service.ILxdService;
import au.com.jcloud.lxd.service.impl.LinuxCliServiceImpl;
import au.com.jcloud.lxd.service.impl.LxdApiServiceImpl;
import au.com.jcloud.lxd.service.impl.LxdServiceImpl;
import de.iip_ecosphere.platform.ecsRuntime.AbstractContainerManager;
import de.iip_ecosphere.platform.ecsRuntime.ContainerManager;
import de.iip_ecosphere.platform.ecsRuntime.EcsFactory;
import de.iip_ecosphere.platform.ecsRuntime.EcsFactoryDescriptor;
import de.iip_ecosphere.platform.ecsRuntime.EcsSetup;
import de.iip_ecosphere.platform.ecsRuntime.lxc.LxcContainerDescriptor;
import de.iip_ecosphere.platform.ecsRuntime.lxc.LxcSetup;
import de.iip_ecosphere.platform.support.net.UriResolver;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LxcContainerManager
extends AbstractContainerManager<LxcContainerDescriptor> {
    private static LxcSetup config = LxcSetup.readFromYaml();
    private static final Logger LOGGER = LoggerFactory.getLogger(LxcContainerManager.class);

    public String addContainer(URI location) throws ExecutionException {
        String containerName = null;
        LOGGER.info("Adding container at " + location + "...");
        try {
            LxcSetup setup = (LxcSetup)EcsFactory.getSetup();
            String downloadDirectory = setup.getLxc().getDownloadDirectory();
            File downloadDir = new File(downloadDirectory);
            Object pathToYaml = location.toString();
            if (((String)pathToYaml).endsWith("/")) {
                pathToYaml = (String)pathToYaml + setup.getLxc().getLxcImageYamlFilename();
            }
            URI yamlURI = new URI((String)pathToYaml);
            File imageInfo = this.resolveUri(yamlURI, downloadDir);
            LxcContainerDescriptor container = LxcContainerDescriptor.readFromYamlFile(imageInfo);
            LinuxCliServiceImpl lxcCliService = new LinuxCliServiceImpl();
            ILxdService lxcClient = this.getLxcClient();
            if (lxcClient == null) {
                this.throwExecutionException("Adding container failed", "Could not connect to the LXC daemon");
            }
            String lxcImageName = this.getImageAlias(container);
            String lxcImageFingerprint = this.getLxcId(container);
            containerName = container.getName().trim().replaceAll("\\s", "_");
            if (this.getLxcId(container) == null && !lxcImageName.contains(":")) {
                lxcImageFingerprint = ((Image)lxcClient.loadImageMap().get(lxcImageName)).getFingerprint();
            }
            if (lxcClient.loadContainer(containerName) == null && lxcImageFingerprint != null) {
                LOGGER.info("Creating container from " + lxcImageName + " as " + containerName);
                lxcClient.createContainer(containerName, lxcImageFingerprint);
            } else if (lxcClient.loadContainer(containerName) == null && lxcImageFingerprint == null) {
                LOGGER.info("Creating container from " + lxcImageName + " as " + containerName);
                lxcCliService.executeLinuxCmd("lxc init " + lxcImageName + " " + containerName);
            } else {
                LOGGER.info("Container with the same name already exists or Remote Server cant be reached");
            }
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            this.throwExecutionException("Adding container failed", e);
        }
        return containerName;
    }

    public String addContainerFromTarball(URI location) throws ExecutionException {
        String workingDir = System.getProperty("user.dir");
        String homeDir = workingDir + "/src/test/resources/";
        String containerName = null;
        LOGGER.info("Adding container at " + location + "...");
        try {
            LxcSetup setup = (LxcSetup)EcsFactory.getSetup();
            String downloadDirectory = setup.getLxc().getDownloadDirectory();
            File downloadDir = new File(downloadDirectory);
            Object pathToYaml = location.toString();
            if (((String)pathToYaml).endsWith("/")) {
                pathToYaml = (String)pathToYaml + "image-info-template.yml";
            }
            System.out.println("Path to YAML: " + (String)pathToYaml);
            URI yamlURI = new URI((String)pathToYaml);
            File imageInfo = UriResolver.resolveToFile((URI)yamlURI, (File)downloadDir);
            LxcContainerDescriptor container = LxcContainerDescriptor.readFromYamlFile(imageInfo);
            ILxdService lxcClient = this.getLxcClient();
            if (lxcClient == null) {
                this.throwExecutionException("Adding container failed", "Could not connect to the LXC daemon");
            }
            LinuxCliServiceImpl lxcCliService = new LinuxCliServiceImpl();
            String lxcImageName = this.getImageAlias(container);
            String lxcImageTar = homeDir + this.getZip(container);
            containerName = container.getName().trim().replaceAll("\\s", "_");
            String fingerprint = null;
            String executed = null;
            if (!lxcClient.loadImageAliasMap().containsKey(lxcImageName)) {
                LOGGER.info("Trying to import image " + lxcImageName);
                executed = lxcCliService.executeLinuxCmd("lxc image import " + lxcImageTar + " --alias " + lxcImageName);
                if (!executed.isEmpty()) {
                    fingerprint = ((Image)lxcClient.loadImageMap().get(lxcImageName)).getFingerprint();
                } else {
                    LOGGER.info("Image with different name but same fingerprint already exists.");
                }
            } else {
                LOGGER.info("Image with same name already exists");
            }
            if (fingerprint != null) {
                if (lxcClient.loadContainer(containerName) == null) {
                    LOGGER.info("Creating container: " + containerName);
                    lxcClient.createContainer(containerName, fingerprint);
                } else {
                    LOGGER.info("Container with the same name already exists");
                }
            }
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            this.throwExecutionException("Adding container failed", e);
        }
        return containerName;
    }

    private String getImageAlias(LxcContainerDescriptor desc) {
        return desc.getLxcImageAlias();
    }

    private String getZip(LxcContainerDescriptor desc) {
        return desc.getLxcZip();
    }

    private String getLxcId(LxcContainerDescriptor desc) {
        return desc.getId();
    }

    public ILxdService getLxcClient() {
        LxcSetup config = LxcSetup.readFromYaml();
        String lxchost = config.getLxc().getLxcHost();
        String lxcport = config.getLxc().getLxcPort();
        LxdServiceImpl service = new LxdServiceImpl();
        LxdApiServiceImpl lxdApiService = new LxdApiServiceImpl();
        LinuxCliServiceImpl linuxCliService = new LinuxCliServiceImpl();
        lxdApiService.setLinuxCliService((ILinuxCliService)linuxCliService);
        service.setLxdApiService((ILxdApiService)lxdApiService);
        LxdServerCredential credential = new LxdServerCredential(lxchost + ":" + lxcport, System.getProperty("snap_cert"), System.getProperty("snap_key"));
        service.setLxdServerCredential(credential);
        try {
            service.loadServerInfo();
        }
        catch (Exception e) {
            LOGGER.warn("Obtaining LXC client(): " + e.getMessage());
            service = null;
        }
        return service;
    }

    public void startContainer(String name) throws ExecutionException {
        LOGGER.info("Starting container " + name);
        ILxdService lxcClient = this.getLxcClient();
        if (lxcClient == null) {
            this.throwExecutionException("Starting container failed", "Could not connect to the LXC daemon.");
        }
        try {
            lxcClient.startContainer(name);
        }
        catch (IOException | InterruptedException e) {
            this.throwExecutionException("Starting container failed", e);
        }
        LOGGER.info("Container " + name + " started");
    }

    public void stopContainer(String name) throws ExecutionException {
        LOGGER.info("Stopping container " + name);
        ILxdService lxcClient = this.getLxcClient();
        if (lxcClient == null) {
            this.throwExecutionException("Stopping container failed", "Could not connect to the LXC daemon.");
        }
        try {
            lxcClient.stopContainer(name);
        }
        catch (IOException | InterruptedException e) {
            this.throwExecutionException("Stopping container failed", e);
        }
        LOGGER.info("Container " + name + " stopped");
    }

    public void deleteContainer(String name) throws ExecutionException {
        LOGGER.info("Deleting container " + name);
        ILxdService lxcClient = this.getLxcClient();
        if (lxcClient == null) {
            this.throwExecutionException("Deleting container failed", "Could not connect to the LXC daemon.");
        }
        try {
            lxcClient.deleteContainer(name);
        }
        catch (IOException | InterruptedException e) {
            this.throwExecutionException("Deleting container failed", e);
        }
        LOGGER.info("Container " + name + " deleted");
    }

    public void freezeContainer(String name) throws ExecutionException {
        LOGGER.info("Freezing container " + name);
        ILxdService lxcClient = this.getLxcClient();
        if (lxcClient == null) {
            this.throwExecutionException("Freezing container failed", "Could not connect to the LXC daemon.");
        }
        try {
            lxcClient.changeContainerState(name, ContainerStateAction.FREEZE, false, false, "");
        }
        catch (IOException | InterruptedException e) {
            this.throwExecutionException("Freezing container failed", e);
        }
        LOGGER.info("Container " + name + " freezed");
    }

    public void unfreezeContainer(String name) throws ExecutionException {
        LOGGER.info("Unfreezing container " + name);
        ILxdService lxcClient = this.getLxcClient();
        if (lxcClient == null) {
            this.throwExecutionException("Unfreezing container failed", "Could not connect to the LXC daemon.");
        }
        try {
            lxcClient.changeContainerState(name, ContainerStateAction.UNFREEZE, false, false, "");
        }
        catch (IOException | InterruptedException e) {
            this.throwExecutionException("Unfreezing container failed", e);
        }
        LOGGER.info("Container " + name + " unfreezed");
    }

    public void createSnapshot(String containerName, String snapshot) throws ExecutionException {
        LOGGER.info("Creating snapshot of: " + containerName);
        ILxdService lxcClient = this.getLxcClient();
        if (lxcClient == null) {
            this.throwExecutionException("Creating snapshot failed", "Could not connect to the LXC daemon.");
        }
        try {
            lxcClient.createSnapshot(containerName, snapshot);
        }
        catch (IOException | InterruptedException e) {
            this.throwExecutionException("Creating snapshot failed", e);
        }
        LOGGER.info("Snapshot of: " + containerName + " created");
    }

    public void publishImage(String containerName, String snapshot, String imageAlias, boolean isPublic) throws ExecutionException {
        LOGGER.info("Publishing image of: " + containerName);
        ILxdService lxcClient = this.getLxcClient();
        if (lxcClient == null) {
            this.throwExecutionException("Publishing image failed", "Could not connect to the LXC daemon.");
        }
        LinuxCliServiceImpl lxcCliService = new LinuxCliServiceImpl();
        try {
            if (isPublic) {
                lxcCliService.executeLinuxCmd("lxc publish " + containerName + "/" + snapshot + " --alias " + imageAlias + " --public");
            } else {
                lxcCliService.executeLinuxCmd("lxc publish " + containerName + "/" + snapshot + " --alias " + imageAlias);
            }
        }
        catch (IOException | InterruptedException e) {
            this.throwExecutionException("Publishing image failed", e);
        }
        LOGGER.info("Image of: " + containerName + " created");
    }

    public void exportImage(String imageAlias) throws ExecutionException {
        String homeDir = System.getProperty("user.home");
        LOGGER.info("Exporting image : " + imageAlias);
        ILxdService lxcClient = this.getLxcClient();
        if (lxcClient == null) {
            this.throwExecutionException("Exporting image failed", "Could not connect to the LXC daemon.");
        }
        LinuxCliServiceImpl lxcCliService = new LinuxCliServiceImpl();
        try {
            lxcCliService.executeLinuxCmd("lxc image export " + imageAlias + " " + homeDir + "/" + imageAlias);
        }
        catch (IOException | InterruptedException e) {
            this.throwExecutionException("Exporting image failed", e);
        }
        LOGGER.info("Image : " + imageAlias + " exported to " + homeDir);
    }

    public void importImage(String tarball, String imageAlias) throws ExecutionException {
        LOGGER.info("Importing image as : " + imageAlias);
        ILxdService lxcClient = this.getLxcClient();
        if (lxcClient == null) {
            this.throwExecutionException("Importing image failed", "Could not connect to the LXC daemon.");
        }
        LinuxCliServiceImpl lxcCliService = new LinuxCliServiceImpl();
        try {
            lxcCliService.executeLinuxCmd("lxc image import " + tarball + " --alias " + imageAlias);
        }
        catch (IOException | InterruptedException e) {
            this.throwExecutionException("Importing image failed", e);
        }
        LOGGER.info("Image from: " + tarball + " imported as " + imageAlias);
    }

    public void copyImageFromRemote(RemoteServer remote, String remoteImage, String imageAlias) throws ExecutionException {
        LOGGER.info("Copying Image from : " + remote.getName());
        ILxdService lxcClient = this.getLxcClient();
        if (lxcClient == null) {
            this.throwExecutionException("Copying image failed", "Could not connect to the LXC daemon.");
        }
        LinuxCliServiceImpl lxcCliService = new LinuxCliServiceImpl();
        try {
            lxcCliService.executeLinuxCmd("lxc image copy " + remote.getName() + ":" + remoteImage + " local: --alias " + imageAlias);
        }
        catch (IOException | InterruptedException e) {
            this.throwExecutionException("Copying image failed", e);
        }
        LOGGER.info("Image from: " + remote.getName() + " imported as " + imageAlias);
    }

    public String getContainerSystemName() {
        return "LXC";
    }

    public String getRuntimeName() {
        return "IIP-Ecosphere LXC ECS-Runtime";
    }

    public String getContainerSystemVersion() {
        LxcContainerManager cm = (LxcContainerManager)EcsFactory.getContainerManager();
        ILxdService lxcClient = cm.getLxcClient();
        if (lxcClient == null) {
            return "";
        }
        return "";
    }

    public void updateContainer(String id, URI location) throws ExecutionException {
    }

    public String getLxcName(String name) throws ExecutionException {
        ILxdService lxcClient = this.getLxcClient();
        if (lxcClient == null) {
            this.throwExecutionException("Getting container's id failed", "Could not connect to the LXC daemon.");
        }
        Collection containers = null;
        try {
            containers = lxcClient.loadContainerMap().values();
            if (containers.size() == 0) {
                return null;
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        for (Container container : containers) {
            if (!container.getName().equals(name)) continue;
            return container.getName();
        }
        return null;
    }

    public static class FactoryDescriptor
    implements EcsFactoryDescriptor {
        public ContainerManager createContainerManagerInstance() {
            return new LxcContainerManager();
        }

        public EcsSetup getConfiguration() {
            return config;
        }
    }
}

