/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime.lxc;

import de.iip_ecosphere.platform.ecsRuntime.BasicContainerDescriptor;
import de.iip_ecosphere.platform.ecsRuntime.lxc.LxcSetup;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.support.iip_aas.Version;
import de.iip_ecosphere.platform.support.iip_aas.config.AbstractSetup;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public class LxcContainerDescriptor
extends BasicContainerDescriptor {
    public static final String PORT_PLACEHOLDER = "${port}";
    public static final String PORT_PLACEHOLDER_1 = "${port_1}";
    private static int instanceCount = 0;
    private int instance = instanceCount++;
    private String lxcId;
    private String lxcImageAlias;
    private String lxcZip;
    private String networkMode;
    private ArrayList<String> exposedPorts = new ArrayList();
    private ArrayList<String> env = new ArrayList();

    public LxcContainerDescriptor() {
    }

    protected LxcContainerDescriptor(String id, String name, Version version, URI uri) {
        super(id, name, version, uri);
    }

    public void setId(String lxcId) {
        this.lxcId = lxcId;
    }

    public String getId() {
        return this.lxcId;
    }

    public void setLxcImageAlias(String lxcImageAlias) {
        this.lxcImageAlias = lxcImageAlias;
    }

    public String getLxcImageAlias() {
        return this.lxcImageAlias;
    }

    public String getLxcZip() {
        return this.lxcZip;
    }

    public void setLxcZip(String lxcZip) {
        this.lxcZip = lxcZip;
    }

    public void setExposedPorts(ArrayList<String> exposedPorts) {
        if (null != exposedPorts) {
            this.exposedPorts = exposedPorts;
        }
    }

    public ArrayList<String> getExposedPorts() {
        return this.exposedPorts;
    }

    public void setEnv(ArrayList<String> env) {
        if (null != env) {
            this.env = env;
        }
    }

    public String getNetworkMode() {
        return this.networkMode;
    }

    public ArrayList<String> getEnv() {
        return this.env;
    }

    public void setNetworkMode(String networkMode) {
        this.networkMode = networkMode;
    }

    public List<String> instantiateEnv(int port, int port1) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.env) {
            result.add(s.replace(PORT_PLACEHOLDER, String.valueOf(port)).replace(PORT_PLACEHOLDER_1, String.valueOf(port1)));
        }
        return result;
    }

    public boolean requiresPort(String placeholder) {
        boolean result = false;
        for (String s : this.env) {
            if (!s.contains(placeholder)) continue;
            result = true;
            break;
        }
        if (!result) {
            for (String e : this.exposedPorts) {
                if (!e.contains(placeholder)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public String getNetKey() {
        return Id.getDeviceId() + "_" + this.lxcImageAlias + "_" + this.instance;
    }

    public String getNetKey1() {
        return Id.getDeviceId() + "_" + this.lxcImageAlias + "_1_" + this.instance;
    }

    public static LxcContainerDescriptor readFromYamlFile(File file) {
        LxcContainerDescriptor result = null;
        try {
            FileInputStream in = new FileInputStream(file);
            result = LxcContainerDescriptor.readFromYaml(in, file.toURI());
        }
        catch (FileNotFoundException e) {
            LoggerFactory.getLogger(LxcContainerDescriptor.class).error("Reading container descriptor: " + e.getMessage());
        }
        return result;
    }

    public static LxcContainerDescriptor readFromYaml(InputStream in, URI uri) {
        LxcContainerDescriptor result = null;
        if (in != null) {
            try {
                result = (LxcContainerDescriptor)((Object)AbstractSetup.readFromYaml(LxcContainerDescriptor.class, (InputStream)in));
                result.setUri(uri);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(LxcContainerDescriptor.class).error("Reading container descriptor: " + e.getMessage());
            }
        }
        return result;
    }

    public static String getRepository(String imgName) {
        String reg;
        int pos;
        String result = imgName;
        String tag = LxcContainerDescriptor.getTag(imgName);
        if (LxcSetup.isNotEmpty((String)tag) && (pos = imgName.lastIndexOf(58)) > 0) {
            result = imgName.substring(0, pos);
        }
        if (LxcSetup.isNotEmpty((String)(reg = LxcContainerDescriptor.getRegistry(result)))) {
            result = result.substring(reg.length() + 1);
        }
        return result;
    }

    public static String getRegistry(String imgName) {
        int lastPos;
        int pos = imgName.indexOf(47);
        String result = pos > 0 ? (pos != (lastPos = imgName.lastIndexOf(47)) ? imgName.substring(0, pos) : "") : "";
        return result;
    }

    public static String getTag(String imgName) {
        int pos = imgName.lastIndexOf(47);
        if (pos > 0) {
            imgName = imgName.substring(pos + 1);
        }
        String result = (pos = imgName.lastIndexOf(58)) > 0 ? imgName.substring(pos + 1) : "";
        return result;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            LxcContainerDescriptor desc = LxcContainerDescriptor.readFromYamlFile(new File(args[0]));
            System.out.println("Descriptor (may be hash): " + desc);
        } else {
            System.out.println("First arg must be file to read");
        }
    }
}

