/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.minio;

import de.iip_ecosphere.platform.deviceMgt.DeviceMgtSetup;
import de.iip_ecosphere.platform.deviceMgt.minio.S3PackageStorage;
import de.iip_ecosphere.platform.deviceMgt.storage.PackageStorageSetup;
import de.iip_ecosphere.platform.deviceMgt.storage.Storage;
import de.iip_ecosphere.platform.deviceMgt.storage.StorageFactoryDescriptor;
import de.iip_ecosphere.platform.support.identities.IdentityStore;
import de.iip_ecosphere.platform.support.identities.IdentityToken;
import io.minio.MinioClient;
import org.slf4j.LoggerFactory;

public class S3StorageFactoryDescriptor
implements StorageFactoryDescriptor {
    public Storage createRuntimeStorage(DeviceMgtSetup configuration) {
        if (null == configuration) {
            return null;
        }
        return this.createPackageStorage(configuration.getRuntimeStorage());
    }

    public Storage createConfigStorage(DeviceMgtSetup configuration) {
        if (null == configuration) {
            return null;
        }
        return this.createPackageStorage(configuration.getConfigStorage());
    }

    public Storage createPackageStorage(PackageStorageSetup storageSetup) {
        if (null == storageSetup) {
            return null;
        }
        MinioClient.Builder minioClientBuilder = MinioClient.builder().endpoint(storageSetup.getEndpoint()).region(storageSetup.getRegion());
        String authKey = storageSetup.getAuthenticationKey();
        if (null != authKey && authKey.length() > 0) {
            IdentityToken tok = IdentityStore.getInstance().getToken(authKey, new String[0]);
            if (null != tok) {
                if (IdentityToken.TokenType.USERNAME == tok.getType()) {
                    minioClientBuilder.credentials(tok.getUserName(), tok.getTokenDataAsString());
                } else {
                    LoggerFactory.getLogger(this.getClass()).warn("Identity token for key {} is of type {}. Only USERNAME tokens are supported. Trying without authentication.", (Object)authKey, (Object)tok.getType());
                }
            } else {
                LoggerFactory.getLogger(this.getClass()).warn("No identity token for key {} found. Trying without authentication.", (Object)authKey);
            }
        }
        return new S3PackageStorage(minioClientBuilder.build(), storageSetup.getBucket(), storageSetup.getPrefix(), storageSetup.getPackageDescriptor(), storageSetup.getPackageFilename());
    }
}

