/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.model;

import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import java.io.IOException;
import org.slf4j.LoggerFactory;

public interface ModelAccessProvider {
    public ModelAccess getModelAccess();

    public void setModelAccess(ModelAccess var1);

    public static boolean optional(ModelAccess modelAccess, IOVoidFunction func) {
        boolean success = true;
        try {
            func.execute(modelAccess);
        }
        catch (IOException | IndexOutOfBoundsException e) {
            LoggerFactory.getLogger(IOVoidFunction.class).debug("Function call failed, but considered optional. " + e.getMessage());
            success = false;
        }
        return success;
    }

    public static ModelAccess optionalStep(ModelAccess modelAccess, IOModelAccessFunction func) {
        ModelAccess result = modelAccess;
        try {
            result = func.execute(modelAccess);
        }
        catch (IOException | IndexOutOfBoundsException e) {
            LoggerFactory.getLogger(IOVoidFunction.class).debug("Function call failed, but considered optional. " + e.getMessage());
            result = modelAccess;
        }
        return result;
    }

    public static interface IOModelAccessFunction {
        public ModelAccess execute(ModelAccess var1) throws IOException, IndexOutOfBoundsException;
    }

    public static interface IOVoidFunction {
        public void execute(ModelAccess var1) throws IOException, IndexOutOfBoundsException;
    }
}

